/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc;

import com.mojang.datafixers.util.Pair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ColoredMapHandler {
    protected static int DITHERING = 1;
    public static final CustomMapData.Type<ColorData> COLOR_DATA = MapDataRegistry.registerCustomMapSavedData((ResourceLocation)Supplementaries.res("color_data"), ColorData::new);

    public static void init() {
    }

    public static ColorData getColorData(MapItemSavedData data) {
        return (ColorData)COLOR_DATA.getOrCreate(data, ColorData::new);
    }

    public static boolean hasCustomColor(Block state) {
        return state.m_204297_().m_203656_(ModTags.TINTED_ON_MAPS);
    }

    public static class ColorData
    implements CustomMapData,
    BlockAndTintGetter {
        private final Data tintData;

        public ColorData() {
            this.tintData = Data.create(Map.of(), Map.of());
        }

        public ColorData(CompoundTag tag) {
            HashMap<Vec2b, Block> positionsToBlocks = new HashMap<Vec2b, Block>();
            HashMap<Vec2b, ResourceLocation> biomeCache = new HashMap<Vec2b, ResourceLocation>();
            ListTag list = tag.m_128437_("color_data", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag c = list.m_128728_(i);
                long[] positions = c.m_128467_("positions");
                Optional block = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(c.m_128461_("block")));
                if (!block.isPresent()) continue;
                for (int j = 0; j < positions.length; j = (int)((char)(j + 1))) {
                    long y = positions[j];
                    for (Integer x : ColorData.decodePositions(y >> (j % 2 == 0 ? 0 : 64))) {
                        x = x + (j % 2 == 0 ? 0 : 64);
                        char z = (char)(j / 2);
                        if (x > 127 || z > '\u007f' || x < 0 || z < '\u0000') {
                            boolean bl = true;
                            continue;
                        }
                        positionsToBlocks.put(new Vec2b(x, z), (Block)block.get());
                    }
                }
            }
            ListTag list2 = tag.m_128437_("biome_data", 10);
            for (int i = 0; i < list2.size(); ++i) {
                CompoundTag c = list2.m_128728_(i);
                long[] positions = c.m_128467_("positions");
                ResourceLocation biome = ResourceLocation.m_135820_((String)c.m_128461_("biome"));
                if (biome == null) continue;
                for (int j = 0; j < positions.length; j = (int)((char)(j + 1))) {
                    long y = positions[j];
                    for (Integer x : ColorData.decodePositions(y >> (j % 2 == 0 ? 0 : 64))) {
                        x = x + (j % 2 == 0 ? 0 : 64);
                        char z = (char)(j / 2);
                        if (x > 127 || z > '\u007f' || x < 0 || z < '\u0000') {
                            boolean bl = true;
                            continue;
                        }
                        biomeCache.put(new Vec2b(x, z), biome);
                    }
                }
            }
            this.tintData = Data.create(positionsToBlocks, biomeCache);
        }

        public void save(CompoundTag tag) {
            ListTag blockTagList = new ListTag();
            ListTag biomeTagList = new ListTag();
            HashMap<Block, long[]> blockMap = new HashMap<Block, long[]>();
            HashMap<ResourceLocation, long[]> biomeMap = new HashMap<ResourceLocation, long[]>();
            Iterator<Map.Entry<Vec2b, Pair<Block, ResourceLocation>>> iterator = this.tintData.getAllEntries();
            while (iterator.hasNext()) {
                int index;
                Map.Entry<Vec2b, Pair<Block, ResourceLocation>> e = iterator.next();
                Vec2b v = e.getKey();
                Pair<Block, ResourceLocation> blockBiomePair = e.getValue();
                Block block = (Block)blockBiomePair.getFirst();
                ResourceLocation biome = (ResourceLocation)blockBiomePair.getSecond();
                long[] blockArray = blockMap.computeIfAbsent(block, m -> new long[256]);
                long[] biomeArray = biomeMap.computeIfAbsent(biome, m -> new long[256]);
                int n = index = 2 * v.z + (v.x >= 64 ? 1 : 0);
                blockArray[n] = blockArray[n] | ColorData.encodePosition(v.x % 64);
                int n2 = index;
                biomeArray[n2] = biomeArray[n2] | ColorData.encodePosition(v.x % 64);
            }
            for (Map.Entry blockEntry : blockMap.entrySet()) {
                CompoundTag blockCompound = new CompoundTag();
                blockCompound.m_128359_("block", Utils.getID((Block)((Block)blockEntry.getKey())).toString());
                blockCompound.m_128388_("positions", (long[])blockEntry.getValue());
                blockTagList.add((Object)blockCompound);
            }
            for (Map.Entry biomeEntry : biomeMap.entrySet()) {
                CompoundTag biomeCompound = new CompoundTag();
                biomeCompound.m_128359_("biome", ((ResourceLocation)biomeEntry.getKey()).toString());
                biomeCompound.m_128388_("positions", (long[])biomeEntry.getValue());
                biomeTagList.add((Object)biomeCompound);
            }
            tag.m_128365_("color_data", (Tag)blockTagList);
            tag.m_128365_("biome_data", (Tag)biomeTagList);
        }

        public static long encodePosition(int position) {
            return 1L << position;
        }

        public static List<Integer> decodePositions(long encodedValue) {
            ArrayList<Integer> positionsList = new ArrayList<Integer>();
            long position = 1L;
            while (encodedValue != 0L) {
                if ((encodedValue & 1L) != 0L) {
                    positionsList.add((int)position - 1);
                }
                encodedValue >>>= 1;
                ++position;
            }
            return positionsList;
        }

        public CustomMapData.Type<?> getType() {
            return COLOR_DATA;
        }

        public void markColored(int x, int z, Block block, Level level, BlockPos pos, MapItemSavedData data) {
            if (ColoredMapHandler.hasCustomColor(block)) {
                boolean odd = x % 2 == 0 ^ z % 2 == 1;
                pos = pos.m_7918_(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                ResourceKey biome = (ResourceKey)level.m_204166_(pos).m_203543_().get();
                Vec2b v = new Vec2b(x, z);
                Pair pair = Pair.of((Object)block, (Object)biome.m_135782_());
                if (!Objects.equals(this.tintData.getEntry(v), pair)) {
                    this.tintData.addEntry(v, (Pair<Block, ResourceLocation>)pair);
                    this.setDirty(data);
                }
            } else if (this.tintData.removeIfPresent(new Vec2b(x, z))) {
                // empty if block
            }
        }

        @Nullable
        public BlockEntity m_7702_(BlockPos pos) {
            return null;
        }

        public BlockState m_8055_(BlockPos pos) {
            Block b = this.tintData.getBlock(new Vec2b(pos.m_123341_(), pos.m_123343_()));
            return b == null ? Blocks.f_50016_.m_49966_() : b.m_49966_();
        }

        public FluidState m_6425_(BlockPos pos) {
            return this.m_8055_(pos).m_60819_();
        }

        public int m_141928_() {
            return 0;
        }

        public int m_141937_() {
            return 0;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processTexture(DynamicTexture texture, byte[] colors) {
            Iterator<Map.Entry<Vec2b, Pair<Block, ResourceLocation>>> iterator = this.tintData.getAllEntries();
            while (iterator.hasNext()) {
                Map.Entry<Vec2b, Pair<Block, ResourceLocation>> e = iterator.next();
                Vec2b v = e.getKey();
                Block block = (Block)e.getValue().getFirst();
                BlockPos pos = new BlockPos((int)v.x, 0, (int)v.z);
                BlockColors blockColors = Minecraft.m_91087_().m_91298_();
                int tint = blockColors.m_92577_(block.m_49966_(), (BlockAndTintGetter)this, pos, 0);
                if (tint == -1) continue;
                int k = pos.m_123341_() + pos.m_123343_() * 128;
                byte packedId = colors[k];
                float lumIncrease = 1.3f;
                MapColor mapColor = MapColor.m_284175_((int)((packedId & 0xFF) >> 2));
                if (mapColor == MapColor.f_283864_) {
                    lumIncrease = 2.0f;
                } else if (mapColor == MapColor.f_283915_ && block instanceof BushBlock) {
                    packedId = MapColor.f_283824_.m_284523_(MapColor.Brightness.m_284351_((int)(packedId & 3)));
                }
                int color = MapColor.m_284315_((int)packedId);
                tint = ColorUtils.swapFormat((int)tint);
                RGBColor tintColor = new RGBColor(tint);
                LABColor c = new RGBColor(color).asLAB();
                RGBColor gray = c.multiply(lumIncrease, 0.0f, 0.0f, 1.0f).asRGB();
                int grayscaled = gray.multiply(tintColor.red(), tintColor.green(), tintColor.blue(), 1.0f).asHSL().multiply(1.0f, 1.3f, 1.0f, 1.0f).asRGB().toInt();
                texture.m_117991_().m_84988_(pos.m_123341_(), pos.m_123343_(), grayscaled);
            }
        }

        public float m_7717_(Direction direction, boolean shade) {
            return 0.0f;
        }

        public LevelLightEngine m_5518_() {
            return ClientRegistry.getLightEngine();
        }

        public int m_6171_(BlockPos pos, ColorResolver colorResolver) {
            int z;
            int x = pos.m_123341_();
            ResourceLocation biome = this.tintData.getBiome(new Vec2b(x, z = pos.m_123343_()));
            if (biome != null) {
                Biome b = (Biome)Utils.hackyGetRegistry((ResourceKey)Registries.f_256952_).m_7745_(biome);
                boolean odd = x % 2 == 0 ^ z % 2 == 1;
                pos = pos.m_7918_(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                return colorResolver.m_130045_(b, (double)pos.m_123341_() + 0.5, (double)pos.m_123343_() + 0.5);
            }
            return 0;
        }
    }

    private static class ArrayData
    implements Data {
        private final List<Pair<Block, ResourceLocation>> indexes = new ArrayList<Pair<Block, ResourceLocation>>();
        private final byte[][] blockArray = new byte[128][128];

        public ArrayData(Map<Vec2b, Block> blocks, Map<Vec2b, ResourceLocation> biomes) {
            for (Map.Entry<Vec2b, Block> entry : blocks.entrySet()) {
                Vec2b key = entry.getKey();
                Block block = entry.getValue();
                ResourceLocation biome = biomes.get(key);
                int index = this.getOrCreateBlockIndex((Pair<Block, ResourceLocation>)Pair.of((Object)block, (Object)biome));
                this.blockArray[key.x()][key.z()] = (byte)(index + 1);
            }
        }

        @Override
        public boolean removeIfPresent(Vec2b v) {
            if (this.blockArray[v.x][v.z] != 0) {
                this.blockArray[v.x][v.z] = 0;
                return true;
            }
            return false;
        }

        @Override
        public void addEntry(Vec2b v, Pair<Block, ResourceLocation> pair) {
            int index = this.getOrCreateBlockIndex(pair);
            this.blockArray[v.x][v.z] = (byte)(index + 1);
        }

        private int getOrCreateBlockIndex(Pair<Block, ResourceLocation> key) {
            int index = this.indexes.indexOf(key);
            if (index == -1) {
                this.indexes.add(key);
                index = this.indexes.indexOf(key);
            }
            return index;
        }

        @Override
        @Nullable
        public Pair<Block, ResourceLocation> getEntry(Vec2b v) {
            byte index = this.blockArray[v.x][v.z];
            if (index == 0) {
                return null;
            }
            return this.indexes.get(index - 1);
        }

        @Override
        public Iterator<Map.Entry<Vec2b, Pair<Block, ResourceLocation>>> getAllEntries() {
            return new ArrayIterator();
        }

        private class ArrayIterator
        implements Iterator<Map.Entry<Vec2b, Pair<Block, ResourceLocation>>> {
            private int x = 0;
            private int z = 0;

            private ArrayIterator() {
            }

            @Override
            public boolean hasNext() {
                while (this.x < 128) {
                    while (this.z < 128) {
                        if (ArrayData.this.blockArray[this.x][this.z] != 0) {
                            return true;
                        }
                        ++this.z;
                    }
                    this.z = 0;
                    ++this.x;
                }
                return false;
            }

            @Override
            public Map.Entry<Vec2b, Pair<Block, ResourceLocation>> next() {
                while (this.x < 128) {
                    while (this.z < 128) {
                        if (ArrayData.this.blockArray[this.x][this.z] != 0) {
                            Pair<Block, ResourceLocation> entry = ArrayData.this.indexes.get(ArrayData.this.blockArray[this.x][this.z] - 1);
                            Vec2b position = new Vec2b((byte)this.x, (byte)this.z);
                            ++this.z;
                            return new AbstractMap.SimpleEntry<Vec2b, Pair<Block, ResourceLocation>>(position, entry);
                        }
                        ++this.z;
                    }
                    this.z = 0;
                    ++this.x;
                }
                return null;
            }
        }
    }

    private static class HashMapData
    implements Data {
        private final Map<Vec2b, Pair<Block, ResourceLocation>> blockMap = new HashMap<Vec2b, Pair<Block, ResourceLocation>>();

        public HashMapData(Map<Vec2b, Block> blocks, Map<Vec2b, ResourceLocation> biomes) {
            for (Map.Entry<Vec2b, Block> blockEntry : blocks.entrySet()) {
                Vec2b key = blockEntry.getKey();
                Block block = blockEntry.getValue();
                ResourceLocation biome = biomes.get(key);
                if (biome == null) continue;
                Pair pair = Pair.of((Object)block, (Object)biome);
                this.blockMap.put(key, (Pair<Block, ResourceLocation>)pair);
            }
        }

        @Override
        @Nullable
        public Pair<Block, ResourceLocation> getEntry(Vec2b v) {
            return this.blockMap.get(v);
        }

        @Override
        public boolean removeIfPresent(Vec2b v) {
            if (this.blockMap.containsKey(v)) {
                this.blockMap.remove(v);
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<Vec2b, Pair<Block, ResourceLocation>>> getAllEntries() {
            return this.blockMap.entrySet().iterator();
        }

        @Override
        public void addEntry(Vec2b v, Pair<Block, ResourceLocation> pair) {
            this.blockMap.put(v, pair);
        }
    }

    private static interface Data {
        @Nullable
        default public ResourceLocation getBiome(Vec2b v) {
            Pair<Block, ResourceLocation> entry = this.getEntry(v);
            if (entry == null) {
                return null;
            }
            return (ResourceLocation)entry.getSecond();
        }

        @Nullable
        default public Block getBlock(Vec2b v) {
            Pair<Block, ResourceLocation> entry = this.getEntry(v);
            if (entry == null) {
                return null;
            }
            return (Block)entry.getFirst();
        }

        public Pair<Block, ResourceLocation> getEntry(Vec2b var1);

        public static Data create(Map<Vec2b, Block> blockMap, Map<Vec2b, ResourceLocation> biomeData) {
            if (blockMap.size() < 6000 || biomeData.size() < 6000) {
                return new HashMapData(blockMap, biomeData);
            }
            return new ArrayData(blockMap, biomeData);
        }

        public Iterator<Map.Entry<Vec2b, Pair<Block, ResourceLocation>>> getAllEntries();

        public void addEntry(Vec2b var1, Pair<Block, ResourceLocation> var2);

        public boolean removeIfPresent(Vec2b var1);
    }

    private record Vec2b(byte x, byte z) {
        public Vec2b(int x, int y) {
            this((byte)x, (byte)y);
        }

        @Override
        public String toString() {
            return "X:" + this.x + "Z:" + this.z;
        }
    }

    public static class DirtyCounter {
        private final long[] dirtyPatches = new long[256];
    }
}

