/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.gson.JsonParser;
import java.util.List;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.ImageTransformer;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.ClientSpecialModelsManager;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.common.misc.CakeRegistry;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientDynamicResourcesGenerator
extends DynClientResourcesGenerator {
    public static final ClientDynamicResourcesGenerator INSTANCE = new ClientDynamicResourcesGenerator();

    public ClientDynamicResourcesGenerator() {
        super(new DynamicTexturePack(Supplementaries.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).addNamespaces(new String[]{"minecraft"});
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.General.DEBUG_RESOURCES.get() != false);
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        Object respriter;
        TextureImage template;
        ClientSpecialModelsManager.refreshModels(manager);
        GlobeManager.refreshColorsAndTextures(manager);
        ColorHelper.refreshBubbleColors(manager);
        ((DynamicTexturePack)this.dynamicPack).addItemModel(new ResourceLocation("crossbow_arrow"), JsonParser.parseString((String)"{\n    \"parent\": \"item/crossbow\",\n    \"textures\": {\n        \"layer0\": \"item/crossbow_arrow_base\",\n        \"layer1\": \"item/crossbow_arrow_tip\"\n    }\n}\n"));
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            RPUtils.appendModelOverride((ResourceManager)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (ResourceLocation)new ResourceLocation("crossbow"), e -> e.add(new ItemOverride(new ResourceLocation("item/crossbow_rope_arrow"), List.of(new ItemOverride.Predicate(new ResourceLocation("charged"), 1.0f), new ItemOverride.Predicate(Supplementaries.res("rope_arrow"), 1.0f)))));
        }
        if (CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get().booleanValue()) {
            RPUtils.appendModelOverride((ResourceManager)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (ResourceLocation)new ResourceLocation("written_book"), e -> e.add(new ItemOverride(new ResourceLocation("item/written_book_tattered"), List.of(new ItemOverride.Predicate(Supplementaries.res("antique_ink"), 1.0f)))));
            RPUtils.appendModelOverride((ResourceManager)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (ResourceLocation)new ResourceLocation("filled_map"), e -> e.add(new ItemOverride(new ResourceLocation("item/antique_map"), List.of(new ItemOverride.Predicate(Supplementaries.res("antique_ink"), 1.0f)))));
        }
        RPUtils.appendModelOverride((ResourceManager)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (ResourceLocation)Supplementaries.res("globe"), e -> {
            int i = 0;
            for (ResourceLocation text : GlobeManager.Type.textures) {
                String name = text.m_135815_().split("/")[3].split("\\.")[0];
                e.add(new ItemOverride(Supplementaries.res("item/" + name), List.of(new ItemOverride.Predicate(Supplementaries.res("type"), (float)i))));
                ++i;
                ((DynamicTexturePack)this.dynamicPack).addItemModel(Supplementaries.res(name), JsonParser.parseString((String)("{\n    \"parent\": \"item/generated\",\n    \"textures\": {\n        \"layer0\": \"supplementaries:item/globes/" + name + "\"    }\n}\n")));
            }
        });
        StaticResource spItemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Supplementaries.res("sign_post_oak")));
        ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
            String id = Utils.getID((Item)sign).m_135815_();
            try {
                this.addSimilarJsonResource(manager, spItemModel, "sign_post_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Sign Post item model for {} : {}", (Object)sign, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/sign_posts/template"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((arg_0, arg_1) -> this.lambda$regenerateDynamicAssets$5(manager, (Respriter)respriter, arg_0, arg_1));
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("block/sign_posts/sign_post_oak"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((arg_0, arg_1) -> this.lambda$regenerateDynamicAssets$6(manager, (Respriter)respriter, arg_0, arg_1));
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post block texture : ", (Throwable)ex);
        }
        ImageTransformer transformer = ImageTransformer.builder((int)32, (int)64, (int)16, (int)16).copyRect(26, 0, 2, 4, 4, 0).copyRect(26, 8, 6, 8, 4, 4).copyRect(28, 24, 4, 8, 0, 4).copyRect(26, 20, 2, 4, 6, 0).copyRect(26, 28, 1, 8, 11, 4).copyRect(27, 28, 1, 8, 10, 4).build();
        for (net.mehvahdjukaar.moonlight.api.set.wood.WoodType w : WoodTypeRegistry.getTypes()) {
            try {
                TextureImage vanillaTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)Sheets.m_246984_((WoodType)w.toVanilla()).m_119203_());
                try {
                    TextureImage flipped = vanillaTexture.createRotated(Rotation.CLOCKWISE_90);
                    TextureImage newIm = flipped.createResized(0.5f, 0.25f);
                    newIm.clear();
                    transformer.apply(flipped, newIm);
                    flipped.close();
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(Supplementaries.res("entity/signs/hanging/" + w.getVariantId("extension")), newIm);
                }
                finally {
                    if (vanillaTexture == null) continue;
                    vanillaTexture.close();
                }
            }
            catch (Exception e2) {
                Supplementaries.LOGGER.warn("Failed to generate hanging sign extension texture for {}. Could be that the target mod isnt registering their wood type properly", (Object)w, (Object)e2);
            }
        }
        if (CompatHandler.FARMERS_DELIGHT) {
            try (TextureImage vanillaTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)new ResourceLocation("farmersdelight:entity/signs/hanging/canvas"));){
                TextureImage flipped = vanillaTexture.createRotated(Rotation.CLOCKWISE_90);
                TextureImage newIm = flipped.createResized(0.5f, 0.25f);
                newIm.clear();
                transformer.apply(flipped, newIm);
                flipped.close();
                ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(Supplementaries.res("entity/signs/hanging/farmersdelight/extension_canvas"), newIm);
            }
            catch (Exception e3) {
                Supplementaries.LOGGER.warn("Failed to generate hanging sign extension texture for {}, ", (Object)"canvas sign", (Object)e3);
            }
        }
        StaticResource[] cakeModels = (StaticResource[])Stream.of("full", "slice1", "slice2", "slice3", "slice4", "slice5", "slice6").map(s -> StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Supplementaries.res("double_cake/vanilla_" + s)))).toArray(StaticResource[]::new);
        StaticResource doubleCakeModelState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(Supplementaries.res("double_cake")));
        for (CakeRegistry.CakeType t : CakeRegistry.INSTANCE.getValues()) {
            if (t.isVanilla()) continue;
            try {
                ResourceLocation dcId = Utils.getID((Block)t.getBlockOfThis("double_cake"));
                ResourceLocation top = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)t.cake, s -> s.contains("top"));
                ResourceLocation side = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)t.cake, s -> s.contains("side"));
                ResourceLocation bottom = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)t.cake, s -> s.contains("bottom"));
                ResourceLocation inner = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)t.cake, s -> s.contains("inner"));
                for (StaticResource m : cakeModels) {
                    this.addSimilarJsonResource(manager, m, s -> s.replace("supplementaries:block/double_cake", "").replace("supplementaries:block/cake", "").replace("\"/", "\"supplementaries:block/double_cake/").replace("_top", top.toString()).replace("_side", side.toString()).replace("_inner", inner.toString()).replace("_bottom", bottom.toString()), s -> s.replace("vanilla", dcId.m_135815_()));
                }
                this.addSimilarJsonResource(manager, doubleCakeModelState, s -> s.replace("vanilla", dcId.m_135815_()), s -> s.replace("double_cake", dcId.m_135815_()));
            }
            catch (Exception e4) {
                Supplementaries.LOGGER.error("Failed to generate model for double cake {},", (Object)t, (Object)e4);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static TextureImage recolorFromVanilla(ResourceManager manager, TextureImage vanillaTexture, ResourceLocation vanillaMask, ResourceLocation templateTexture) {
        try (TextureImage scribbleMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)vanillaMask);){
            TextureImage textureImage;
            block14: {
                TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)templateTexture);
                try {
                    Respriter respriter = Respriter.of((TextureImage)template);
                    Palette palette = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)scribbleMask);
                    textureImage = respriter.recolor(palette);
                    if (template == null) break block14;
                }
                catch (Throwable throwable) {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                template.close();
            }
            return textureImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        ModRegistry.SIGN_POST_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.sign_post", (BlockType)type, (Item)item));
    }

    private /* synthetic */ void lambda$regenerateDynamicAssets$6(ResourceManager manager, Respriter respriter, net.mehvahdjukaar.moonlight.api.set.wood.WoodType wood, SignPostItem sign) {
        ResourceLocation textureRes = Supplementaries.res("block/sign_posts/" + Utils.getID((Item)sign).m_135815_());
        if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
            return;
        }
        try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
            Palette palette = Palette.fromImage((TextureImage)plankTexture);
            TextureImage newImage = respriter.recolor(palette);
            ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
        }
        catch (Exception ex) {
            this.getLogger().error("Failed to generate Sign Post block texture for for {} : {}", (Object)sign, (Object)ex);
        }
    }

    private /* synthetic */ void lambda$regenerateDynamicAssets$5(ResourceManager manager, Respriter respriter, net.mehvahdjukaar.moonlight.api.set.wood.WoodType wood, SignPostItem sign) {
        ResourceLocation textureRes = Supplementaries.res("item/sign_posts/" + Utils.getID((Item)sign).m_135815_());
        if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
            return;
        }
        TextureImage newImage = null;
        Item signItem = wood.getItemOfThis("sign");
        if (signItem != null) {
            try (TextureImage vanillaSign2 = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)signItem));
                 TextureImage signMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/hanging_signs/sign_board_mask"));){
                List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign2, (TextureImage)signMask);
                newImage = respriter.recolor(targetPalette);
                try (TextureImage scribbles = ClientDynamicResourcesGenerator.recolorFromVanilla(manager, vanillaSign2, Supplementaries.res("item/hanging_signs/sign_scribbles_mask"), Supplementaries.res("item/sign_posts/scribbles_template"));){
                    newImage.applyOverlay(new TextureImage[]{scribbles});
                }
                catch (Exception ex) {
                    this.getLogger().error("Could not properly color Sign Post item texture for {} : {}", (Object)sign, (Object)ex);
                }
            }
            catch (Exception vanillaSign2) {
                // empty catch block
            }
        }
        if (newImage == null) {
            try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                newImage = respriter.recolor(targetPalette);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Sign Post item texture for for {} : {}", (Object)sign, (Object)ex);
            }
        }
        if (newImage != null) {
            ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
        }
    }
}

