/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ColoredMapHandler {
    protected static int DITHERING = 1;
    public static final CustomMapData.Type<ColorData> COLOR_DATA = MapDecorationRegistry.registerCustomMapSavedData((ResourceLocation)Supplementaries.res("color_data"), ColorData::new);

    public static void init() {
    }

    public static ColorData getColorData(MapItemSavedData data) {
        return (ColorData)COLOR_DATA.getOrCreate(data, ColorData::new);
    }

    public static boolean hasCustomColor(Block state) {
        return state.m_204297_().m_203656_(ModTags.TINTED_ON_MAPS);
    }

    public static class ColorData
    implements CustomMapData,
    BlockAndTintGetter {
        private final HashMap<Vec2c, Block> positionsToBlocks = new HashMap();
        private final HashMap<Vec2c, ResourceKey<Biome>> biomeCache = new HashMap();

        public ColorData() {
        }

        public ColorData(CompoundTag tag) {
            ListTag list = tag.m_128437_("color_data", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag c = list.m_128728_(i);
                long[] positions = c.m_128467_("positions");
                Optional block = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(c.m_128461_("block")));
                if (!block.isPresent()) continue;
                for (int j = 0; j < positions.length; j = (int)((char)(j + 1))) {
                    long y = positions[j];
                    for (Integer x : ColorData.decodePositions(y >> (j % 2 == 0 ? 0 : 64))) {
                        x = x + (j % 2 == 0 ? 0 : 64);
                        char z = (char)(j / 2);
                        if (x > 127 || z > '\u007f' || x < 0 || z < '\u0000') {
                            boolean bl = true;
                            continue;
                        }
                        this.positionsToBlocks.put(new Vec2c(x, (int)z), (Block)block.get());
                    }
                }
            }
            ListTag list2 = tag.m_128437_("biome_data", 10);
            for (int i = 0; i < list2.size(); ++i) {
                CompoundTag c = list2.m_128728_(i);
                long[] positions = c.m_128467_("positions");
                ResourceKey biome = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(c.m_128461_("biome")));
                for (int j = 0; j < positions.length; j = (int)((char)(j + 1))) {
                    long y = positions[j];
                    for (Integer x : ColorData.decodePositions(y >> (j % 2 == 0 ? 0 : 64))) {
                        x = x + (j % 2 == 0 ? 0 : 64);
                        char z = (char)(j / 2);
                        if (x > 127 || z > '\u007f' || x < 0 || z < '\u0000') {
                            boolean bl = true;
                            continue;
                        }
                        this.biomeCache.put(new Vec2c(x, (int)z), (ResourceKey<Biome>)biome);
                    }
                }
            }
        }

        public void save(CompoundTag tag) {
            ListTag tagList = new ListTag();
            HashMap<Block, long[]> map = new HashMap<Block, long[]>();
            for (Map.Entry<Vec2c, Block> entry : this.positionsToBlocks.entrySet()) {
                int index;
                Vec2c v = entry.getKey();
                Block block = entry.getValue();
                long[] array = map.computeIfAbsent(block, m -> new long[256]);
                int n = index = 2 * v.z + (v.x >= '@' ? 1 : 0);
                array[n] = array[n] | ColorData.encodePosition(v.x % 64);
            }
            for (Map.Entry<Vec2c, Object> entry : map.entrySet()) {
                CompoundTag c = new CompoundTag();
                c.m_128359_("block", Utils.getID((Block)((Block)entry.getKey())).toString());
                c.m_128388_("positions", (long[])entry.getValue());
                tagList.add((Object)c);
            }
            tag.m_128365_("color_data", (Tag)tagList);
            ListTag tagList1 = new ListTag();
            HashMap<ResourceKey, long[]> hashMap = new HashMap<ResourceKey, long[]>();
            for (Map.Entry<Vec2c, ResourceKey<Biome>> entry : this.biomeCache.entrySet()) {
                int index;
                Vec2c v = entry.getKey();
                ResourceKey<Biome> b = entry.getValue();
                long[] array = hashMap.computeIfAbsent(b, m -> new long[256]);
                int n = index = 2 * v.z + (v.x >= '@' ? 1 : 0);
                array[n] = array[n] | ColorData.encodePosition(v.x % 64);
            }
            for (Map.Entry<Vec2c, Object> entry : hashMap.entrySet()) {
                CompoundTag c = new CompoundTag();
                c.m_128359_("biome", ((ResourceKey)entry.getKey()).m_135782_().toString());
                c.m_128388_("positions", (long[])entry.getValue());
                tagList1.add((Object)c);
            }
            tag.m_128365_("biome_data", (Tag)tagList1);
        }

        public static long encodePosition(int position) {
            return 1L << position;
        }

        public static List<Integer> decodePositions(long encodedValue) {
            ArrayList<Integer> positionsList = new ArrayList<Integer>();
            long position = 1L;
            while (encodedValue != 0L) {
                if ((encodedValue & 1L) != 0L) {
                    positionsList.add((int)position - 1);
                }
                encodedValue >>>= 1;
                ++position;
            }
            return positionsList;
        }

        public CustomMapData.Type<?> getType() {
            return COLOR_DATA;
        }

        public void markColored(int x, int z, Block block, Level level, BlockPos pos, MapItemSavedData data) {
            Vec2c pair = new Vec2c((char)x, (char)z);
            if (ColoredMapHandler.hasCustomColor(block)) {
                this.positionsToBlocks.put(pair, block);
                boolean odd = x % 2 == 0 ^ z % 2 == 1;
                pos = pos.m_7918_(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                ResourceKey biome = (ResourceKey)level.m_204166_(pos).m_203543_().get();
                this.biomeCache.put(pair, (ResourceKey<Biome>)biome);
                ((ExpandedMapData)data).setCustomDataDirty();
            } else if (this.positionsToBlocks.containsKey(pair)) {
                this.positionsToBlocks.remove(pair);
                ((ExpandedMapData)data).setCustomDataDirty();
            }
        }

        @Nullable
        public BlockEntity m_7702_(BlockPos pos) {
            return null;
        }

        public BlockState m_8055_(BlockPos pos) {
            Block b = this.positionsToBlocks.get(new Vec2c(pos.m_123341_(), pos.m_123343_()));
            return b == null ? Blocks.f_50016_.m_49966_() : b.m_49966_();
        }

        public FluidState m_6425_(BlockPos pos) {
            return this.m_8055_(pos).m_60819_();
        }

        public int m_141928_() {
            return 0;
        }

        public int m_141937_() {
            return 0;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processTexture(DynamicTexture texture, byte[] colors) {
            for (Map.Entry<Vec2c, Block> e : this.positionsToBlocks.entrySet()) {
                Vec2c v = e.getKey();
                BlockPos pos = new BlockPos((int)v.x, 0, (int)v.z);
                int tint = Minecraft.m_91087_().m_91298_().m_92577_(e.getValue().m_49966_(), (BlockAndTintGetter)this, pos, 0);
                tint = ColorUtils.swapFormat((int)tint);
                int k = pos.m_123341_() + pos.m_123343_() * 128;
                byte packedId = colors[k];
                int color = MapColor.m_284315_((int)packedId);
                float lumIncrease = 1.3f;
                boolean water = false;
                if (packedId >= 48 && 51 > packedId) {
                    water = true;
                    lumIncrease = 2.0f;
                }
                RGBColor tintColor = new RGBColor(tint);
                LABColor c = new RGBColor(color).asLAB();
                RGBColor gray = c.multiply(lumIncrease, 0.0f, 0.0f, 1.0f).asRGB();
                int grayscaled = gray.multiply(tintColor.red(), tintColor.green(), tintColor.blue(), 1.0f).asHSL().multiply(1.0f, 1.3f, 1.0f, 1.0f).asRGB().toInt();
                texture.m_117991_().m_84988_(pos.m_123341_(), pos.m_123343_(), grayscaled);
            }
        }

        public float m_7717_(Direction direction, boolean shade) {
            return 0.0f;
        }

        public LevelLightEngine m_5518_() {
            return ClientRegistry.getLightEngine();
        }

        public int m_6171_(BlockPos pos, ColorResolver colorResolver) {
            int z;
            int x = pos.m_123341_();
            ResourceKey<Biome> biome = this.biomeCache.get(new Vec2c(x, z = pos.m_123343_()));
            if (biome != null) {
                Biome b = (Biome)Utils.hackyGetRegistry((ResourceKey)Registries.f_256952_).m_6246_(biome);
                boolean odd = x % 2 == 0 ^ z % 2 == 1;
                pos = pos.m_7918_(odd ? DITHERING : -DITHERING, 0, odd ? DITHERING : -DITHERING);
                return colorResolver.m_130045_(b, (double)pos.m_123341_() + 0.5, (double)pos.m_123343_() + 0.5);
            }
            return 0;
        }

        private record Vec2c(char x, char z) {
            public Vec2c(int x, int y) {
                this((char)x, (char)y);
            }

            @Override
            public String toString() {
                return "X:" + this.x + "Z:" + this.z;
            }
        }
    }
}

