/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class BuiltinAnimation<T extends Entity> {
    protected float jumpY = 0.0f;
    protected float prevJumpY = 0.0f;
    protected float yVel = 0.0f;

    void tick(T mob, Level world, BlockPos pos) {
        if (world.f_46443_) {
            ((Entity)mob).f_19791_ = mob.m_20186_();
            float dy = this.jumpY - this.prevJumpY;
            if (dy != 0.0f) {
                mob.m_6034_(mob.m_20185_(), mob.m_20186_() + (double)dy, mob.m_20189_());
            }
            this.prevJumpY = this.jumpY;
        }
    }

    @Nullable
    public static <E extends Entity> BuiltinAnimation<E> get(E entity, Type type) {
        if (type == Type.BUILTIN) {
            if (entity instanceof Slime) {
                Slime slime = (Slime)entity;
                return new SlimeAnim<Slime>(slime);
            }
            if (entity instanceof Chicken) {
                Chicken chicken = (Chicken)entity;
                return new ChickenAnim(chicken);
            }
            if (entity instanceof Rabbit) {
                Rabbit rabbit = (Rabbit)entity;
                return new RabbitAnim(rabbit);
            }
            if (entity instanceof Parrot) {
                Parrot parrot = (Parrot)entity;
                return new ParrotAnim(parrot);
            }
            if (entity instanceof Endermite) {
                Endermite endermite = (Endermite)entity;
                return new EndermiteAnim(endermite);
            }
        } else if (type == Type.FLOATING) {
            return new FloatingAnim<E>(entity);
        }
        return null;
    }

    public static enum Type implements StringRepresentable
    {
        NONE,
        LAND,
        AIR,
        FLOATING,
        BUILTIN;

        public static final Codec<Type> CODEC;

        public boolean isFlying() {
            return this == AIR || this == FLOATING;
        }

        public boolean isLand() {
            return this == LAND;
        }

        public boolean isFloating() {
            return this == FLOATING;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
        }
    }

    private static class SlimeAnim<M extends Slime>
    extends BuiltinAnimation<M> {
        SlimeAnim(M slime) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            if (world.f_46443_) {
                ((Slime)mob).f_33584_ += (((Slime)mob).f_33581_ - ((Slime)mob).f_33584_) * 0.5f;
                ((Slime)mob).f_33585_ = ((Slime)mob).f_33584_;
                if (this.yVel != 0.0f) {
                    this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                }
                if (this.jumpY != 0.0f) {
                    this.yVel -= 0.01f;
                } else {
                    if (this.yVel != 0.0f) {
                        this.yVel = 0.0f;
                        ((Slime)mob).f_33581_ = -0.5f;
                    }
                    if ((double)world.m_213780_().m_188501_() > 0.985) {
                        this.yVel = 0.08f;
                        ((Slime)mob).f_33581_ = 1.0f;
                    }
                }
                ((Slime)mob).f_33581_ *= 0.6f;
                super.tick(mob, world, pos);
            }
        }
    }

    private static class ChickenAnim<M extends Chicken>
    extends BuiltinAnimation<M> {
        public ChickenAnim(Chicken chicken) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            RandomSource rand = world.m_213780_();
            if (!world.f_46443_) {
                if (--((Chicken)mob).f_28231_ <= 0) {
                    mob.m_19998_((ItemLike)Items.f_42521_);
                    ((Chicken)mob).f_28231_ = rand.m_188503_(6000) + 6000;
                }
            } else {
                mob.m_8107_();
                double d = world.f_46441_.m_188501_();
                double d2 = mob.m_20096_() ? 0.99 : 0.88;
                if (d > d2) {
                    mob.m_6853_(!mob.m_20096_());
                }
            }
        }
    }

    private static class RabbitAnim<M extends Rabbit>
    extends BuiltinAnimation<M> {
        public RabbitAnim(Rabbit rabbit) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            if (world.f_46443_) {
                if (this.yVel != 0.0f) {
                    this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                }
                if (this.jumpY != 0.0f) {
                    this.yVel -= 0.017f;
                } else {
                    if (this.yVel != 0.0f) {
                        this.yVel = 0.0f;
                    }
                    if ((double)world.f_46441_.m_188501_() > 0.985) {
                        this.yVel = 0.093f;
                        mob.m_29716_();
                    }
                }
                mob.m_8107_();
                super.tick(mob, world, pos);
            }
        }
    }

    private static class ParrotAnim<M extends Parrot>
    extends BuiltinAnimation<M> {
        public ParrotAnim(Parrot parrot) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            if (world.f_46443_) {
                mob.m_8107_();
                boolean p = mob.m_29439_();
                mob.m_6853_(p);
                this.jumpY = p ? 0.0f : 0.0625f;
                super.tick(mob, world, pos);
            }
        }
    }

    private static class EndermiteAnim<M extends Endermite>
    extends BuiltinAnimation<M> {
        public EndermiteAnim(Endermite endermite) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            if (world.f_46443_ && world.f_46441_.m_188501_() > 0.7f) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.2f), (double)((float)pos.m_123343_() + 0.5f), (world.f_46441_.m_188500_() - 0.5) * 2.0, -world.f_46441_.m_188500_(), (world.f_46441_.m_188500_() - 0.5) * 2.0);
            }
        }
    }

    private static class FloatingAnim<M extends Entity>
    extends BuiltinAnimation<M> {
        FloatingAnim(M entity) {
        }

        @Override
        public void tick(M mob, Level world, BlockPos pos) {
            if (world.f_46443_) {
                this.jumpY = 0.04f * Mth.m_14031_((float)((float)((Entity)mob).f_19797_ / 10.0f)) - 0.03f;
            }
        }
    }
}

