/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SpeakerBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty ANTIQUE = ModBlockProperties.ANTIQUE;

    public SpeakerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ANTIQUE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, ANTIQUE});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.updatePower(state, worldIn, pos);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof SpeakerBlockTile) {
            SpeakerBlockTile tile = (SpeakerBlockTile)blockEntity;
            if (stack.m_41788_()) {
                tile.setCustomName(stack.m_41786_());
            }
            BlockUtil.addOptionalOwnership(placer, tile);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.m_6861_(state, world, pos, neighborBlock, fromPos, moving);
        this.updatePower(state, world, pos);
    }

    public void updatePower(BlockState state, Level world, BlockPos pos) {
        boolean pow;
        if (!world.m_5776_() && (pow = world.m_276867_(pos)) != (Boolean)state.m_61143_((Property)POWERED)) {
            BlockEntity blockEntity;
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(pow)), 3);
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            if (pow && world.m_46859_(pos.m_121945_(facing)) && (blockEntity = world.m_7702_(pos)) instanceof SpeakerBlockTile) {
                SpeakerBlockTile tile = (SpeakerBlockTile)blockEntity;
                tile.sendMessage();
                world.m_142346_(null, GameEvent.f_223696_, pos);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        SpeakerBlockTile tile;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SpeakerBlockTile && (tile = (SpeakerBlockTile)blockEntity).isAccessibleBy(player)) {
            ItemStack stack = player.m_21120_(hand);
            if (!((Boolean)state.m_61143_((Property)ANTIQUE)).booleanValue() && Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)stack) && stack.m_150930_(ModRegistry.ANTIQUE_INK.get())) {
                level.m_5594_(null, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ANTIQUE, (Comparable)Boolean.valueOf(true)));
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)level.m_8055_(pos)));
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                tile.tryOpeningEditGui(serverPlayer, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new SpeakerBlockTile(pPos, pState);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        if (eventID == 0) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            world.m_7106_((ParticleOptions)ModParticles.SPEAKER_SOUND.get(), (double)pos.m_123341_() + 0.5 + (double)facing.m_122429_() * 0.725, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5 + (double)facing.m_122431_() * 0.725, (double)world.f_46441_.m_188503_(24) / 24.0, 0.0, 0.0);
            return true;
        }
        return super.m_8133_(state, world, pos, eventID, eventParam);
    }
}

