/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;

class BrewingStandInteraction
implements FaucetSource.Tile,
FaucetTarget.Tile {
    BrewingStandInteraction() {
    }

    @Override
    public FluidOffer getProvidedFluid(Level level, BlockPos pos, Direction dir, BlockEntity tile) {
        if (tile instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)tile;
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = brewingStand.m_8020_(i);
                Pair opt = SoftFluidStack.fromItem((ItemStack)stack);
                if (opt == null) continue;
                return FluidOffer.of((SoftFluidStack)opt.getFirst());
            }
        }
        return null;
    }

    @Override
    public void drain(Level level, BlockPos pos, Direction dir, BlockEntity tile, int amount) {
        if (tile instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)tile;
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = brewingStand.m_8020_(i);
                Pair opt = SoftFluidStack.fromItem((ItemStack)stack);
                if (opt == null) continue;
                brewingStand.m_6836_(i, stack.m_41720_().m_41469_().m_7968_());
                tile.m_6596_();
                return;
            }
        }
    }

    @Override
    public Integer fill(Level level, BlockPos pos, BlockEntity tile, SoftFluidStack fluid, int minAmount) {
        if (tile instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)tile;
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = brewingStand.m_8020_(i);
                Pair filled = fluid.toItem(stack, true);
                if (filled == null) continue;
                ItemStack filledItem = (ItemStack)filled.getFirst();
                brewingStand.m_6836_(i, ItemStack.f_41583_);
                if (brewingStand.m_7013_(i, filledItem)) {
                    brewingStand.m_6836_(i, ((ItemStack)filled.getFirst()).m_41777_());
                    tile.m_6596_();
                    return ((FluidContainerList.Category)filled.getSecond()).getAmount();
                }
                brewingStand.m_6836_(i, stack);
            }
        }
        return null;
    }
}

