/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.IMobContainerProvider;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class JarBlockTile
extends ItemDisplayTile
implements IMobContainerProvider,
ISoftFluidTankProvider,
IExtraModelDataProvider {
    public static final ModelDataKey<SoftFluid> FLUID = ModBlockProperties.FLUID;
    public static final ModelDataKey<Float> FILL_LEVEL = ModBlockProperties.FILL_LEVEL;
    public final MobContainer mobContainer;
    public final SoftFluidTank fluidHolder;

    public JarBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.JAR_TILE.get(), pos, state, 12);
        int capacity = CommonConfigs.Functional.JAR_CAPACITY.get();
        this.fluidHolder = SoftFluidTank.create((int)capacity);
        AbstractMobContainerItem item = (AbstractMobContainerItem)ModRegistry.JAR_ITEM.get();
        this.mobContainer = new MobContainer(item.getMobContainerWidth(), item.getMobContainerHeight(), true);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(FLUID, (Object)this.fluidHolder.getFluidValue()).with(FILL_LEVEL, (Object)Float.valueOf(this.fluidHolder.getHeight(1.0f)));
    }

    public void updateTileOnInventoryChanged() {
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        int light = this.fluidHolder.getFluidValue().getLuminosity();
        if (light != (Integer)this.m_58900_().m_61143_((Property)ModBlockProperties.LIGHT_LEVEL_0_15)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    public void updateClientVisualsOnLoad() {
        super.updateClientVisualsOnLoad();
        this.requestModelReload();
    }

    public boolean handleInteraction(Player player, InteractionHand hand, Level level, BlockPos pos) {
        ItemStack handStack = player.m_21120_(hand);
        ItemStack displayedStack = this.getDisplayedItem();
        if (this.canInteractWithSoftFluidTank() && this.fluidHolder.interactWithPlayer(player, hand, level, pos)) {
            return true;
        }
        if (this.tryAddingItem(handStack, player, hand)) {
            return true;
        }
        if (this.m_7983_() && this.fluidHolder.isEmpty() && this.mobContainer.interactWithBucket(handStack, level, player.m_20183_(), player, hand)) {
            return true;
        }
        if (!player.m_6144_() && CommonConfigs.Functional.JAR_EAT.get().booleanValue()) {
            if (this.fluidHolder.tryDrinkUpFluid(player, level)) {
                return true;
            }
            if (displayedStack.m_41614_() && player.m_36391_(false) && !player.m_7500_()) {
                player.m_5584_(level, displayedStack);
                return true;
            }
        }
        return this.handleExtractItem(player, hand);
    }

    public ItemStack extractItem() {
        for (int j = this.m_6643_() - 1; j >= 0; --j) {
            ItemStack s = this.m_8020_(j);
            if (s.m_41619_()) continue;
            this.m_8016_(j);
            return s;
        }
        return ItemStack.f_41583_;
    }

    public boolean handleExtractItem(Player player, InteractionHand hand) {
        if (!player.m_21120_(hand).m_41619_()) {
            return false;
        }
        ItemStack extracted = this.extractItem();
        if (!extracted.m_41619_()) {
            Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)extracted);
            return true;
        }
        return false;
    }

    public boolean tryAddingItem(ItemStack stack, @Nullable Player player, InteractionHand handIn) {
        ItemStack handStack = stack.m_41777_();
        handStack.m_41764_(1);
        if (this.tryAddingItem(handStack)) {
            if (player != null) {
                ItemStack returnStack = ItemStack.f_41583_;
                Level level = player.m_9236_();
                level.m_5594_(player, this.f_58858_, ModSounds.JAR_COOKIE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + level.f_46441_.m_188501_() * 0.1f);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)handStack.m_41720_()));
                if (!player.m_7500_()) {
                    Utils.swapItem((Player)player, (InteractionHand)handIn, (ItemStack)returnStack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean tryAddingItem(ItemStack itemstack) {
        for (int i = 0; i < this.m_7086_().size(); ++i) {
            if (!this.m_7013_(i, itemstack)) continue;
            this.m_6836_(i, itemstack);
            return true;
        }
        return false;
    }

    public void resetHolders() {
        this.fluidHolder.clear();
        this.mobContainer.clear();
        this.m_6520_(NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_));
    }

    public boolean isPonyJar() {
        if (this.m_8077_()) {
            Component c = this.m_7770_();
            return c != null && c.getString().toLowerCase(Locale.ROOT).contains("cum");
        }
        return false;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        try {
            this.fluidHolder.load(compound);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("Failed to load fluid container at {}:", (Object)this.m_58899_(), (Object)e);
        }
        this.mobContainer.load(compound);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        try {
            this.fluidHolder.save(tag);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("Failed to save fluid container at {}:", (Object)this.m_58899_(), (Object)e);
        }
        this.mobContainer.save(tag);
    }

    public boolean hasContent() {
        return !this.m_7983_() || !this.mobContainer.isEmpty() || !this.fluidHolder.isEmpty();
    }

    public boolean isFull() {
        return this.m_7086_().stream().noneMatch(ItemStack::m_41619_);
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"block.supplementaries.jar");
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (this.m_8020_(index).m_41613_() < this.m_6893_() && CommonConfigs.Functional.JAR_COOKIES.get().booleanValue() && this.fluidHolder.isEmpty() && this.mobContainer.isEmpty()) {
            return stack.m_204117_(ModTags.COOKIES);
        }
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public MobContainer getMobContainer() {
        return this.mobContainer;
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)ClockBlock.FACING);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, JarBlockTile tile) {
        tile.mobContainer.tick(pLevel, pPos);
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidHolder;
    }

    public boolean canInteractWithSoftFluidTank() {
        return CommonConfigs.Functional.JAR_LIQUIDS.get() != false && this.m_7983_() && (this.mobContainer.isEmpty() || this.isPonyJar());
    }
}

