/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import de.teamlapen.lib.VampLib;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class VersionChecker
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_HTTP_REDIRECTS = Integer.getInteger("http.maxRedirects", 20);
    private final boolean stats;
    private final String UPDATE_FILE_URL;
    @NotNull
    private final VersionInfo versionInfo;
    private final ArtifactVersion currentVersion;

    public static VersionInfo executeVersionCheck(String updateUrl, @NotNull ArtifactVersion currentVersion, boolean stats) {
        VersionChecker checker = new VersionChecker(updateUrl, currentVersion, stats);
        new Thread(checker).start();
        return checker.versionInfo;
    }

    protected VersionChecker(String update_file_url, @NotNull ArtifactVersion currentVersion, boolean stats) {
        this.UPDATE_FILE_URL = update_file_url;
        this.currentVersion = currentVersion;
        this.versionInfo = new VersionInfo(currentVersion);
        this.stats = stats;
    }

    @Override
    public void run() {
        LOGGER.info("Starting version check at {}", (Object)this.UPDATE_FILE_URL);
        String fullUrl = this.stats ? this.UPDATE_FILE_URL + this.getStatsString() : this.UPDATE_FILE_URL;
        try {
            URL url = new URL(fullUrl);
            this.check(url);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Failed to parse update file url ({})", (Object)fullUrl);
        }
        catch (IOException e) {
            if (e instanceof ConnectException) {
                LOGGER.error("Failed to connect to version check url {}", (Object)this.UPDATE_FILE_URL);
            } else {
                LOGGER.error("Failed to perform version check", (Throwable)e);
            }
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Failed to parse update file. It seems not well formatted", (Throwable)e);
        }
        this.versionInfo.checked = true;
    }

    private void check(URL url) throws IOException, JsonSyntaxException {
        String download;
        Map tmp2;
        Version current;
        InputStream con = this.openUrlStream(url);
        String data = new String(ByteStreams.toByteArray((InputStream)con), StandardCharsets.UTF_8);
        con.close();
        Map json = (Map)new Gson().fromJson(data, Map.class);
        Map promos = (Map)json.get("promos");
        this.versionInfo.homePage = json.getOrDefault("homepage", "");
        String mcVersion = MCPVersion.getMCVersion();
        String rec = (String)promos.get(mcVersion + "-recommended");
        String lat = (String)promos.get(mcVersion + "-latest");
        this.versionInfo.currentVersion = current = Version.from(this.currentVersion);
        Version possibleTarget = null;
        if (current.type == Version.TYPE.RELEASE) {
            if (rec != null) {
                possibleTarget = Version.parse(rec);
            }
        } else if (lat != null) {
            possibleTarget = Version.parse(lat);
        }
        if (possibleTarget == null) {
            LOGGER.info("Did not find a version of type {} for {} ({})", (Object)current.type, (Object)mcVersion, (Object)(current.type == Version.TYPE.RELEASE ? rec : lat));
            return;
        }
        int res = possibleTarget.compareTo(current);
        if (res <= 0) {
            return;
        }
        ArrayList<String> changes = new ArrayList<String>();
        Map tmp = (Map)json.get(MCPVersion.getMCVersion());
        if (tmp != null) {
            ArrayList<Version> ordered = new ArrayList<Version>();
            for (String key : tmp.keySet()) {
                Version ver = Version.parse(key);
                if (ver.compareTo(current) <= 0 || ver.compareTo(possibleTarget) >= 1) continue;
                ordered.add(ver);
            }
            Collections.sort(ordered);
            for (Version ver : ordered) {
                if (ver.type != Version.TYPE.RELEASE && current.type == Version.TYPE.RELEASE) continue;
                changes.add(ver.name + ":\n" + (String)tmp.get(ver.name));
            }
        } else {
            LOGGER.info("No changelog provided for new version {}", (Object)possibleTarget.name);
        }
        possibleTarget.setChanges(changes);
        Map downloads = (Map)json.get("downloads");
        if (downloads != null && (tmp2 = (Map)downloads.get(MCPVersion.getMCVersion())) != null && (download = (String)tmp2.get(possibleTarget.name)) != null) {
            possibleTarget.setUrl(download);
        }
        if (possibleTarget.getUrl() == null) {
            LOGGER.info("No download link provided for new version {}", (Object)possibleTarget.name);
        }
        if (VampLib.inDev) {
            LOGGER.debug("Found new version {}, but in dev", (Object)possibleTarget);
        } else {
            LOGGER.info("Found new version {}", (Object)possibleTarget);
            this.versionInfo.newVersion = possibleTarget;
        }
    }

    @NotNull
    private String getStatsString() {
        return "?current=" + URLEncoder.encode(this.currentVersion.getMajorVersion() + "." + this.currentVersion.getMinorVersion() + "." + this.currentVersion.getIncrementalVersion(), StandardCharsets.UTF_8) + "&mc=" + URLEncoder.encode(MCPVersion.getMCVersion(), StandardCharsets.UTF_8) + "&count=" + URLEncoder.encode("" + ModList.get().size(), StandardCharsets.UTF_8) + "&side=" + (EffectiveSide.get() == LogicalSide.CLIENT ? "client" : "server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream openUrlStream(URL url) throws IOException {
        URL currentUrl = url;
        for (int redirects = 0; redirects < MAX_HTTP_REDIRECTS; ++redirects) {
            URLConnection c = currentUrl.openConnection();
            if (c instanceof HttpURLConnection) {
                HttpURLConnection huc = (HttpURLConnection)c;
                huc.setInstanceFollowRedirects(false);
                int responseCode = huc.getResponseCode();
                if (responseCode >= 300 && responseCode <= 399) {
                    try {
                        String loc = huc.getHeaderField("Location");
                        currentUrl = new URL(currentUrl, loc);
                        continue;
                    }
                    finally {
                        huc.disconnect();
                    }
                }
            }
            return c.getInputStream();
        }
        throw new IOException("Too many redirects while trying to fetch " + url);
    }

    public static class VersionInfo {
        private Version newVersion;
        private Version currentVersion;
        private boolean checked = false;
        private String homePage = "";

        public VersionInfo(@NotNull ArtifactVersion current) {
            this.currentVersion = Version.from(current);
        }

        @NotNull
        public Version getCurrentVersion() {
            return this.currentVersion;
        }

        @NotNull
        public String getHomePage() {
            return this.homePage;
        }

        @Nullable
        public Version getNewVersion() {
            return this.newVersion;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public boolean isNewVersionAvailable() {
            return this.newVersion != null;
        }
    }

    public static class Version
    implements Comparable<Version> {
        public final String name;
        @Nullable
        public final String extra;
        private final TYPE type;
        private final int main;
        private final int major;
        private final int minor;
        private String url;
        private List<String> changes;

        @NotNull
        static Version from(@NotNull ArtifactVersion version) {
            try {
                String extra = null;
                String qualifier = version.getQualifier();
                TYPE type = TYPE.RELEASE;
                if (qualifier != null) {
                    if (qualifier.contains("alpha")) {
                        type = TYPE.ALPHA;
                        int i = qualifier.indexOf(43);
                        if (i != -1) {
                            extra = qualifier.substring(i + 1);
                        }
                    } else if (qualifier.contains("beta")) {
                        type = TYPE.BETA;
                        int i = qualifier.indexOf(46, qualifier.indexOf("beta"));
                        if (i != -1) {
                            extra = qualifier.substring(i + 1);
                        }
                    } else if (qualifier.contains("test")) {
                        type = TYPE.TEST;
                    }
                }
                return new Version(version.toString(), version.getMajorVersion(), version.getMinorVersion(), version.getIncrementalVersion(), type, extra);
            }
            catch (Exception e) {
                LOGGER.error("Parsing version failed", (Throwable)e);
                return new Version("unknown", 0, 0, 0, TYPE.ALPHA, null);
            }
        }

        @NotNull
        static Version parse(@NotNull String s) {
            return Version.from((ArtifactVersion)new DefaultArtifactVersion(s));
        }

        public Version(String name, int main, int major, int minor, TYPE type, @Nullable String extra) {
            this.name = name;
            this.main = main;
            this.major = major;
            this.minor = minor;
            this.type = type;
            this.extra = extra;
        }

        @Override
        public int compareTo(@NotNull Version version) {
            if (version.main > this.main) {
                return -1;
            }
            if (version.main < this.main) {
                return 1;
            }
            if (version.major > this.major) {
                return -1;
            }
            if (version.major < this.major) {
                return 1;
            }
            if (version.minor > this.minor) {
                return -1;
            }
            if (version.minor < this.minor) {
                return 1;
            }
            int i = this.type.compare(version.type);
            if (i != 0) {
                return i;
            }
            if (this.type == TYPE.BETA) {
                try {
                    int nb;
                    int cb = this.extra == null ? 0 : Integer.parseInt(this.extra);
                    int n = nb = version.extra == null ? 0 : Integer.parseInt(version.extra);
                    if (nb > cb) {
                        return -1;
                    }
                    if (nb < cb) {
                        return 1;
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Failed to parse beta number ({}) {}", (Object)this.extra, (Object)e);
                }
                return 0;
            }
            if (this.type == TYPE.ALPHA && this.extra != null && version.extra != null) {
                return this.compareDate(this.extra, version.extra);
            }
            return 0;
        }

        public List<String> getChanges() {
            return this.changes;
        }

        public void setChanges(List<String> changes) {
            this.changes = changes;
        }

        @Nullable
        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean isTestVersion() {
            return this.type == TYPE.TEST;
        }

        @NotNull
        public String toString() {
            return "Version{main=" + this.main + ", major=" + this.major + ", minor=" + this.minor + ", type=" + this.type + ", name='" + this.name + "', url='" + this.url + "'}";
        }

        private int compareDate(@NotNull String one, @NotNull String two) {
            try {
                String[] ones = one.split("-");
                String[] twos = two.split("-");
                for (int i = 0; i < ones.length && i < twos.length; ++i) {
                    int o = Integer.parseInt(ones[i]);
                    int t = Integer.parseInt(twos[i]);
                    if (t > o) {
                        return -1;
                    }
                    if (t >= o) continue;
                    return 1;
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse date {}/{} {}", (Object)one, (Object)two, (Object)e);
            }
            return 0;
        }

        static enum TYPE {
            RELEASE(0),
            BETA(1),
            ALPHA(2),
            TEST(3);

            public final int ORDER;

            private TYPE(int pos) {
                this.ORDER = pos;
            }

            public int compare(@NotNull TYPE type) {
                return Integer.compare(type.ORDER, this.ORDER);
            }
        }
    }
}

