/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.ClientboundBloodValuePacket;
import de.teamlapen.vampirism.network.ClientboundSkillTreePacket;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.lang.reflect.Array;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GeneralEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public void onAttachCapabilityWorld(@NotNull AttachCapabilitiesEvent<Level> event) {
        event.addCapability(REFERENCE.WORLD_CAP_KEY, VampirismWorld.createNewCapability((Level)event.getObject()));
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerLoggedInEvent event) {
        boolean isAdminLikePlayer;
        Player player = event.getEntity();
        boolean bl = isAdminLikePlayer = !ServerLifecycleHooks.getCurrentServer().m_6982_() || UtilLib.isPlayerOp(player);
        if (isAdminLikePlayer && !ModList.get().isLoaded("guideapi_vp") && ((Boolean)VampirismConfig.SERVER.infoAboutGuideAPI.get()).booleanValue()) {
            player.m_213846_((Component)Component.m_237115_((String)"text.vampirism.guideapi_available.first"));
            player.m_213846_((Component)Component.m_237115_((String)"text.vampirism.guideapi_available.download").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/guide-api-village-and-pillage")).m_131162_(Boolean.valueOf(true))));
            VampirismConfig.SERVER.infoAboutGuideAPI.set((Object)false);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            VampirismMod.dispatcher.sendTo(new ClientboundSkillTreePacket(VampirismMod.proxy.getSkillTree(false).getCopy()), serverPlayer);
        }
        Map[] bloodValues = (Map[])Array.newInstance(Map.class, 3);
        bloodValues[0] = BloodConversionRegistry.getEntityConversions();
        bloodValues[1] = BloodConversionRegistry.getItemConversions();
        bloodValues[2] = BloodConversionRegistry.getFluidConversions();
        Map<EntityType<?>, ResourceLocation> convertibleOverlay = VampirismAPI.entityRegistry().getConvertibleOverlay();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            VampirismMod.dispatcher.sendTo(new ClientboundBloodValuePacket(bloodValues, convertibleOverlay), serverPlayer);
        }
        FactionPlayerHandler.getOpt(player).ifPresent(FactionPlayerHandler::onPlayerLoggedIn);
        if (player instanceof ServerPlayer && !Permissions.isSetupCorrectly((ServerPlayer)player)) {
            player.m_213846_((Component)Component.m_237113_((String)("[" + ChatFormatting.DARK_PURPLE + "Vampirism" + ChatFormatting.RESET + "] It seems like the permission plugin used is not properly set up. Make sure all players have 'vampirism.*' for the mod to work (or at least '" + Permissions.GENERAL_CHECK.getNodeName() + "' to suppress this warning).")));
        }
    }

    @SubscribeEvent
    public void onServerTick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer()).tick();
    }

    @SubscribeEvent
    public void onWorldUnload(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            VampirismWorld.getOpt(level).ifPresent(VampirismWorld::clearCaches);
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        int missing = ModLootTables.checkAndResetInsertedAll();
        if (missing > 0) {
            LOGGER.warn("LootTables Failed to inject {} loottables", (Object)missing);
        }
    }
}

