/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import com.mojang.brigadier.CommandDispatcher;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.network.AbstractPacketDispatcher;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.util.Color;
import de.teamlapen.lib.util.OptifineHandler;
import de.teamlapen.vampirism.GeneralEventHandler;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.world.IVampirismWorld;
import de.teamlapen.vampirism.client.core.ClientRegistryHandler;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModCommands;
import de.teamlapen.vampirism.core.ModEntitySelectors;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.core.RegistryManager;
import de.teamlapen.vampirism.data.reloadlistener.BloodValuesReloadListener;
import de.teamlapen.vampirism.data.reloadlistener.SingleJigsawReloadListener;
import de.teamlapen.vampirism.data.reloadlistener.SundamageReloadListener;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.ModEntityEventHandler;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import de.teamlapen.vampirism.entity.action.ActionManagerEntity;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.factions.FactionRegistry;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.player.ModPlayerEventHandler;
import de.teamlapen.vampirism.entity.player.actions.ActionManager;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.skills.SkillManager;
import de.teamlapen.vampirism.entity.player.skills.SkillTreeManager;
import de.teamlapen.vampirism.entity.player.vampire.BloodVision;
import de.teamlapen.vampirism.entity.player.vampire.NightVision;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.items.VampireRefinementItem;
import de.teamlapen.vampirism.items.crossbow.CrossbowArrowHandler;
import de.teamlapen.vampirism.misc.SettingsProvider;
import de.teamlapen.vampirism.misc.VampirismLogger;
import de.teamlapen.vampirism.mixin.ReloadableServerResourcesAccessor;
import de.teamlapen.vampirism.mixin.TagManagerAccessor;
import de.teamlapen.vampirism.modcompat.IMCHandler;
import de.teamlapen.vampirism.modcompat.terrablender.TerraBlenderCompat;
import de.teamlapen.vampirism.network.ModPacketDispatcher;
import de.teamlapen.vampirism.proxy.ClientProxy;
import de.teamlapen.vampirism.proxy.IProxy;
import de.teamlapen.vampirism.proxy.ServerProxy;
import de.teamlapen.vampirism.recipes.ExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.sit.SitHandler;
import de.teamlapen.vampirism.tests.Tests;
import de.teamlapen.vampirism.util.HunterVillage;
import de.teamlapen.vampirism.util.LordTitles;
import de.teamlapen.vampirism.util.MigrationData;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.SupporterManager;
import de.teamlapen.vampirism.util.TelemetryCollector;
import de.teamlapen.vampirism.util.VampireBookManager;
import de.teamlapen.vampirism.util.VampireVillage;
import de.teamlapen.vampirism.util.VampireVisionRegistry;
import de.teamlapen.vampirism.util.VersionUpdater;
import de.teamlapen.vampirism.world.biome.OverworldModifications;
import de.teamlapen.vampirism.world.gen.VanillaStructureModifications;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="vampirism")
public class VampirismMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final AbstractPacketDispatcher dispatcher = new ModPacketDispatcher();
    public static VampirismMod instance;
    public static final IProxy proxy;
    public static boolean inDev;
    public static boolean inDataGen;
    @NotNull
    private final RegistryManager registryManager = new RegistryManager();

    public VampirismMod() {
        instance = this;
        this.checkEnv();
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        modbus.addListener(this::setup);
        modbus.addListener(this::enqueueIMC);
        modbus.addListener(this::processIMC);
        modbus.addListener(this::loadComplete);
        modbus.addListener(this::registerCapabilities);
        modbus.addListener(this::finalizeConfiguration);
        modbus.addListener(VersionUpdater::catchModVersionMismatch);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientRegistryHandler::init);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modbus.addListener(this::setupClient));
        MinecraftForge.EVENT_BUS.register(Permissions.class);
        MinecraftForge.EVENT_BUS.register(SitHandler.class);
        MinecraftForge.EVENT_BUS.register(MigrationData.class);
        MinecraftForge.EVENT_BUS.register((Object)new GeneralEventHandler());
        MinecraftForge.EVENT_BUS.addListener(this::onCommandsRegister);
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListenerEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(VersionUpdater::checkVersionUpdated);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopped);
        MinecraftForge.EVENT_BUS.addListener(this::onDataPackSyncEvent);
        VampirismConfig.init();
        this.prepareAPI();
        RegistryManager.setupRegistries(modbus);
        modbus.addListener(ModItems::registerOtherCreativeTabItems);
        if (OptifineHandler.isOptifineLoaded()) {
            LOGGER.warn("Using Optifine. Expect visual glitches and reduces blood vision functionality if using shaders.");
        }
    }

    public void onAddReloadListenerEvent(@NotNull AddReloadListenerEvent event) {
        SkillTreeManager.getInstance().getSkillTree().initRootSkills();
        event.addListener((PreparableReloadListener)SkillTreeManager.getInstance());
        event.addListener((PreparableReloadListener)new BloodValuesReloadListener());
        event.addListener((PreparableReloadListener)new SingleJigsawReloadListener());
        event.addListener((PreparableReloadListener)new SundamageReloadListener(((TagManagerAccessor)((ReloadableServerResourcesAccessor)event.getServerResources()).getTagManager()).getRegistryAccess()));
    }

    public void onCommandsRegister(@NotNull RegisterCommandsEvent event) {
        ModCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private void checkEnv() {
        String launchTarget = System.getProperty("vampirism_target");
        if (launchTarget != null && launchTarget.contains("dev")) {
            inDev = true;
        }
        if (launchTarget != null && launchTarget.contains("data")) {
            inDataGen = true;
        }
    }

    private void enqueueIMC(@NotNull InterModEnqueueEvent event) {
        this.onInitStep(IInitListener.Step.ENQUEUE_IMC, (ParallelDispatchEvent)event);
        HelperRegistry.registerPlayerEventReceivingCapability(VampirePlayer.CAP, VampirePlayer.class);
        HelperRegistry.registerPlayerEventReceivingCapability(HunterPlayer.CAP, HunterPlayer.class);
        HelperRegistry.registerSyncableEntityCapability(ExtendedCreature.CAP, REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.class);
        HelperRegistry.registerSyncablePlayerCapability(VampirePlayer.CAP, REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(HunterPlayer.CAP, REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(FactionPlayerHandler.CAP, REFERENCE.FACTION_PLAYER_HANDLER_KEY, FactionPlayerHandler.class);
    }

    private void registerCapabilities(@NotNull RegisterCapabilitiesEvent event) {
        event.register(IExtendedCreatureVampirism.class);
        event.register(IFactionPlayerHandler.class);
        event.register(IHunterPlayer.class);
        event.register(IVampirePlayer.class);
        event.register(IVampirismWorld.class);
    }

    private void onServerStarting(@NotNull ServerAboutToStartEvent event) {
        VanillaStructureModifications.addVillageStructures((RegistryAccess)event.getServer().m_206579_());
        ((SundamageRegistry)VampirismAPI.sundamageRegistry()).initServer((RegistryAccess)event.getServer().m_206579_());
    }

    private void onServerStopped(ServerStoppedEvent event) {
        ((SundamageRegistry)VampirismAPI.sundamageRegistry()).removeServer();
    }

    private void onDataPackSyncEvent(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            ((SundamageRegistry)VampirismAPI.sundamageRegistry()).updateClient(event.getPlayer());
        } else {
            event.getPlayerList().m_11314_().forEach(player -> ((SundamageRegistry)VampirismAPI.sundamageRegistry()).updateClient((ServerPlayer)player));
        }
    }

    private void finalizeConfiguration(RegisterEvent event) {
        VampirismConfig.finalizeAndRegisterConfig();
    }

    private void finishAPI() {
        ((FactionRegistry)VampirismAPI.factionRegistry()).finish();
        ((VampirismEntityRegistry)VampirismAPI.entityRegistry()).finishRegistration();
    }

    private void loadComplete(@NotNull FMLLoadCompleteEvent event) {
        this.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        event.enqueueWork(OverworldModifications::addBiomesToOverworldUnsafe);
        VampirismAPI.skillManager().registerSkillType(SkillType.LEVEL);
        VampirismAPI.skillManager().registerSkillType(SkillType.LORD);
        DistExecutor.safeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> VampirismLogger::init);
    }

    private void prepareAPI() {
        VampirismAPI.setUpRegistries(new FactionRegistry(), new SundamageRegistry(), new VampirismEntityRegistry(DefaultConvertingHandler::new), new ActionManager(), new SkillManager(), new VampireVisionRegistry(), new ActionManagerEntity(), new ExtendedBrewingRecipeRegistry(), new SettingsProvider("https://api.vampirism.dev/api/v1"));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> proxy::setupAPIClient);
        VReference.VAMPIRE_FACTION = VampirismAPI.factionRegistry().createPlayableFaction(REFERENCE.VAMPIRE_PLAYER_KEY, IVampirePlayer.class, () -> VampirePlayer.CAP).color(Color.MAGENTA_DARK.getRGB()).chatColor(ChatFormatting.DARK_PURPLE).name("text.vampirism.vampire").namePlural("text.vampirism.vampires").hostileTowardsNeutral().highestLevel(14).lord().lordLevel(5).lordTitle(LordTitles::getVampireTitle).enableLordSkills().minion(VampireMinionEntity.VampireMinionData.ID).minionData(VampireMinionEntity.VampireMinionData::new).build().build().village(VampireVillage::vampireVillage).refinementItems(VampireRefinementItem::getItemForType).addTag(ForgeRegistries.Keys.BIOMES, (TagKey)ModTags.Biomes.IS_VAMPIRE_BIOME).addTag(ForgeRegistries.Keys.POI_TYPES, (TagKey)ModTags.PoiTypes.IS_VAMPIRE).addTag(ForgeRegistries.Keys.VILLAGER_PROFESSIONS, (TagKey)ModTags.Professions.IS_VAMPIRE).addTag(ForgeRegistries.Keys.ENTITY_TYPES, (TagKey)ModTags.Entities.VAMPIRE).addTag((ResourceKey)VampirismRegistries.TASK_ID, (TagKey)ModTags.Tasks.IS_VAMPIRE).register();
        VReference.HUNTER_FACTION = VampirismAPI.factionRegistry().createPlayableFaction(REFERENCE.HUNTER_PLAYER_KEY, IHunterPlayer.class, () -> HunterPlayer.CAP).color(Color.BLUE.getRGB()).chatColor(ChatFormatting.BLUE).name("text.vampirism.hunter").namePlural("text.vampirism.hunters").highestLevel(14).lord().lordLevel(5).lordTitle(LordTitles::getHunterTitle).enableLordSkills().minion(HunterMinionEntity.HunterMinionData.ID).minionData(HunterMinionEntity.HunterMinionData::new).build().build().village(HunterVillage::hunterVillage).addTag(ForgeRegistries.Keys.BIOMES, (TagKey)ModTags.Biomes.IS_HUNTER_BIOME).addTag(ForgeRegistries.Keys.POI_TYPES, (TagKey)ModTags.PoiTypes.IS_HUNTER).addTag(ForgeRegistries.Keys.VILLAGER_PROFESSIONS, (TagKey)ModTags.Professions.IS_HUNTER).addTag(ForgeRegistries.Keys.ENTITY_TYPES, (TagKey)ModTags.Entities.HUNTER).addTag((ResourceKey)VampirismRegistries.TASK_ID, (TagKey)ModTags.Tasks.IS_HUNTER).register();
        VReference.vision_nightVision = VampirismAPI.vampireVisionRegistry().registerVision(new ResourceLocation("vampirism", "night_vision"), new NightVision());
        VReference.vision_bloodVision = VampirismAPI.vampireVisionRegistry().registerVision(new ResourceLocation("vampirism", "blood_vision"), new BloodVision());
        VampirismAPI.onSetupComplete();
        MinionData.registerDataTypes();
    }

    private void processIMC(@NotNull InterModProcessEvent event) {
        this.finishAPI();
        this.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
        IMCHandler.handleInterModMessage(event);
        if (inDev) {
            Tests.runBackgroundTests();
        }
        CrossbowArrowHandler.collectCrossbowArrows();
    }

    private void setup(@NotNull FMLCommonSetupEvent event) {
        dispatcher.registerPackets();
        this.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        MinecraftForge.EVENT_BUS.register((Object)new ModPlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModEntityEventHandler());
        MinecraftForge.EVENT_BUS.addListener(ModLootTables::onLootLoad);
        SupporterManager.init();
        VampireBookManager.getInstance().init();
        ModEntitySelectors.registerSelectors();
        event.enqueueWork(TerraBlenderCompat::registerBiomeProviderIfPresentUnsafe);
        event.enqueueWork(ModAdvancements::registerSubPredicatesUnsafe);
        TelemetryCollector.execute();
    }

    private void setupClient(@NotNull FMLClientSetupEvent event) {
        this.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
    }

    private void onInitStep(@NotNull IInitListener.Step step, @NotNull ParallelDispatchEvent event) {
        this.registryManager.onInitStep(step, event);
        proxy.onInitStep(step, event);
    }

    static {
        proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        inDev = false;
        inDataGen = false;
    }
}

