/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.inventory.HunterTableMenu;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterTableBlock
extends VampirismHorizontalBlock {
    public static final EnumProperty<TABLE_VARIANT> VARIANT = EnumProperty.m_61587_((String)"variant", TABLE_VARIANT.class);
    private static final VoxelShape NORTH = HunterTableBlock.makeShape();
    private static final VoxelShape NORTH_HAMMER = Shapes.m_83110_((VoxelShape)HunterTableBlock.makeShape(), (VoxelShape)HunterTableBlock.makeHammerShape());
    private static final VoxelShape EAST = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.NINETY);
    private static final VoxelShape EAST_HAMMER = UtilLib.rotateShape(NORTH_HAMMER, UtilLib.RotationAmount.NINETY);
    private static final VoxelShape SOUTH = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.HUNDRED_EIGHTY);
    private static final VoxelShape SOUTH_HAMMER = UtilLib.rotateShape(NORTH_HAMMER, UtilLib.RotationAmount.HUNDRED_EIGHTY);
    private static final VoxelShape WEST = UtilLib.rotateShape(NORTH, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
    private static final VoxelShape WEST_HAMMER = UtilLib.rotateShape(NORTH_HAMMER, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.625, (double)0.375, (double)0.5, (double)0.6875, (double)0.875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.75, (double)0.375, (double)0.5, (double)0.8125, (double)0.875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.6875, (double)0.375, (double)0.1875, (double)0.75, (double)0.875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.6875, (double)0.40625, (double)0.46875, (double)0.75, (double)0.84375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)0.625, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.75, (double)0.25, (double)0.5, (double)0.9375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.75, (double)0.9375, (double)0.5, (double)0.9375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5, (double)0.25));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.25, (double)0.5, (double)0.25));
        return shape;
    }

    @NotNull
    private static VoxelShape makeHammerShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.0, (double)0.5625, (double)0.75, (double)0.1875, (double)0.75));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5625, (double)0.1875, (double)0.625, (double)0.625, (double)0.624375, (double)0.6875));
        return shape;
    }

    @NotNull
    public static TABLE_VARIANT getTierFor(boolean weapon_table, boolean potion_table, boolean cauldron) {
        return weapon_table ? (potion_table ? (cauldron ? TABLE_VARIANT.COMPLETE : TABLE_VARIANT.WEAPON_POTION) : (cauldron ? TABLE_VARIANT.WEAPON_CAULDRON : TABLE_VARIANT.WEAPON)) : (potion_table ? (cauldron ? TABLE_VARIANT.POTION_CAULDRON : TABLE_VARIANT.POTION) : (cauldron ? TABLE_VARIANT.CAULDRON : TABLE_VARIANT.SIMPLE));
    }

    public HunterTableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(0.5f).m_278183_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(VARIANT, (Comparable)((Object)TABLE_VARIANT.SIMPLE)));
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((TABLE_VARIANT)((Object)state.m_61143_(VARIANT))) {
            default -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case EAST: {
                        yield EAST;
                    }
                    case SOUTH: {
                        yield SOUTH;
                    }
                    case WEST: {
                        yield WEST;
                    }
                }
                yield NORTH;
            }
            case TABLE_VARIANT.WEAPON_CAULDRON, TABLE_VARIANT.WEAPON_POTION, TABLE_VARIANT.COMPLETE, TABLE_VARIANT.WEAPON -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case EAST: {
                        yield EAST_HAMMER;
                    }
                    case SOUTH: {
                        yield SOUTH_HAMMER;
                    }
                    case WEST: {
                        yield WEST_HAMMER;
                    }
                }
                yield NORTH_HAMMER;
            }
        };
    }

    @Override
    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(VARIANT, (Comparable)((Object)this.determineTier((LevelReader)context.m_43725_(), context.m_8083_(), facing)));
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (fromPos.m_123342_() != pos.m_123342_()) {
            return;
        }
        TABLE_VARIANT newVariant = this.determineTier((LevelReader)worldIn, pos, (Direction)state.m_61143_((Property)FACING));
        if (newVariant != state.m_61143_(VARIANT)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)newVariant)), 2);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!worldIn.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_36220_(ModStats.interact_with_research_table);
            if (Helper.isHunter((Player)serverPlayer)) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, playerInventory, playerIn) -> new HunterTableMenu(id, playerInventory, ContainerLevelAccess.m_39289_((Level)playerIn.m_9236_(), (BlockPos)pos)), (Component)Component.m_237115_((String)"container.crafting")), (BlockPos)pos);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.unfamiliar"), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT});
    }

    protected TABLE_VARIANT determineTier(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Direction facing) {
        Block behind = world.m_8055_(pos.m_121945_(facing)).m_60734_();
        Block left = world.m_8055_(pos.m_121945_(facing.m_122427_())).m_60734_();
        Block right = world.m_8055_(pos.m_121945_(facing.m_122428_())).m_60734_();
        Block front = world.m_8055_(pos.m_121945_(facing.m_122424_())).m_60734_();
        boolean weapon_table = left == ModBlocks.WEAPON_TABLE.get() || right == ModBlocks.WEAPON_TABLE.get() || behind == ModBlocks.WEAPON_TABLE.get() || front == ModBlocks.WEAPON_TABLE.get();
        boolean potion_table = left == ModBlocks.POTION_TABLE.get() || right == ModBlocks.POTION_TABLE.get() || behind == ModBlocks.POTION_TABLE.get() || front == ModBlocks.POTION_TABLE.get();
        boolean cauldron = left == ModBlocks.ALCHEMICAL_CAULDRON.get() || right == ModBlocks.ALCHEMICAL_CAULDRON.get() || behind == ModBlocks.ALCHEMICAL_CAULDRON.get() || front == ModBlocks.ALCHEMICAL_CAULDRON.get();
        return HunterTableBlock.getTierFor(weapon_table, potion_table, cauldron);
    }

    public static enum TABLE_VARIANT implements StringRepresentable
    {
        SIMPLE("simple", 0),
        WEAPON("weapon", 1),
        CAULDRON("cauldron", 1),
        POTION("potion", 1),
        WEAPON_CAULDRON("weapon_cauldron", 2),
        WEAPON_POTION("weapon_potion", 2),
        POTION_CAULDRON("potion_cauldron", 2),
        COMPLETE("complete", 3);

        public final String name;
        public final int tier;

        private TABLE_VARIANT(String n2, int tier) {
            this.name = n2;
            this.tier = tier;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

