/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks.mother;

import de.teamlapen.vampirism.blockentity.MotherBlockEntity;
import de.teamlapen.vampirism.blocks.HorizontalContainerBlock;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.blocks.mother.IRemainsBlock;
import de.teamlapen.vampirism.core.ModTiles;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotherBlock
extends VampirismBlock
implements EntityBlock,
IRemainsBlock {
    public MotherBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283774_).m_60913_(5.0f, 3600000.0f).m_60918_(SoundType.f_56728_));
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    private Optional<MotherBlockEntity> getBlockEntity(@NotNull BlockGetter level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MotherBlockEntity) {
            MotherBlockEntity mother = (MotherBlockEntity)blockEntity;
            return Optional.of(mother);
        }
        return Optional.empty();
    }

    @Override
    public boolean isVulnerable(BlockState state) {
        return false;
    }

    @Override
    public boolean isMother(BlockState state) {
        return true;
    }

    @Override
    public boolean isVulnerability(BlockState state) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MotherBlockEntity(pos, state);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.getBlockEntity((BlockGetter)level, pos).map(MotherBlockEntity::isCanBeBroken).orElse(Boolean.TRUE).booleanValue()) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        return false;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.m_5776_() ? null : HorizontalContainerBlock.createTickerHelper(type, (BlockEntityType)ModTiles.MOTHER.get(), MotherBlockEntity::serverTick);
    }
}

