/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.GameProfileCache;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

public class MinionArgument
implements ArgumentType<MinionId> {
    public static final SimpleCommandExceptionType NO_MINION_FOUND = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.vampirism.argument.minion.notfound"));
    private final Supplier<Collection<MinionId>> playerMinionIds;

    public MinionArgument() {
        this.playerMinionIds = this::getPlayerMinionIds;
    }

    public MinionArgument(Collection<MinionId> playerMinionIds) {
        this.playerMinionIds = () -> playerMinionIds;
    }

    public static MinionArgument minions() {
        return new MinionArgument();
    }

    public static MinionId getId(CommandContext<CommandSourceStack> source, String argumentId) {
        return (MinionId)source.getArgument(argumentId, MinionId.class);
    }

    private Collection<MinionId> getPlayerMinionIds() {
        MinionWorldData data = MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer());
        GameProfileCache profileCache = ServerLifecycleHooks.getCurrentServer().m_129927_();
        return data.getControllers().entrySet().stream().flatMap(entry -> profileCache.m_11002_((UUID)entry.getKey()).stream().flatMap(k -> ((PlayerMinionController)entry.getValue()).getMinionIdForName(k.getName()).stream())).collect(Collectors.toList());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining();
        this.filterResources((Iterable<MinionId>)this.playerMinionIds.get(), s, arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    void filterResources(Iterable<MinionId> arguments, String commandText, Consumer<String> consumer) {
        for (MinionId id : arguments) {
            if (!SharedSuggestionProvider.m_82949_((String)commandText, (String)id.toEscaped()) && !SharedSuggestionProvider.m_82949_((String)commandText, (String)id.toShort())) continue;
            consumer.accept(id.toShort());
            consumer.accept(id.toEscaped());
        }
    }

    public MinionId parse(StringReader reader) throws CommandSyntaxException {
        StringBuilder builder = new StringBuilder();
        boolean isQuotes = false;
        int prev = 0;
        while (reader.canRead()) {
            char c = reader.peek();
            if (c == '\"' && prev != 92) {
                isQuotes = !isQuotes;
                reader.skip();
                continue;
            }
            if (c == ' ' && !isQuotes) break;
            builder.append(c);
            reader.skip();
            prev = c;
        }
        MinionId id = new MinionId(builder.toString());
        if (this.playerMinionIds.get().contains(id)) {
            return id;
        }
        throw NO_MINION_FOUND.create();
    }

    public static class MinionId {
        public final String player;
        public final int id;
        public String name;

        public MinionId(String player, int id, String name) {
            this.player = player;
            this.id = id;
            this.name = name;
        }

        public MinionId(String id) throws NumberFormatException {
            int first = id.indexOf(58);
            this.player = id.substring(0, first);
            int second = id.indexOf(124);
            if (second == -1) {
                this.id = Integer.parseInt(id.substring(first + 1).trim());
                this.name = "";
            } else {
                this.id = Integer.parseInt(id.substring(first + 1, second).trim());
                this.name = id.length() > second + 1 ? id.substring(second + 1).trim() : "";
            }
        }

        public void updateName(String name) {
            this.name = name;
        }

        public String toString() {
            if (this.name.isEmpty()) {
                return this.player + ":" + this.id;
            }
            return this.player + ":" + this.id + " | " + this.name;
        }

        public String toEscaped() {
            Object res = StringEscapeUtils.escapeJava((String)(this.player + ":" + this.id + " | " + this.name));
            if (((String)res).contains(" ")) {
                res = "\"" + (String)res + "\"";
            }
            return res;
        }

        public String toShort() {
            return this.player + ":" + this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MinionId id1 = (MinionId)o;
            if (this.id != id1.id) {
                return false;
            }
            return Objects.equals(this.player, id1.player);
        }

        public int hashCode() {
            int result = this.player != null ? this.player.hashCode() : 0;
            result = 31 * result + this.id;
            return result;
        }
    }

    public static class Info
    implements ArgumentTypeInfo<MinionArgument, Template> {
        public void serializeToNetwork(Template tempalte, FriendlyByteBuf buffer) {
            Collection<MinionId> ids = tempalte.ids;
            buffer.m_130130_(ids.size());
            ids.forEach(id -> buffer.m_130070_(id.toString()));
        }

        @NotNull
        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            ArrayList<MinionId> ids = new ArrayList<MinionId>(size);
            for (int i = 0; i < size; ++i) {
                ids.add(new MinionId(buffer.m_130277_()));
            }
            return new Template(ids);
        }

        public void serializeToJson(Template template, JsonObject json) {
            JsonArray array = new JsonArray();
            template.ids.forEach(id -> array.add(id.toString()));
            json.add("playerMinionIds", (JsonElement)array);
        }

        @NotNull
        public Template unpack(@NotNull MinionArgument argument) {
            return new Template(argument.playerMinionIds.get());
        }

        public class Template
        implements ArgumentTypeInfo.Template<MinionArgument> {
            final Collection<MinionId> ids;

            public Template(Collection<MinionId> ids) {
                this.ids = ids;
            }

            @NotNull
            public MinionArgument instantiate(@NotNull CommandBuildContext context) {
                return new MinionArgument(this.ids);
            }

            @NotNull
            public ArgumentTypeInfo<MinionArgument, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

