/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class MinionCommand
extends BasicCommand {
    private static final DynamicCommandExceptionType fail = new DynamicCommandExceptionType(msg -> Component.m_237113_((String)("Failed: " + msg)));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"minion").requires(context -> context.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spawnNew").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"vampire").executes(context -> MinionCommand.spawnNewVampireMinion((CommandSourceStack)context.getSource(), "Minion", -1, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> MinionCommand.spawnNewVampireMinion((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), -1, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)IntegerArgumentType.integer((int)-1, (int)126)).executes(context -> MinionCommand.spawnNewVampireMinion((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"type"), false))).then(Commands.m_82129_((String)"use_lord_skin", (ArgumentType)BoolArgumentType.bool()).executes(context -> MinionCommand.spawnNewVampireMinion((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"type"), BoolArgumentType.getBool((CommandContext)context, (String)"use_lord_skin")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"hunter").executes(context -> MinionCommand.spawnNewHunterMinion((CommandSourceStack)context.getSource(), "Minion", -1, 0, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> MinionCommand.spawnNewHunterMinion((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), -1, 0, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)IntegerArgumentType.integer((int)-1, (int)126)).executes(context -> MinionCommand.spawnNewHunterMinion((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"type"), 0, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"hat", (ArgumentType)IntegerArgumentType.integer((int)-1, (int)3)).executes(context -> MinionCommand.spawnNewHunterMinion((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"hat"), false))).then(Commands.m_82129_((String)"use_lord_skin", (ArgumentType)BoolArgumentType.bool()).executes(context -> MinionCommand.spawnNewHunterMinion((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"hat"), BoolArgumentType.getBool((CommandContext)context, (String)"use_lord_skin")))))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"recall").executes(context -> MinionCommand.recall((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> MinionCommand.recall((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"respawnAll").executes(context -> MinionCommand.respawn((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> MinionCommand.respawn((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"purge").executes(context -> MinionCommand.purge((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> MinionCommand.purge((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target")))));
    }

    private static int spawnNewVampireMinion(@NotNull CommandSourceStack ctx, String name, int type, boolean useLordSkin) throws CommandSyntaxException {
        boolean hasIncreasedStats = VampirePlayer.getOpt((Player)ctx.m_81375_()).map(IFactionPlayer::getSkillHandler).map(skillHandler -> skillHandler.isSkillEnabled((ISkill)VampireSkills.MINION_STATS_INCREASE.get())).orElse(false);
        VampireMinionEntity.VampireMinionData data = new VampireMinionEntity.VampireMinionData(name, type, useLordSkin, hasIncreasedStats);
        return MinionCommand.spawnNewMinion(ctx, VReference.VAMPIRE_FACTION, data, (EntityType)ModEntities.VAMPIRE_MINION.get());
    }

    private static int spawnNewHunterMinion(@NotNull CommandSourceStack ctx, String name, int type, int hat, boolean useLordSkin) throws CommandSyntaxException {
        boolean hasIncreasedStats = HunterPlayer.getOpt((Player)ctx.m_81375_()).map(IFactionPlayer::getSkillHandler).map(skillHandler -> skillHandler.isSkillEnabled((ISkill)HunterSkills.MINION_STATS_INCREASE.get())).orElse(false);
        HunterMinionEntity.HunterMinionData data = new HunterMinionEntity.HunterMinionData(name, type, hat, useLordSkin, hasIncreasedStats);
        return MinionCommand.spawnNewMinion(ctx, VReference.HUNTER_FACTION, data, (EntityType)ModEntities.HUNTER_MINION.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends MinionData> int spawnNewMinion(@NotNull CommandSourceStack ctx, IPlayableFaction<?> faction, @NotNull T data, EntityType<? extends MinionEntity<T>> type) throws CommandSyntaxException {
        ServerPlayer p = ctx.m_81375_();
        FactionPlayerHandler fph = FactionPlayerHandler.get((Player)p);
        if (fph.getMaxMinions() <= 0) throw fail.create((Object)"Can't have minions");
        PlayerMinionController controller = MinionWorldData.getData(ctx.m_81377_()).getOrCreateController(fph);
        if (!controller.hasFreeMinionSlot()) throw fail.create((Object)"No free slot");
        if (fph.getCurrentFaction() != faction) throw fail.create((Object)"Wrong faction");
        int id = controller.createNewMinionSlot(data, type);
        if (id < 0) {
            throw fail.create((Object)"Failed to get new minion slot");
        }
        controller.createMinionEntityAtPlayer(id, (Player)p);
        return 0;
    }

    private static int recall(@NotNull CommandSourceStack ctx, ServerPlayer player) throws CommandSyntaxException {
        FactionPlayerHandler fph = FactionPlayerHandler.get((Player)player);
        if (fph.getMaxMinions() > 0) {
            PlayerMinionController controller = MinionWorldData.getData(ctx.m_81377_()).getOrCreateController(fph);
            Collection<Integer> ids = controller.recallMinions(true);
            for (Integer id : ids) {
                controller.createMinionEntityAtPlayer(id, (Player)player);
            }
        } else {
            throw fail.create((Object)"Can't have minions");
        }
        return 0;
    }

    private static int respawn(@NotNull CommandSourceStack ctx, ServerPlayer player) throws CommandSyntaxException {
        FactionPlayerHandler fph = FactionPlayerHandler.get((Player)player);
        if (fph.getMaxMinions() > 0) {
            PlayerMinionController controller = MinionWorldData.getData(ctx.m_81377_()).getOrCreateController(fph);
            Collection<Integer> ids = controller.getUnclaimedMinions();
            for (Integer id : ids) {
                controller.createMinionEntityAtPlayer(id, (Player)player);
            }
        } else {
            throw fail.create((Object)"Can't have minions");
        }
        return 0;
    }

    private static int purge(@NotNull CommandSourceStack ctx, ServerPlayer player) throws CommandSyntaxException {
        MinionWorldData.getData(ctx.m_81377_()).purgeController(player.m_20148_());
        player.m_5661_((Component)Component.m_237113_((String)"Reload world"), false);
        return 0;
    }
}

