/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.reloadlistener;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.registries.holdersets.OrHolderSet;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SundamageReloadListener
implements PreparableReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String directory = "vampirism";
    private static final String fileName = "no_sun_damage.json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final RegistryAccess registryAccess;

    public SundamageReloadListener(RegistryAccess registryAccess) {
        this.registryAccess = registryAccess;
    }

    @NotNull
    public CompletableFuture<Void> m_5540_(@NotNull PreparableReloadListener.PreparationBarrier pPreparationBarrier, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pPreparationsProfiler, @NotNull ProfilerFiller pReloadProfiler, @NotNull Executor pBackgroundExecutor, @NotNull Executor pGameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.load(pResourceManager)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)pPreparationBarrier).m_6769_(arg_0))).thenAcceptAsync(this::apply, pGameExecutor);
    }

    private SundamageRegistry.Settings load(@NotNull ResourceManager manager) {
        ArrayList<RawFile> files = new ArrayList<RawFile>();
        for (Map.Entry entry : manager.m_214160_(directory, location -> location.m_135815_().endsWith(fileName)).entrySet()) {
            ResourceLocation resourceName = new ResourceLocation(((ResourceLocation)entry.getKey()).m_135827_(), ((ResourceLocation)entry.getKey()).m_135815_().substring(directory.length() + 1, ((ResourceLocation)entry.getKey()).m_135815_().length() - PATH_SUFFIX_LENGTH));
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        files.add((RawFile)RawFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Could not read single jigsaw pieces file {} from {}", (Object)resourceName, (Object)resource.m_215506_(), (Object)e);
                }
            }
        }
        return this.merge(files);
    }

    private SundamageRegistry.Settings merge(List<RawFile> files) {
        Registry biomes = this.registryAccess.m_175515_(Registries.f_256952_);
        ArrayList biomeHolder = new ArrayList();
        ArrayList<Object> biomeSets = new ArrayList<Object>();
        Registry dimensions = this.registryAccess.m_175515_(Registries.f_256787_);
        ArrayList dimensionHolder = new ArrayList();
        ArrayList<Object> dimensionSets = new ArrayList<Object>();
        HashSet<ResourceKey<Level>> levels = new HashSet<ResourceKey<Level>>();
        HashSet<ResourceKey<Level>> levelsPositive = new HashSet<ResourceKey<Level>>();
        for (RawFile file : files) {
            if (file.replace()) {
                biomeHolder.clear();
                biomeSets.clear();
                dimensionHolder.clear();
                dimensionSets.clear();
                levels.clear();
            }
            for (ExtraCodecs.TagOrElementLocation biome : file.biomes()) {
                if (biome.f_216196_()) {
                    biomeSets.add(biomes.m_203561_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)biome.f_216195_())));
                    continue;
                }
                biomes.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biome.f_216195_())).ifPresent(biomeHolder::add);
            }
            for (ExtraCodecs.TagOrElementLocation dimension : file.dimension()) {
                if (dimension.f_216196_()) {
                    dimensionSets.add(dimensions.m_203561_(TagKey.m_203882_((ResourceKey)Registries.f_256787_, (ResourceLocation)dimension.f_216195_())));
                    continue;
                }
                dimensions.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)dimension.f_216195_())).ifPresent(dimensionHolder::add);
            }
            levels.addAll(file.levelsNoDamage());
            levelsPositive.addAll(file.levelsDamage());
        }
        biomeSets.add(HolderSet.m_205800_(biomeHolder));
        dimensionSets.add(HolderSet.m_205800_(dimensionHolder));
        return new SundamageRegistry.Settings((HolderSet<Biome>)new OrHolderSet(biomeSets), (HolderSet<DimensionType>)new OrHolderSet(dimensionSets), levels, levelsPositive);
    }

    private void apply(SundamageRegistry.Settings file) {
        ((SundamageRegistry)VampirismAPI.sundamageRegistry()).applyData(file);
    }

    public record RawFile(boolean replace, List<ExtraCodecs.TagOrElementLocation> biomes, List<ExtraCodecs.TagOrElementLocation> dimension, List<ResourceKey<Level>> levelsNoDamage, List<ResourceKey<Level>> levelsDamage) {
        private static final Codec<Pair<List<ResourceKey<Level>>, List<ResourceKey<Level>>>> LEVEL_CODEC = RecordCodecBuilder.create(inst1 -> inst1.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).listOf().optionalFieldOf("no_damage", Collections.emptyList()).forGetter(Pair::getKey), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).listOf().optionalFieldOf("damage", Collections.emptyList()).forGetter(Pair::getValue)).apply((Applicative)inst1, Pair::of));
        public static final Codec<RawFile> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(RawFile::replace), (App)ExtraCodecs.f_216161_.listOf().optionalFieldOf("biomes", Collections.emptyList()).forGetter(RawFile::biomes), (App)ExtraCodecs.f_216161_.listOf().optionalFieldOf("dimensions", Collections.emptyList()).forGetter(RawFile::dimension), (App)LEVEL_CODEC.optionalFieldOf("levels", (Object)Pair.of(Collections.emptyList(), Collections.emptyList())).forGetter(x -> Pair.of(x.levelsNoDamage(), x.levelsDamage()))).apply((Applicative)inst, (replace, biome, dimensions, levels) -> new RawFile((boolean)replace, (List<ExtraCodecs.TagOrElementLocation>)biome, (List<ExtraCodecs.TagOrElementLocation>)dimensions, (List)levels.getLeft(), (List)levels.getRight())));
    }
}

