/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.IFactionMinionTask;
import de.teamlapen.vampirism.api.entity.minion.IMinionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.minion.management.DefaultMinionTask;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectResourcesTask<Q extends MinionData>
extends DefaultMinionTask<Desc<Q>, Q>
implements IFactionMinionTask<Desc<Q>, Q> {
    @NotNull
    private final Function<Q, Integer> coolDownSupplier;
    @NotNull
    private final List<WeightedEntry.Wrapper<ItemStack>> resources;
    private final RandomSource rng = RandomSource.m_216327_();
    @Nullable
    private final IFaction<?> faction;

    public CollectResourcesTask(@Nullable IFaction<?> faction, @NotNull Function<Q, Integer> coolDownSupplier, @NotNull List<WeightedEntry.Wrapper<ItemStack>> resources, @NotNull Supplier<? extends ISkill<?>> requiredSkill) {
        super(requiredSkill);
        this.coolDownSupplier = coolDownSupplier;
        this.resources = resources;
        this.faction = faction;
    }

    @Override
    public Desc<Q> activateTask(@Nullable Player lord, @Nullable IMinionEntity minion, Q data) {
        this.triggerAdvancements(lord);
        if (minion != null) {
            minion.recallMinion();
        }
        if (lord != null) {
            lord.m_5661_((Component)Component.m_237115_((String)(Util.m_137492_((String)"minion_task", (ResourceLocation)RegUtil.id(this)) + ".start")), true);
        }
        return new Desc(this, this.coolDownSupplier.apply(data), lord != null ? lord.m_20148_() : null);
    }

    @Override
    public void deactivateTask(Desc<Q> desc) {
    }

    @Override
    public boolean isAvailable(@NotNull IPlayableFaction<?> faction, @Nullable ILordPlayer player) {
        return (this.faction == null || this.faction == faction) && this.isRequiredSkillUnlocked(faction, player);
    }

    @Override
    @NotNull
    public Desc<Q> readFromNBT(@NotNull CompoundTag nbt) {
        return new Desc(this, nbt.m_128451_("cooldown"), nbt.m_128441_("lordid") ? nbt.m_128342_("lordid") : null);
    }

    @Override
    public void tickBackground(@NotNull Desc<Q> desc, @NotNull Q data) {
        if (--desc.coolDown <= 0) {
            ItemStack stack2;
            boolean lordOnline = desc.lordEntityID != null && ServerLifecycleHooks.getCurrentServer() != null && ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(desc.lordEntityID) != null;
            desc.coolDown = lordOnline ? this.coolDownSupplier.apply(data) : (int)((double)this.coolDownSupplier.apply(data).intValue() * (Double)VampirismConfig.BALANCE.miResourceCooldownOfflineMult.get());
            WeightedRandom.m_216822_((RandomSource)this.rng, this.resources).map(WeightedEntry.Wrapper::m_146310_).map(ItemStack::m_41777_).ifPresent(s -> data.getInventory().addItemStack((ItemStack)s));
            List<ItemStack> stacks = Stream.of(((MinionData)data).getInventory().getInventoryArmor(), ((MinionData)data).getInventory().getInventoryHands()).flatMap(Collection::stream).filter(stack -> !stack.m_41619_()).toList();
            if (!stacks.isEmpty() && (stack2 = stacks.get(this.rng.m_188503_(stacks.size()))).isRepairable() && stack2.m_41773_() > 0) {
                stack2.m_41721_(Math.max(0, stack2.m_41773_() - (Integer)VampirismConfig.BALANCE.miEquipmentRepairAmount.get()));
            }
        }
    }

    @Override
    @Nullable
    public IFaction<?> getFaction() {
        return this.faction;
    }

    public static class Desc<Z extends MinionData>
    implements IMinionTask.IMinionTaskDesc<Z> {
        private final CollectResourcesTask<Z> task;
        @Nullable
        private final UUID lordEntityID;
        private int coolDown;

        public Desc(CollectResourcesTask<Z> task, int coolDown, @Nullable UUID lordEntityID) {
            this.task = task;
            this.coolDown = coolDown;
            this.lordEntityID = lordEntityID;
        }

        @Override
        public IMinionTask<?, Z> getTask() {
            return this.task;
        }

        @Override
        public void writeToNBT(@NotNull CompoundTag nbt) {
            nbt.m_128405_("cooldown", this.coolDown);
            if (this.lordEntityID != null) {
                nbt.m_128362_("lordid", this.lordEntityID);
            }
        }
    }
}

