/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.actions;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.event.ActionEvent;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionHandler<T extends IFactionPlayer<T>>
implements IActionHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger(ActionHandler.class);
    @NotNull
    private final Object2IntMap<ResourceLocation> cooldownTimers;
    @NotNull
    private final Object2IntMap<ResourceLocation> activeTimers;
    @NotNull
    private final Object2IntMap<ResourceLocation> expectedCooldownTimes;
    @NotNull
    private final Object2IntMap<ResourceLocation> expectedDurations;
    private final T player;
    private final List<IAction<T>> unlockedActions = new ArrayList<IAction<T>>();
    private boolean dirty = false;

    public ActionHandler(@NotNull T player) {
        this.player = player;
        List actions = VampirismAPI.actionManager().getActionsForFaction(player.getFaction());
        this.cooldownTimers = new Object2IntOpenHashMap(actions.size(), 0.9f);
        this.activeTimers = new Object2IntOpenHashMap(actions.size(), 0.9f);
        this.expectedCooldownTimes = new Object2IntOpenHashMap(actions.size(), 0.9f);
        this.expectedDurations = new Object2IntOpenHashMap(actions.size(), 0.9f);
    }

    @Override
    public void deactivateAllActions() {
        for (ResourceLocation r : this.activeTimers.keySet()) {
            ILastingAction action = (ILastingAction)RegUtil.getAction(r);
            assert (action != null);
            this.deactivateAction(action, false, true);
        }
        this.activeTimers.clear();
        this.dirty = true;
    }

    @Override
    public void extendActionTimer(@NotNull ILastingAction<T> action, int duration) {
        int i = this.activeTimers.getOrDefault((Object)RegUtil.id(action), -1);
        if (i > 0) {
            this.activeTimers.put((Object)RegUtil.id(action), i + duration);
        }
    }

    @Override
    @NotNull
    public List<IAction<T>> getAvailableActions() {
        ArrayList<IAction<T>> actions = new ArrayList<IAction<T>>();
        for (IAction<T> action : this.unlockedActions) {
            if (action.canUse(this.player) != IAction.PERM.ALLOWED) continue;
            actions.add(action);
        }
        return actions;
    }

    @Override
    public float getPercentageForAction(@NotNull IAction<T> action) {
        ResourceLocation id = RegUtil.id(action);
        if (this.activeTimers.containsKey((Object)id)) {
            return (float)this.activeTimers.getInt((Object)id) / (float)this.expectedDurations.getInt((Object)id);
        }
        if (this.cooldownTimers.containsKey((Object)id)) {
            return (float)(-this.cooldownTimers.getInt((Object)id)) / (float)this.expectedCooldownTimes.getInt((Object)id);
        }
        return 0.0f;
    }

    @Override
    @NotNull
    public ImmutableList<IAction<T>> getUnlockedActions() {
        return ImmutableList.copyOf(this.unlockedActions);
    }

    @Override
    public boolean isActionActive(@NotNull ILastingAction<T> action) {
        return this.activeTimers.containsKey((Object)RegUtil.id(action));
    }

    @Override
    public boolean isActionActive(ResourceLocation id) {
        return this.activeTimers.containsKey((Object)id);
    }

    @Override
    public boolean isActionOnCooldown(IAction<T> action) {
        return this.cooldownTimers.containsKey((Object)RegUtil.id(action));
    }

    @Override
    public boolean isActionUnlocked(IAction<T> action) {
        return this.unlockedActions.contains(action);
    }

    public void loadFromNbt(@NotNull CompoundTag nbt) {
        this.activeTimers.clear();
        this.cooldownTimers.clear();
        this.expectedCooldownTimes.clear();
        this.expectedDurations.clear();
        if (nbt.m_128441_("actions_active")) {
            this.loadTimerMapFromNBT(nbt.m_128469_("actions_active"), this.activeTimers);
        }
        if (nbt.m_128441_("actions_cooldown")) {
            this.loadTimerMapFromNBT(nbt.m_128469_("actions_cooldown"), this.cooldownTimers);
        }
        if (nbt.m_128441_("actions_cooldown_expected")) {
            this.loadTimerMapFromNBT(nbt.m_128469_("actions_cooldown_expected"), this.expectedCooldownTimes);
        }
        if (nbt.m_128441_("actions_duration_expected")) {
            this.loadTimerMapFromNBT(nbt.m_128469_("actions_duration_expected"), this.expectedDurations);
        }
    }

    public void onActionsReactivated() {
        if (!this.player.isRemote()) {
            for (ResourceLocation id : this.activeTimers.keySet()) {
                ILastingAction action = (ILastingAction)RegUtil.getAction(id);
                assert (action != null);
                action.onReActivated(this.player);
            }
        }
    }

    public void readUpdateFromServer(@NotNull CompoundTag nbt) {
        if (nbt.m_128441_("actions_active")) {
            CompoundTag active = nbt.m_128469_("actions_active");
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Object2IntMap.Entry client_active : this.activeTimers.object2IntEntrySet()) {
                String key = ((ResourceLocation)client_active.getKey()).toString();
                if (active.m_128441_(key)) {
                    client_active.setValue(active.m_128451_(key));
                    nbt.m_128473_(key);
                    continue;
                }
                toRemove.add((ResourceLocation)client_active.getKey());
            }
            toRemove.forEach(id -> {
                ILastingAction action = (ILastingAction)RegUtil.getAction(id);
                this.deactivateAction(action);
            });
            for (String key : active.m_128431_()) {
                ResourceLocation id2 = new ResourceLocation(key);
                ILastingAction action = (ILastingAction)RegUtil.getAction(id2);
                if (action == null) {
                    LOGGER.error("Action {} is not available client side", (Object)key);
                    continue;
                }
                action.onActivatedClient(this.player);
                this.activeTimers.put((Object)id2, active.m_128451_(key));
            }
        }
        if (nbt.m_128441_("actions_cooldown")) {
            this.cooldownTimers.clear();
            this.loadTimerMapFromNBT(nbt.m_128469_("actions_cooldown"), this.cooldownTimers);
        }
        if (nbt.m_128441_("actions_cooldown_expected")) {
            this.expectedCooldownTimes.clear();
            this.loadTimerMapFromNBT(nbt.m_128469_("actions_cooldown_expected"), this.expectedCooldownTimes);
        }
        if (nbt.m_128441_("actions_duration_expected")) {
            this.expectedDurations.clear();
            this.loadTimerMapFromNBT(nbt.m_128469_("actions_duration_expected"), this.expectedDurations);
        }
    }

    @Override
    public void relockActions(@NotNull Collection<IAction<T>> actions) {
        this.unlockedActions.removeAll(actions);
        for (IAction<T> action : actions) {
            if (!(action instanceof ILastingAction)) continue;
            ILastingAction lastingAction = (ILastingAction)action;
            this.deactivateAction(lastingAction);
        }
    }

    @Override
    public void resetTimers() {
        for (ResourceLocation id : this.activeTimers.keySet()) {
            ILastingAction action = (ILastingAction)RegUtil.getAction(id);
            this.deactivateAction(action, true);
        }
        this.activeTimers.clear();
        this.cooldownTimers.clear();
        this.expectedCooldownTimes.clear();
        this.expectedDurations.clear();
        this.dirty = true;
    }

    @Override
    public void resetTimer(@NotNull IAction<T> action) {
        ResourceLocation id = RegUtil.id(action);
        if (action instanceof ILastingAction) {
            ILastingAction lastingAction = (ILastingAction)action;
            this.deactivateAction(lastingAction, true);
        }
        this.cooldownTimers.removeInt((Object)id);
        this.expectedCooldownTimes.removeInt((Object)id);
        this.dirty = true;
    }

    public void saveToNbt(@NotNull CompoundTag nbt) {
        nbt.m_128365_("actions_active", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.activeTimers.object2IntEntrySet()));
        nbt.m_128365_("actions_cooldown", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.cooldownTimers.object2IntEntrySet()));
        nbt.m_128365_("actions_cooldown_expected", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.expectedCooldownTimes.object2IntEntrySet()));
        nbt.m_128365_("actions_duration_expected", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.expectedDurations.object2IntEntrySet()));
    }

    @Override
    public IAction.PERM toggleAction(@NotNull IAction<T> action, IAction.ActivationContext context) {
        ResourceLocation id = RegUtil.id(action);
        if (this.activeTimers.containsKey((Object)id)) {
            this.deactivateAction((ILastingAction)action);
            this.dirty = true;
            return IAction.PERM.ALLOWED;
        }
        if (this.cooldownTimers.containsKey((Object)id)) {
            return IAction.PERM.COOLDOWN;
        }
        if (this.player.getRepresentingPlayer().m_5833_()) {
            return IAction.PERM.DISALLOWED;
        }
        if (!this.isActionUnlocked(action)) {
            return IAction.PERM.NOT_UNLOCKED;
        }
        if (!this.isActionAllowedPermission(action)) {
            return IAction.PERM.PERMISSION_DISALLOWED;
        }
        IAction.PERM r = action.canUse(this.player);
        if (r == IAction.PERM.ALLOWED) {
            int n;
            if (action instanceof ILastingAction) {
                ILastingAction lasting = (ILastingAction)action;
                n = lasting.getDuration(this.player);
            } else {
                n = -1;
            }
            int duration = n;
            ActionEvent.ActionActivatedEvent activationEvent = VampirismEventFactory.fireActionActivatedEvent(this.player, action, action.getCooldown(this.player), duration);
            if (activationEvent.isCanceled()) {
                return IAction.PERM.DISALLOWED;
            }
            if (action.onActivated(this.player, context)) {
                ModStats.updateActionUsed(this.player.getRepresentingPlayer(), action);
                int cooldown = activationEvent.getCooldown();
                this.expectedCooldownTimes.put((Object)id, cooldown);
                if (action instanceof ILastingAction) {
                    this.expectedDurations.put((Object)id, activationEvent.getDuration());
                    duration = activationEvent.getDuration();
                    this.activeTimers.put((Object)id, duration);
                } else {
                    this.cooldownTimers.put((Object)id, cooldown);
                }
                this.dirty = true;
            }
            return IAction.PERM.ALLOWED;
        }
        return r;
    }

    @Override
    public void deactivateAction(@NotNull ILastingAction<T> action) {
        this.deactivateAction(action, false);
    }

    public void deactivateAction(@NotNull ILastingAction<T> action, boolean ignoreCooldown) {
        this.deactivateAction(action, false, false);
    }

    public void deactivateAction(@NotNull ILastingAction<T> action, boolean ignoreCooldown, boolean fullCooldown) {
        ResourceLocation id = RegUtil.id(action);
        if (this.activeTimers.containsKey((Object)id)) {
            int cooldown = this.expectedCooldownTimes.getInt((Object)id);
            int leftTime = this.activeTimers.getInt((Object)id);
            int duration = this.expectedDurations.getInt((Object)id);
            cooldown = VampirismEventFactory.fireActionDeactivatedEvent(this.player, action, leftTime, cooldown);
            if (!ignoreCooldown && !this.cooldownTimers.containsKey((Object)id)) {
                if (!fullCooldown) {
                    cooldown -= (int)((float)cooldown * ((float)leftTime / (float)duration / 2.0f));
                } else {
                    this.expectedCooldownTimes.put((Object)id, cooldown);
                }
                this.cooldownTimers.put((Object)id, Math.max(cooldown, 1));
                this.activeTimers.put((Object)id, 1);
            }
            this.activeTimers.removeInt((Object)id);
            this.expectedDurations.removeInt((Object)id);
            action.onDeactivated(this.player);
            this.dirty = true;
        }
    }

    @Override
    public void unlockActions(@NotNull Collection<IAction<T>> actions) {
        for (IAction<T> action : actions) {
            if (RegUtil.has(action)) continue;
            throw new ActionNotRegisteredException(action);
        }
        this.unlockedActions.addAll(actions);
    }

    public boolean updateActions() {
        ObjectIterator it = this.cooldownTimers.object2IntEntrySet().iterator();
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            int value = entry.getIntValue();
            if (value <= 1) {
                this.expectedCooldownTimes.removeInt((Object)entry);
                it.remove();
                continue;
            }
            entry.setValue(value - 1);
        }
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
        for (Object2IntMap.Entry entry : this.activeTimers.object2IntEntrySet()) {
            int newtimer = entry.getIntValue() - 1;
            ResourceLocation id2 = (ResourceLocation)entry.getKey();
            if (newtimer == 0) {
                toRemove.add(id2);
                continue;
            }
            ILastingAction action = (ILastingAction)RegUtil.getAction(id2);
            ActionEvent.ActionUpdateEvent event = VampirismEventFactory.fireActionUpdateEvent(this.player, action, newtimer);
            boolean shouldDeactivate = event.shouldOverrideDeactivation();
            switch (event.getResult()) {
                case DEFAULT: {
                    shouldDeactivate = action.onUpdate(this.player);
                    break;
                }
                case ALLOW: {
                    action.onUpdate(this.player);
                }
            }
            if (shouldDeactivate) {
                entry.setValue(1);
                continue;
            }
            ModStats.updateActionTime(this.player.getRepresentingPlayer(), action);
            entry.setValue(newtimer);
        }
        toRemove.forEach(id -> {
            ILastingAction action = (ILastingAction)RegUtil.getAction(id);
            this.deactivateAction(action, true);
            this.cooldownTimers.put(id, this.expectedCooldownTimes.getInt(id));
            this.dirty = true;
        });
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    public void writeUpdateForClient(@NotNull CompoundTag nbt) {
        nbt.m_128365_("actions_active", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.activeTimers.object2IntEntrySet()));
        nbt.m_128365_("actions_cooldown", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.cooldownTimers.object2IntEntrySet()));
        nbt.m_128365_("actions_cooldown_expected", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.expectedCooldownTimes.object2IntEntrySet()));
        nbt.m_128365_("actions_duration_expected", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.expectedDurations.object2IntEntrySet()));
    }

    private boolean isActionAllowedPermission(IAction<T> action) {
        Player player = this.player.getRepresentingPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return Permissions.ACTION.isAllowed(serverPlayer, action);
        }
        return true;
    }

    private void loadTimerMapFromNBT(@NotNull CompoundTag nbt, @NotNull Object2IntMap<ResourceLocation> map) {
        for (String key : nbt.m_128431_()) {
            ResourceLocation id = new ResourceLocation(key);
            if (RegUtil.getAction(id) == null) {
                LOGGER.warn("Did not find action with key {}", (Object)key);
                continue;
            }
            map.put((Object)id, nbt.m_128451_(key));
        }
    }

    @NotNull
    private CompoundTag writeTimersToNBT(@NotNull ObjectSet<Object2IntMap.Entry<ResourceLocation>> set) {
        CompoundTag nbt = new CompoundTag();
        for (Object2IntMap.Entry entry : set) {
            nbt.m_128405_(((ResourceLocation)entry.getKey()).toString(), entry.getIntValue());
        }
        return nbt;
    }

    public static class ActionNotRegisteredException
    extends RuntimeException {
        public ActionNotRegisteredException(String name) {
            super("Action " + name + " is not registered. You cannot use it otherwise");
        }

        public ActionNotRegisteredException(@NotNull IAction<?> action) {
            this(action.toString());
        }
    }

    public static class ActivationContext
    implements IAction.ActivationContext {
        @Nullable
        private final Entity entity;
        @Nullable
        private final BlockPos blockPos;

        public ActivationContext(@Nullable Entity entity) {
            this.entity = entity;
            this.blockPos = null;
        }

        public ActivationContext(@Nullable BlockPos pos) {
            this.entity = null;
            this.blockPos = pos;
        }

        public ActivationContext() {
            this.entity = null;
            this.blockPos = null;
        }

        @Override
        @NotNull
        public Optional<BlockPos> targetBlock() {
            return Optional.ofNullable(this.blockPos);
        }

        @Override
        @NotNull
        public Optional<Entity> targetEntity() {
            return Optional.ofNullable(this.entity);
        }
    }
}

