/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.hunter.actions;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.DefaultHunterAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.hunter.actions.HunterActions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class AwarenessHunterAction
extends DefaultHunterAction
implements ILastingAction<IHunterPlayer> {
    private final TargetingConditions vampirePredicate = TargetingConditions.m_148353_().m_26888_(VampirismAPI.factionRegistry().getPredicate(VReference.HUNTER_FACTION, true, true, false, false, VReference.VAMPIRE_FACTION));

    @Override
    public boolean canBeUsedBy(@NotNull IHunterPlayer player) {
        return !player.getActionHandler().isActionActive((ILastingAction)HunterActions.DISGUISE_HUNTER.get());
    }

    @Override
    public int getCooldown(IHunterPlayer player) {
        return (Integer)VampirismConfig.BALANCE.haAwarenessCooldown.get();
    }

    @Override
    public int getDuration(IHunterPlayer player) {
        return (Integer)VampirismConfig.BALANCE.haAwarenessDuration.get();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.haAwarenessEnabled.get();
    }

    @Override
    public void onActivatedClient(@NotNull IHunterPlayer player) {
        this.onUpdate(player);
    }

    @Override
    public void onDeactivated(@NotNull IHunterPlayer player) {
        ((HunterPlayer)player).getSpecialAttributes().nearbyVampire(0.0);
    }

    @Override
    public void onReActivated(@NotNull IHunterPlayer player) {
        this.onUpdate(player);
    }

    @Override
    public boolean onUpdate(@NotNull IHunterPlayer player) {
        if (player.getRepresentingEntity().m_20193_().m_5776_() && player.getRepresentingEntity().f_19797_ % 8 == 0) {
            double dist = this.nearbyVampire(player);
            double p = 0.0;
            if (dist != Double.MAX_VALUE) {
                p = 1.0 - dist / (double)((Integer)VampirismConfig.BALANCE.haAwarenessRadius.get()).intValue();
            }
            ((HunterPlayer)player).getSpecialAttributes().nearbyVampire(p);
        }
        return false;
    }

    @Override
    protected boolean activate(IHunterPlayer player, IAction.ActivationContext context) {
        return true;
    }

    private double nearbyVampire(@NotNull IHunterPlayer player) {
        int r = (Integer)VampirismConfig.BALANCE.haAwarenessRadius.get();
        LivingEntity closestVampire = player.getRepresentingEntity().m_20193_().m_45963_(LivingEntity.class, this.vampirePredicate, null, player.getRepresentingEntity().m_20185_(), player.getRepresentingEntity().m_20186_(), player.getRepresentingEntity().m_20189_(), new AABB(player.getRepresentingEntity().m_20185_() - (double)r, player.getRepresentingEntity().m_20186_() - (double)r + 1.0, player.getRepresentingEntity().m_20189_() - (double)r, player.getRepresentingEntity().m_20185_() + (double)r, player.getRepresentingEntity().m_20186_() + (double)r + 1.0, player.getRepresentingEntity().m_20189_() + (double)r));
        if (closestVampire != null) {
            return closestVampire.m_20270_((Entity)player.getRepresentingEntity());
        }
        return Double.MAX_VALUE;
    }

    @Override
    public boolean showHudCooldown(Player player) {
        return true;
    }

    @Override
    public boolean showHudDuration(Player player) {
        return true;
    }
}

