/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks.req;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.core.ModTasks;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record ItemRequirement(@NotNull ResourceLocation id, @NotNull ItemStack stack, @NotNull Component description) implements TaskRequirement.Requirement<Item>
{
    public static final Codec<ItemRequirement> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.optionalFieldOf("id").forGetter(i -> Optional.of(i.id)), (App)ItemStack.f_41582_.fieldOf("item").forGetter(i -> i.stack), (App)ExtraCodecs.f_252442_.fieldOf("description").forGetter(i -> i.description)).apply((Applicative)inst, (id, item, desc) -> new ItemRequirement(id.orElseGet(() -> RegUtil.id(item.m_41720_())), (ItemStack)item, (Component)desc)));

    public ItemRequirement(ItemStack itemRequirement, Component description) {
        this(RegUtil.id(itemRequirement.m_41720_()), itemRequirement, description);
    }

    @Override
    public int getAmount(IFactionPlayer<?> player) {
        return this.stack.m_41613_();
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    @NotNull
    public Item getStat(IFactionPlayer<?> player) {
        return this.stack.m_41720_();
    }

    @Override
    @NotNull
    public TaskRequirement.Type getType() {
        return TaskRequirement.Type.ITEMS;
    }

    @Override
    public void removeRequirement(@NotNull IFactionPlayer<?> player) {
        player.getRepresentingPlayer().m_150109_().m_36022_(itemStack -> ItemStackUtil.areStacksEqualIgnoreAmount(itemStack, this.stack), this.getAmount(player), (Container)player.getRepresentingPlayer().f_36095_.m_39730_());
    }

    @Override
    public Codec<? extends TaskRequirement.Requirement<?>> codec() {
        return (Codec)ModTasks.ITEM_REQUIREMENT.get();
    }
}

