/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire.actions;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRefinements;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class RegenVampireAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    @Override
    public boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        this.applyEffect(vampire);
        return true;
    }

    @Override
    public int getCooldown(IVampirePlayer player) {
        return (Integer)VampirismConfig.BALANCE.vaRegenerationCooldown.get() * 20;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaRegenerationEnabled.get();
    }

    @Override
    public boolean showHudCooldown(Player player) {
        return true;
    }

    @Override
    public boolean showHudDuration(Player player) {
        return true;
    }

    @Override
    public int getDuration(IVampirePlayer player) {
        return (Integer)VampirismConfig.BALANCE.vaRegenerationDuration.get() * 20;
    }

    @Override
    public void onActivatedClient(IVampirePlayer player) {
    }

    @Override
    public void onDeactivated(IVampirePlayer player) {
        this.removePotionEffect(player, MobEffects.f_19605_);
    }

    @Override
    public void onReActivated(IVampirePlayer player) {
    }

    @Override
    public boolean onUpdate(IVampirePlayer vampire) {
        if (!vampire.isRemote() && vampire.getRepresentingPlayer().f_19797_ % 50 == 0) {
            this.applyEffect(vampire);
        }
        return false;
    }

    protected void applyEffect(IVampirePlayer vampire) {
        this.addEffectInstance(vampire, new MobEffectInstance(MobEffects.f_19605_, 52, vampire.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.REGENERATION.get()) ? 1 : 0, false, false));
    }
}

