/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.vampire.IBasicVampire;
import de.teamlapen.vampirism.api.event.BloodDrinkEvent;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.entity.IEntityFollower;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.ai.goals.AttackMeleeNoSunGoal;
import de.teamlapen.vampirism.entity.ai.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.BiteNearbyEntityVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.DefendLeaderGoal;
import de.teamlapen.vampirism.entity.ai.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.FollowAdvancedVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.ai.goals.MoveToBiteableVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.util.VampireVillage;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicVampireEntity
extends VampireBaseEntity
implements IBasicVampire,
IEntityActionUser,
IEntityFollower {
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(BasicVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(BasicVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int MAX_LEVEL = 2;
    private static final int ANGRY_TICKS_PER_ATTACK = 120;
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    @NotNull
    private final EntityActionTier entitytier;
    private int bloodtimer = 100;
    @Nullable
    private IEntityLeader advancedLeader = null;
    private int angryTimer = 0;
    private Goal tasks_avoidHunter;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private boolean attack;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampireBaseEntity.getAttributeBuilder().m_22268_(Attributes.f_22276_, 1.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder.m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, BalanceMobProps.mobProps.VAMPIRE_SPEED);
    }

    public BasicVampireEntity(EntityType<? extends BasicVampireEntity> type, Level world) {
        super(type, world, true);
        this.canSuckBloodFromPlayer = true;
        this.hasArms = true;
        this.setSpawnRestriction(VampireBaseEntity.SpawnRestriction.SPECIAL);
        this.entitytier = EntityActionTier.Medium;
        this.entityclass = EntityClassType.getRandomClass(this.m_217043_());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<BasicVampireEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("level", this.getEntityLevel());
        nbt.m_128405_("type", this.getEntityTextureType());
        nbt.m_128379_("attack", this.attack);
        nbt.m_128405_("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
    }

    @Override
    public void attackVillage(ICaptureAttributes totem) {
        this.f_21345_.m_25363_(this.tasks_avoidHunter);
        this.villageAttributes = totem;
        this.attack = true;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.bloodtimer > 0) {
            --this.bloodtimer;
        }
        if (this.angryTimer > 0) {
            --this.angryTimer;
        }
        if (this.f_19797_ % 9 == 3 && ((Boolean)VampirismConfig.BALANCE.vpFireResistanceReplace.get()).booleanValue() && this.m_21023_(MobEffects.f_19607_)) {
            MobEffectInstance fireResistance = this.m_6234_(MobEffects.f_19607_);
            assert (fireResistance != null);
            this.m_7285_(fireResistance);
            this.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FIRE_PROTECTION.get(), fireResistance.m_19557_(), fireResistance.m_19564_()));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    @Override
    public void defendVillage(ICaptureAttributes totem) {
        this.f_21345_.m_25363_(this.tasks_avoidHunter);
        this.villageAttributes = totem;
        this.attack = false;
    }

    public void convertToMinion(@NotNull Player lord) {
        FactionPlayerHandler.getOpt(lord).ifPresent(fph -> {
            if (fph.getMaxMinions() > 0) {
                MinionWorldData.getData(lord.m_9236_()).map(w -> w.getOrCreateController((FactionPlayerHandler)fph)).ifPresent(controller -> {
                    if (controller.hasFreeMinionSlot()) {
                        if (fph.getCurrentFaction() == this.getFaction()) {
                            boolean hasIncreasedStats = fph.getCurrentFactionPlayer().map(IFactionPlayer::getSkillHandler).map(skillHandler -> skillHandler.isSkillEnabled((ISkill)VampireSkills.MINION_STATS_INCREASE.get())).orElse(false);
                            VampireMinionEntity.VampireMinionData data = new VampireMinionEntity.VampireMinionData("Minion", this.getEntityTextureType(), false, hasIncreasedStats);
                            data.updateEntityCaps(this.serializeCaps());
                            int id = controller.createNewMinionSlot(data, (EntityType)ModEntities.VAMPIRE_MINION.get());
                            if (id < 0) {
                                LOGGER.error("Failed to get minion slot");
                                return;
                            }
                            VampireMinionEntity minion = (VampireMinionEntity)((EntityType)ModEntities.VAMPIRE_MINION.get()).m_20615_(this.m_9236_());
                            minion.claimMinionSlot(id, (PlayerMinionController)controller);
                            minion.m_20359_((Entity)this);
                            minion.markAsConverted();
                            controller.activateTask(0, (IMinionTask)MinionTasks.STAY.get());
                            UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)minion);
                        } else {
                            LOGGER.warn("Wrong faction for minion");
                        }
                    } else {
                        LOGGER.warn("No free slot");
                    }
                });
            } else {
                LOGGER.error("Can't have minions");
            }
        });
    }

    @Override
    public ActionHandlerEntity<?> getActionHandler() {
        return this.entityActionHandler;
    }

    @Nullable
    public IEntityLeader getAdvancedLeader() {
        return this.advancedLeader;
    }

    public void setAdvancedLeader(@Nullable IEntityLeader advancedLeader) {
        this.advancedLeader = advancedLeader;
    }

    @Override
    public boolean isFollowing() {
        return this.advancedLeader != null;
    }

    @Override
    public <T extends LivingEntity> T getLeader() {
        return (T)((LivingEntity)this.advancedLeader);
    }

    @Override
    public <T extends LivingEntity> void setLeader(T leader) {
        this.advancedLeader = (IEntityLeader)leader;
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public void m_6667_(@NotNull DamageSource cause) {
        if (this.villageAttributes == null) {
            BadOmenEffect.handlePotentialBannerKill(cause.m_7639_(), this);
        }
        super.m_6667_(cause);
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining, IDrinkBloodContext drinkContext) {
        @NotNull BloodDrinkEvent.EntityDrinkBloodEvent event = VampirismEventFactory.fireVampireDrinkBlood(this, amt, saturationMod, useRemaining, drinkContext);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, event.getAmount() * 20));
        boolean dedicated = ServerLifecycleHooks.getCurrentServer().m_6982_();
        this.bloodtimer += event.getAmount() * 40 + this.m_217043_().m_188503_(1000) * (dedicated ? 2 : 1);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if ((reason == MobSpawnType.NATURAL || reason == MobSpawnType.STRUCTURE) && this.m_217043_().m_188503_(50) == 0) {
            this.m_8061_(EquipmentSlot.HEAD, VampireVillage.createBanner());
        }
        this.m_20088_().m_135381_(TYPE, (Object)this.m_217043_().m_188503_(126));
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public int getMaxEntityLevel() {
        return 2;
    }

    public int m_8100_() {
        return 2400;
    }

    @Override
    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public boolean isIgnoringSundamage() {
        float health = this.m_21223_() / this.m_21233_();
        return super.isIgnoringSundamage() || this.angryTimer > 0 && health < 0.7f || health < 0.3f;
    }

    @Override
    public int getEntityTextureType() {
        int i = (Integer)this.m_20088_().m_135370_(TYPE);
        return Math.max(i, 0);
    }

    @Override
    public int getEntityLevel() {
        return (Integer)this.m_20088_().m_135370_(LEVEL);
    }

    @Override
    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.m_20088_().m_135381_(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 2) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1000000, 1, false, false));
            }
            if (level == 1) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource damageSource, float amount) {
        boolean flag = super.m_6469_(damageSource, amount);
        if (flag) {
            this.angryTimer += 120;
        }
        return flag;
    }

    public void m_142687_(@NotNull Entity.RemovalReason p_146834_) {
        super.m_142687_(p_146834_);
        if (this.advancedLeader != null) {
            this.advancedLeader.decreaseFollowerCount();
        }
    }

    @Override
    public void stopVillageAttackDefense() {
        this.m_6593_(null);
        this.villageAttributes = null;
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tagCompund) {
        super.m_7378_(tagCompund);
        if (tagCompund.m_128441_("level")) {
            this.setEntityLevel(tagCompund.m_128451_("level"));
        }
        if (tagCompund.m_128441_("attack")) {
            this.attack = tagCompund.m_128471_("attack");
        }
        if (tagCompund.m_128441_("type")) {
            int t = tagCompund.m_128451_("type");
            this.m_20088_().m_135381_(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.advancedLeader != null && !this.advancedLeader.getRepresentingEntity().m_6084_()) {
            this.advancedLeader = null;
        }
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodtimer == 0;
    }

    @Override
    public int suggestEntityLevel(@NotNull de.teamlapen.vampirism.api.difficulty.Difficulty d) {
        return switch (this.f_19796_.m_188503_(5)) {
            case 0 -> (int)((float)d.minPercLevel / 100.0f * 2.0f);
            case 1 -> (int)((float)d.avgPercLevel / 100.0f * 2.0f);
            case 2 -> (int)((float)d.maxPercLevel / 100.0f * 2.0f);
            default -> this.f_19796_.m_188503_(3);
        };
    }

    @Override
    protected float calculateFireDamage(float amount) {
        float protectionMod = 1.0f;
        MobEffectInstance protection = this.m_21124_((MobEffect)ModEffects.FIRE_PROTECTION.get());
        if (protection != null) {
            protectionMod = 1.0f / (2.0f + (float)protection.m_19564_());
        }
        return (float)((double)(amount * protectionMod) * BalanceMobProps.mobProps.VAMPIRE_FIRE_VULNERABILITY) * ((float)this.getEntityLevel() * 0.5f + 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(LEVEL, (Object)-1);
        this.m_20088_().m_135372_(TYPE, (Object)-1);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ENTITY_VAMPIRE_SCREAM.get();
    }

    public int m_213860_() {
        return 6 + this.getEntityLevel();
    }

    @Override
    @NotNull
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? (EntityType)ModEntities.VAMPIRE_IMOB.get() : (EntityType)ModEntities.VAMPIRE.get();
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.m_6084_() && !player.m_6144_()) {
            int vampireLevel;
            if (!this.m_9236_().f_46443_ && (vampireLevel = FactionPlayerHandler.getOpt(player).map(fph -> fph.getCurrentLevel(VReference.VAMPIRE_FACTION)).orElse(0).intValue()) > 0) {
                return FactionPlayerHandler.getOpt(player).map(fph -> {
                    if (fph.getMaxMinions() > 0) {
                        ItemStack heldItem = player.m_21120_(hand);
                        boolean freeSlot = MinionWorldData.getData(player.m_9236_()).map(data -> data.getOrCreateController((FactionPlayerHandler)fph)).map(c -> c.hasFreeMinionSlot()).orElse(false);
                        player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.basic_vampire.minion.available"), true);
                        if (heldItem.m_41720_() == ModItems.VAMPIRE_MINION_BINDING.get()) {
                            if (!freeSlot) {
                                player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.basic_vampire.minion.no_free_slot"), true);
                            } else {
                                String key = switch (this.m_217043_().m_188503_(3)) {
                                    case 0 -> "text.vampirism.basic_vampire.minion.start_serving1";
                                    case 1 -> "text.vampirism.basic_vampire.minion.start_serving2";
                                    default -> "text.vampirism.basic_vampire.minion.start_serving3";
                                };
                                player.m_5661_((Component)Component.m_237115_((String)key), false);
                                this.convertToMinion(player);
                                if (!player.m_150110_().f_35937_) {
                                    heldItem.m_41774_(1);
                                }
                            }
                        } else if (freeSlot) {
                            player.m_5661_((Component)Component.m_237110_((String)"text.vampirism.basic_vampire.minion.require_binding", (Object[])new Object[]{UtilLib.translate(((Item)ModItems.VAMPIRE_MINION_BINDING.get()).m_5524_(), new Object[0])}), true);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }).orElse(InteractionResult.PASS);
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new BreakDoorGoal((Mob)this, difficulty -> difficulty == Difficulty.HARD));
        this.tasks_avoidHunter = new AvoidEntityGoal((PathfinderMob)this, PathfinderMob.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION));
        this.f_21345_.m_25352_(2, this.tasks_avoidHunter);
        this.f_21345_.m_25352_(2, new RestrictSunVampireGoal<BasicVampireEntity>(this));
        this.f_21345_.m_25352_(3, new FleeSunVampireGoal<BasicVampireEntity>(this, 0.9, false));
        this.f_21345_.m_25352_(4, (Goal)new AttackMeleeNoSunGoal(this, 1.0, false));
        this.f_21345_.m_25352_(5, new BiteNearbyEntityVampireGoal<BasicVampireEntity>(this));
        this.f_21345_.m_25352_(6, (Goal)new FollowAdvancedVampireGoal(this, 1.0));
        this.f_21345_.m_25352_(7, new MoveToBiteableVampireGoal<BasicVampireEntity>(this, 0.75));
        this.f_21345_.m_25352_(8, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.6, true, 600, () -> false));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(10, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 20.0f, 0.6f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, HunterBaseEntity.class, 17.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, new AttackVillageGoal<BasicVampireEntity>(this));
        this.f_21346_.m_25352_(4, new DefendVillageGoal<BasicVampireEntity>(this));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, PatrollingMonster.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, (TagKey<Structure>)StructureTags.f_215889_)));
        this.f_21346_.m_25352_(8, new DefendLeaderGoal<BasicVampireEntity>(this));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getEntityLevel(), 0);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22276_);
        double d = BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION;
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.m_22100_(d + 3.0 * (double)l);
        AttributeInstance attributeInstance2 = this.m_21051_(Attributes.f_22281_);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance2.m_22100_(3.0 + 1.0 * (double)l);
    }

    public static class IMob
    extends BasicVampireEntity
    implements Enemy {
        public IMob(EntityType<? extends BasicVampireEntity> type, Level world) {
            super(type, world);
        }
    }
}

