/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.page.PageItemStack;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.player.tasks.reward.ItemReward;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class PageTaskItemStack
extends PageItemStack {
    private boolean setup = false;
    @NotNull
    private final ResourceKey<Task> taskKey;

    public PageTaskItemStack(@NotNull ResourceKey<Task> task) {
        super((FormattedText)Component.m_237119_(), ItemStack.f_41583_);
        this.taskKey = task;
    }

    private void setupTask(RegistryAccess access) {
        access.m_6632_(VampirismRegistries.TASK_ID).flatMap(registry -> registry.m_203636_(this.taskKey)).ifPresent(holder -> {
            Task task = (Task)holder.get();
            this.ingredient = Ingredient.m_43921_(((ItemReward)task.getReward()).getAllPossibleRewards().stream());
            ArrayList<Object> text = new ArrayList<Object>();
            MutableComponent newLine = Component.m_237113_((String)"\n");
            if (holder.m_203656_(ModTags.Tasks.HAS_FACTION)) {
                text.add(Component.m_237110_((String)"text.vampirism.task.reward_obtain_for", (Object[])new Object[]{String.join((CharSequence)", ", Arrays.stream(VampirismAPI.factionRegistry().getFactions()).filter(x -> x.getTag(VampirismRegistries.TASK_ID).filter(arg_0 -> ((Holder.Reference)holder).m_203656_(arg_0)).isPresent()).map(IFaction::getNamePlural).map(Component::getString).toList()) + " "}));
            } else {
                text.add(Component.m_237115_((String)"text.vampirism.task.reward_obtain_all"));
            }
            text.add(newLine);
            text.add(newLine);
            text.add(task.getTitle());
            text.add(newLine);
            text.add(Component.m_237115_((String)"text.vampirism.task.prerequisites"));
            text.add(newLine);
            TaskUnlocker[] unlockers = task.getUnlocker();
            if (unlockers.length > 0) {
                for (TaskUnlocker u : unlockers) {
                    text.add(Component.m_237113_((String)"- ").m_7220_(u.getDescription()).m_7220_((Component)newLine));
                }
            } else {
                text.add(Component.m_237115_((String)"text.vampirism.task.prerequisites.none"));
            }
            this.draw = FormattedText.m_130768_(text);
            this.setup = true;
        });
    }

    public void draw(GuiGraphics guiGraphics, RegistryAccess registryAccess, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        if (!this.setup) {
            this.setupTask(registryAccess);
        }
        super.draw(guiGraphics, registryAccess, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof PageTaskItemStack)) return false;
        PageTaskItemStack other = (PageTaskItemStack)((Object)o);
        if (!Objects.equals(other.taskKey, this.taskKey)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.taskKey.hashCode();
    }
}

