/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public record ServerboundSelectMinionTaskPacket(int minionID, ResourceLocation taskID) implements IMessage.IServerBoundMessage
{
    public static final ResourceLocation RECALL = new ResourceLocation("vampirism", "recall");
    public static final ResourceLocation RESPAWN = new ResourceLocation("vampirism", "respawn");
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundSelectMinionTaskPacket {
        assert (minionID >= -1);
    }

    public static void handle(@NotNull ServerboundSelectMinionTaskPacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        if (ctx.getSender() != null) {
            ctx.enqueueWork(() -> FactionPlayerHandler.getOpt((Player)ctx.getSender()).ifPresent(fp -> {
                PlayerMinionController controller = MinionWorldData.getData(ctx.getSender().f_8924_).getOrCreateController((FactionPlayerHandler)fp);
                if (RECALL.equals((Object)msg.taskID)) {
                    if (msg.minionID < 0) {
                        Collection<Integer> ids = controller.recallMinions(false);
                        for (Integer id : ids) {
                            controller.createMinionEntityAtPlayer(id, (Player)ctx.getSender());
                        }
                        ServerboundSelectMinionTaskPacket.printRecoveringMinions(ctx.getSender(), controller.getRecoveringMinionNames());
                    } else if (controller.recallMinion(msg.minionID)) {
                        controller.createMinionEntityAtPlayer(msg.minionID, (Player)ctx.getSender());
                    } else {
                        ctx.getSender().m_5661_((Component)Component.m_237110_((String)"text.vampirism.minion_is_still_recovering", (Object[])new Object[]{controller.contactMinionData(msg.minionID, MinionData::getFormattedName).orElseGet(() -> Component.m_237113_((String)"1"))}), true);
                    }
                } else if (RESPAWN.equals((Object)msg.taskID)) {
                    Collection<Integer> ids = controller.getUnclaimedMinions();
                    for (Integer id : ids) {
                        controller.createMinionEntityAtPlayer(id, (Player)ctx.getSender());
                    }
                    ServerboundSelectMinionTaskPacket.printRecoveringMinions(ctx.getSender(), controller.getRecoveringMinionNames());
                } else {
                    IMinionTask<?, ?> task = RegUtil.getMinionTask(msg.taskID);
                    if (task == null) {
                        LOGGER.error("Cannot find action to activate {}", (Object)msg.taskID);
                    } else if (msg.minionID < -1) {
                        LOGGER.error("Illegal minion id {}", (Object)msg.minionID);
                    } else {
                        controller.activateTask(msg.minionID, task);
                    }
                }
            }));
        }
        ctx.setPacketHandled(true);
    }

    public static void printRecoveringMinions(@NotNull ServerPlayer player, @NotNull List<MutableComponent> recoveringMinions) {
        if (recoveringMinions.size() == 1) {
            player.m_5661_((Component)Component.m_237110_((String)"text.vampirism.minion_is_still_recovering", (Object[])new Object[]{recoveringMinions.get(0)}), true);
        } else if (recoveringMinions.size() > 1) {
            player.m_5661_((Component)Component.m_237110_((String)"text.vampirism.n_minions_are_still_recovering", (Object[])new Object[]{recoveringMinions.size()}), true);
        }
    }

    static void encode(@NotNull ServerboundSelectMinionTaskPacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130130_(msg.minionID);
        buf.m_130085_(msg.taskID);
    }

    @NotNull
    static ServerboundSelectMinionTaskPacket decode(@NotNull FriendlyByteBuf buf) {
        return new ServerboundSelectMinionTaskPacket(buf.m_130242_(), buf.m_130281_());
    }
}

