/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VampirismRecipeHelper {
    VampirismRecipeHelper() {
    }

    @NotNull
    static @NotNull ISkill<?> @NotNull [] deserializeSkills(@Nullable JsonArray jsonObject) {
        if (jsonObject == null || jsonObject.size() == 0) {
            return new ISkill[0];
        }
        ISkill[] skills = new ISkill[jsonObject.size()];
        for (int i = 0; i < skills.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)jsonObject.get(i), (String)("skill[" + i + "]"));
            ISkill<?> skill = RegUtil.getSkill(new ResourceLocation(s));
            if (skill == null) {
                throw new JsonSyntaxException("Unknown skill '" + s + "'");
            }
            skills[i] = skill;
        }
        return skills;
    }

    static String @NotNull [] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, VampirismRecipeHelper.firstNonSpace(s));
            int j1 = VampirismRecipeHelper.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(@NotNull String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(@NotNull String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    @NotNull
    static NonNullList<Ingredient> readIngredients(@NotNull JsonArray ingredientArray) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < ingredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
            if (ingredient.m_43947_()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    @NotNull
    static FluidStack deserializeFluid(@NotNull JsonObject object) {
        String s = GsonHelper.m_13906_((JsonObject)object, (String)"fluid");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(s));
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid '" + s + "'");
        }
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = GsonHelper.m_13824_((JsonObject)object, (String)"amount", (int)1);
        return new FluidStack(fluid, i);
    }

    @NotNull
    static Map<String, Ingredient> deserializeKey(@NotNull JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    @NotNull
    static NonNullList<Ingredient> deserializeIngredients(String @NotNull [] pattern, @NotNull Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(patternWidth * patternHeight), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    static String @NotNull [] patternFromJson(@NotNull JsonArray jsonArr, int max) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > max) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + max + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > max) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + max + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    @NotNull
    static Either<Ingredient, FluidStack> getFluidOrItem(@NotNull JsonObject json) {
        if (json.has("fluidItem")) {
            return Either.left((Object)Ingredient.m_43917_((JsonElement)json.get("fluidItem")));
        }
        return Either.right((Object)VampirismRecipeHelper.deserializeFluid(json.getAsJsonObject("fluid")));
    }
}

