/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.blocks.CursedEarthBlock;
import de.teamlapen.vampirism.blocks.DarkSpruceLeavesBlock;
import de.teamlapen.vampirism.blocks.DarkStoneBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.world.gen.feature.VampireDungeonFeature;
import de.teamlapen.vampirism.world.gen.feature.treedecorators.TrunkCursedVineDecorator;
import de.teamlapen.vampirism.world.gen.modifier.ExtendedAddSpawnsBiomeModifier;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.ThreeLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.SpruceFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class VampirismFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> VAMPIRE_FLOWER = VampirismFeatures.createConfiguredKey("vampire_flower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CURSED_ROOT = VampirismFeatures.createConfiguredKey("cursed_root");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DARK_SPRUCE_TREE = VampirismFeatures.createConfiguredKey("dark_spruce_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CURSED_SPRUCE_TREE = VampirismFeatures.createConfiguredKey("cursed_tree_red");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VAMPIRE_DUNGEON = VampirismFeatures.createConfiguredKey("vampire_dungeon");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WATER_LAKE = VampirismFeatures.createConfiguredKey("mod_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VAMPIRE_TREES = VampirismFeatures.createConfiguredKey("vampire_trees_placed");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_DARK_STONE = VampirismFeatures.createConfiguredKey("ore_dark_stone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_CURSED_DIRT = VampirismFeatures.createConfiguredKey("ore_cursed_dirt");
    public static final ResourceKey<PlacedFeature> VAMPIRE_FLOWER_PLACED = VampirismFeatures.createPlacedKey("vampire_flower");
    public static final ResourceKey<PlacedFeature> CURSED_ROOT_PLACED = VampirismFeatures.createPlacedKey("cursed_root");
    public static final ResourceKey<PlacedFeature> DARK_SPRUCE_TREE_PLACED = VampirismFeatures.createPlacedKey("dark_spruce_tree");
    public static final ResourceKey<PlacedFeature> CURSED_SPRUCE_TREE_PLACED = VampirismFeatures.createPlacedKey("cursed_spruce_tree_placed");
    public static final ResourceKey<PlacedFeature> VAMPIRE_DUNGEON_PLACED = VampirismFeatures.createPlacedKey("vampire_dungeon");
    public static final ResourceKey<PlacedFeature> WATER_LAKE_PLACED = VampirismFeatures.createPlacedKey("mod_lake_placed");
    public static final ResourceKey<PlacedFeature> VAMPIRE_TREES_PLACED = VampirismFeatures.createPlacedKey("vampire_trees");
    public static final ResourceKey<PlacedFeature> FOREST_GRASS_PLACED = VampirismFeatures.createPlacedKey("forest_grass");
    public static final ResourceKey<PlacedFeature> ORE_DARK_STONE_PLACED = VampirismFeatures.createPlacedKey("ore_dark_stone_lower");
    public static final ResourceKey<PlacedFeature> ORE_CURSED_DIRT_PLACED = VampirismFeatures.createPlacedKey("ore_cursed_dirt");
    public static final ResourceKey<BiomeModifier> VAMPIRE_SPAWN = VampirismFeatures.createModifierKey("spawn/vampire_spawns");
    public static final ResourceKey<BiomeModifier> HUNTER_SPAWN = VampirismFeatures.createModifierKey("spawn/hunter_spawns");
    public static final ResourceKey<BiomeModifier> ADVANCED_VAMPIRE_SPAWN = VampirismFeatures.createModifierKey("spawn/advanced_vampire_spawns");
    public static final ResourceKey<BiomeModifier> ADVANCED_HUNTER_SPAWN = VampirismFeatures.createModifierKey("spawn/advanced_hunter_spawns");
    public static final ResourceKey<BiomeModifier> VAMPIRE_DUNGEON_MODIFIER = VampirismFeatures.createModifierKey("feature/vampire_dungeon");

    private static ResourceKey<ConfiguredFeature<?, ?>> createConfiguredKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("vampirism", name));
    }

    private static ResourceKey<PlacedFeature> createPlacedKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("vampirism", name));
    }

    private static ResourceKey<BiomeModifier> createModifierKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("vampirism", name));
    }

    public static void createConfiguredFeatures(BootstapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        context.m_255272_(VAMPIRE_FLOWER, (Object)new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)FeatureUtils.m_206470_((int)32, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.VAMPIRE_ORCHID.get())))))));
        context.m_255272_(CURSED_ROOT, (Object)new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206470_((int)16, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.CURSED_ROOTS.get())))))));
        context.m_255272_(DARK_SPRUCE_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.DARK_SPRUCE_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(11, 2, 2), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((DarkSpruceLeavesBlock)((Object)ModBlocks.DARK_SPRUCE_LEAVES.get())).m_49966_()), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)UniformInt.m_146622_((int)2, (int)3), (IntProvider)UniformInt.m_146622_((int)0, (int)2), (IntProvider)UniformInt.m_146622_((int)3, (int)7)), (FeatureSize)new ThreeLayersFeatureSize(5, 8, 0, 3, 3, OptionalInt.of(5))).m_68244_().m_68251_()));
        context.m_255272_(CURSED_SPRUCE_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.CURSED_SPRUCE_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(11, 2, 2), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((DarkSpruceLeavesBlock)((Object)ModBlocks.DARK_SPRUCE_LEAVES.get())).m_49966_()), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)UniformInt.m_146622_((int)2, (int)3), (IntProvider)UniformInt.m_146622_((int)0, (int)2), (IntProvider)UniformInt.m_146622_((int)3, (int)7)), (FeatureSize)new ThreeLayersFeatureSize(5, 8, 0, 3, 3, OptionalInt.of(5))).m_68249_((List)ImmutableList.of((Object)((Object)TrunkCursedVineDecorator.INSTANCE))).m_68244_().m_68251_()));
        context.m_255272_(VAMPIRE_DUNGEON, (Object)new ConfiguredFeature((Feature)((VampireDungeonFeature)((Object)ModFeatures.VAMPIRE_DUNGEON.get())), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        context.m_255272_(WATER_LAKE, (Object)new ConfiguredFeature(Feature.f_65783_, (FeatureConfiguration)new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49990_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.DARK_STONE.get())))));
        context.m_255272_(VAMPIRE_TREES, (Object)new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeatures.m_255043_(CURSED_SPRUCE_TREE_PLACED), 0.3f)), (Holder)placedFeatures.m_255043_(DARK_SPRUCE_TREE_PLACED))));
        context.m_255272_(ORE_DARK_STONE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_13061_), ((DarkStoneBlock)((Object)ModBlocks.DARK_STONE.get())).m_49966_(), 64)));
        context.m_255272_(ORE_CURSED_DIRT, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_13061_), ((CursedEarthBlock)ModBlocks.CURSED_EARTH.get()).m_49966_(), 33)));
    }

    public static void createPlacedFeatures(BootstapContext<PlacedFeature> context) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256911_);
        context.m_255272_(VAMPIRE_FLOWER_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(VAMPIRE_FLOWER), List.of(RarityFilter.m_191900_((int)4), PlacementUtils.f_195354_, InSquarePlacement.m_191715_(), BiomeFilter.m_191561_())));
        context.m_255272_(CURSED_ROOT_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(CURSED_ROOT), List.of(RarityFilter.m_191900_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(DARK_SPRUCE_TREE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(DARK_SPRUCE_TREE), List.of(PlacementUtils.m_206493_((Block)((Block)ModBlocks.DARK_SPRUCE_SAPLING.get())))));
        context.m_255272_(CURSED_SPRUCE_TREE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(CURSED_SPRUCE_TREE), List.of(PlacementUtils.m_206493_((Block)((Block)ModBlocks.CURSED_SPRUCE_SAPLING.get())))));
        context.m_255272_(VAMPIRE_DUNGEON_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(VAMPIRE_DUNGEON), List.of(CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158929_()), BiomeFilter.m_191561_())));
        context.m_255272_(WATER_LAKE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(WATER_LAKE), List.of(RarityFilter.m_191900_((int)200), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(VAMPIRE_TREES_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(VAMPIRE_TREES), VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)10, (float)0.1f, (int)1))));
        context.m_255272_(FOREST_GRASS_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(VegetationFeatures.f_195182_), VegetationPlacements.m_195474_((int)2)));
        context.m_255272_(ORE_DARK_STONE_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(ORE_DARK_STONE), OrePlacements.m_195343_((int)30, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158929_()))));
        context.m_255272_(ORE_CURSED_DIRT_PLACED, (Object)new PlacedFeature((Holder)placedFeatures.m_255043_(ORE_CURSED_DIRT), OrePlacements.m_195343_((int)7, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)160)))));
    }

    public static void createBiomeModifier(BootstapContext<BiomeModifier> context) {
        HolderGetter biomeLookup = context.m_255420_(Registries.f_256952_);
        HolderGetter placedFeatureLookup = context.m_255420_(Registries.f_256988_);
        context.m_255272_(VAMPIRE_SPAWN, (Object)ExtendedAddSpawnsBiomeModifier.singleSpawn((HolderSet<Biome>)biomeLookup.m_254956_(ModTags.Biomes.HasSpawn.VAMPIRE), (HolderSet<Biome>)biomeLookup.m_254956_(ModTags.Biomes.NoSpawn.VAMPIRE), new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData((EntityType)ModEntities.VAMPIRE.get(), 80, 1, 3, MobCategory.MONSTER)));
        context.m_255272_(ADVANCED_VAMPIRE_SPAWN, (Object)ExtendedAddSpawnsBiomeModifier.singleSpawn((HolderSet<Biome>)biomeLookup.m_254956_(ModTags.Biomes.HasSpawn.ADVANCED_VAMPIRE), (HolderSet<Biome>)biomeLookup.m_254956_(ModTags.Biomes.NoSpawn.ADVANCED_VAMPIRE), new ExtendedAddSpawnsBiomeModifier.ExtendedSpawnData((EntityType)ModEntities.ADVANCED_VAMPIRE.get(), 30, 1, 3, MobCategory.MONSTER)));
        context.m_255272_(VAMPIRE_DUNGEON_MODIFIER, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeLookup.m_254956_(ModTags.Biomes.HasStructure.VAMPIRE_DUNGEON), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatureLookup.m_255043_(VAMPIRE_DUNGEON_PLACED)}), GenerationStep.Decoration.UNDERGROUND_STRUCTURES));
    }
}

