/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.core.ModLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public class FactionCondition
implements LootItemCondition {
    @NotNull
    private final Type type;
    private final IFaction<?> faction;
    private final int minLevel;
    private final int maxLevel;

    public FactionCondition(IFaction<?> faction, int minLevel, int maxLevel) {
        this.type = Type.FACTION;
        this.faction = faction;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public FactionCondition(int minLevel, int maxLevel) {
        this.type = Type.ANY_FACTION;
        this.faction = null;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public FactionCondition() {
        this.type = Type.ANY_FACTION;
        this.faction = null;
        this.minLevel = 0;
        this.maxLevel = -1;
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ModLoot.FACTION.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.m_78953_(LootContextParams.f_81455_);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            switch (this.type) {
                case FACTION: {
                    if (this.faction == null) {
                        return false;
                    }
                    return VampirismAPI.getFactionPlayerHandler(player).filter(a -> a.isInFaction(this.faction)).filter(a -> a.getCurrentLevel() >= this.minLevel && (this.maxLevel == -1 || a.getCurrentLevel() <= this.maxLevel)).isPresent();
                }
                case NO_FACTION: {
                    return VampirismAPI.getFactionPlayerHandler(player).filter(p -> p.getCurrentFactionPlayer().isEmpty()).isPresent();
                }
                case ANY_FACTION: {
                    return VampirismAPI.getFactionPlayerHandler(player).filter(a -> a.getCurrentLevel() >= this.minLevel && (this.maxLevel == -1 || a.getCurrentLevel() <= this.maxLevel)).isPresent();
                }
            }
        }
        return false;
    }

    public static enum Type {
        NO_FACTION,
        ANY_FACTION,
        FACTION;

    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<FactionCondition> {
        public void serialize(@NotNull JsonObject json, @NotNull FactionCondition condition, @NotNull JsonSerializationContext context) {
            json.addProperty("type", condition.type.name());
            switch (condition.type) {
                case FACTION: {
                    json.addProperty("faction", condition.faction.getID().toString());
                }
                case ANY_FACTION: {
                    json.addProperty("min_level", (Number)condition.minLevel);
                    if (condition.maxLevel == -1) break;
                    json.addProperty("max_level", (Number)condition.maxLevel);
                }
            }
        }

        @NotNull
        public FactionCondition deserialize(@NotNull JsonObject jsonObject, @NotNull JsonDeserializationContext context) {
            JsonObject json = jsonObject.get("predicate").getAsJsonObject();
            Type type = Type.valueOf(json.get("type").getAsString());
            switch (type) {
                case NO_FACTION: {
                    return new FactionCondition();
                }
                case ANY_FACTION: {
                    int minLevel = json.has("min_level") ? json.get("min_level").getAsInt() : 0;
                    int maxLevel = json.has("max_level") ? json.get("max_level").getAsInt() : -1;
                    return new FactionCondition(minLevel, maxLevel);
                }
                case FACTION: {
                    ResourceLocation factionId = new ResourceLocation(json.get("faction").getAsString());
                    IFaction<?> faction = VampirismAPI.factionRegistry().getFactionByID(factionId);
                    int minLevel = json.has("min_level") ? json.get("min_level").getAsInt() : 0;
                    int maxLevel = json.has("max_level") ? json.get("max_level").getAsInt() : -1;
                    return new FactionCondition(faction, minLevel, maxLevel);
                }
            }
            return null;
        }
    }
}

