/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.ClientboundBloodValuePacket;
import de.teamlapen.vampirism.network.ClientboundSkillTreePacket;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.lang.reflect.Array;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GeneralEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public void onAttachCapabilityWorld(@NotNull AttachCapabilitiesEvent<Level> event) {
        event.addCapability(REFERENCE.WORLD_CAP_KEY, VampirismWorld.createNewCapability((Level)event.getObject()));
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerLoggedInEvent event) {
        boolean isAdminLikePlayer;
        VersionChecker.VersionInfo versionInfo = VampirismMod.instance.getVersionInfo();
        if (!versionInfo.isChecked()) {
            LOGGER.warn("Version check is not finished yet");
        }
        Player player = event.getEntity();
        boolean bl = isAdminLikePlayer = !ServerLifecycleHooks.getCurrentServer().m_6982_() || UtilLib.isPlayerOp(player);
        if (((Boolean)VampirismConfig.COMMON.versionCheck.get()).booleanValue() && versionInfo.isNewVersionAvailable() && (isAdminLikePlayer || player.m_217043_().m_188503_(5) == 0) && player.m_217043_().m_188503_(4) == 0) {
            VersionChecker.Version newVersion = versionInfo.getNewVersion();
            player.m_213846_((Component)Component.m_237110_((String)"text.vampirism.outdated", (Object[])new Object[]{versionInfo.getCurrentVersion().name, newVersion.name}));
            MutableComponent download = Component.m_237115_((String)"text.vampirism.update_message.download").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, newVersion.getUrl() == null ? versionInfo.getHomePage() : newVersion.getUrl())).m_131162_(Boolean.valueOf(true)).m_131157_(ChatFormatting.BLUE));
            MutableComponent changelog = Component.m_237115_((String)"text.vampirism.update_message.changelog").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vampirism changelog")).m_131162_(Boolean.valueOf(true)));
            MutableComponent modpage = Component.m_237115_((String)"text.vampirism.update_message.modpage").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, versionInfo.getHomePage())).m_131162_(Boolean.valueOf(true)).m_131157_(ChatFormatting.BLUE));
            player.m_213846_((Component)Component.m_237113_((String)"").m_7220_((Component)download).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)changelog).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)modpage));
        }
        if (isAdminLikePlayer && !ModList.get().isLoaded("guideapi_vp") && ((Boolean)VampirismConfig.SERVER.infoAboutGuideAPI.get()).booleanValue()) {
            player.m_213846_((Component)Component.m_237115_((String)"text.vampirism.guideapi_available.first"));
            player.m_213846_((Component)Component.m_237115_((String)"text.vampirism.guideapi_available.download").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/guide-api-village-and-pillage")).m_131162_(Boolean.valueOf(true))));
            VampirismConfig.SERVER.infoAboutGuideAPI.set((Object)false);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            VampirismMod.dispatcher.sendTo(new ClientboundSkillTreePacket(VampirismMod.proxy.getSkillTree(false).getCopy()), serverPlayer);
        }
        Map[] bloodValues = (Map[])Array.newInstance(Map.class, 3);
        bloodValues[0] = BloodConversionRegistry.getEntityConversions();
        bloodValues[1] = BloodConversionRegistry.getItemConversions();
        bloodValues[2] = BloodConversionRegistry.getFluidConversions();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            VampirismMod.dispatcher.sendTo(new ClientboundBloodValuePacket(bloodValues), serverPlayer);
        }
        FactionPlayerHandler.getOpt(player).ifPresent(FactionPlayerHandler::onPlayerLoggedIn);
        if (player instanceof ServerPlayer && !((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player), Permissions.GENERAL_CHECK, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue()) {
            player.m_213846_((Component)Component.m_237113_((String)("[" + ChatFormatting.DARK_PURPLE + "Vampirism" + ChatFormatting.RESET + "] It seems like the permission plugin used is not properly set up. Make sure all players have 'vampirism.*' for the mod to work (or at least '" + Permissions.GENERAL_CHECK.getNodeName() + "' to suppress this warning).")));
        }
    }

    @SubscribeEvent
    public void onServerTick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer()).tick();
    }

    @SubscribeEvent
    public void onWorldUnload(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            VampirismWorld.getOpt(level).ifPresent(VampirismWorld::clearCaches);
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        int missing = ModLootTables.checkAndResetInsertedAll();
        if (missing > 0) {
            LOGGER.warn("LootTables Failed to inject {} loottables", (Object)missing);
        }
    }
}

