/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class HunterActionCriterionTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "hunter_action");
    private static final Logger LOGGER = LogManager.getLogger();

    @NotNull
    public static Instance builder(@NotNull Action action) {
        return new Instance(action);
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(@NotNull ServerPlayer player, Action action) {
        this.m_66234_(player, instance -> instance.test(action));
    }

    @NotNull
    protected Instance createInstance(@NotNull JsonObject json, @NotNull ContextAwarePredicate entityPredicate, @NotNull DeserializationContext conditionsParser) {
        Action action = Action.NONE;
        if (json.has("action")) {
            String name = json.get("action").getAsString();
            try {
                action = Action.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Action {} does not exist", (Object)name);
            }
        } else {
            LOGGER.warn("Action not specified");
        }
        return new Instance(action);
    }

    static class Instance
    extends AbstractCriterionTriggerInstance {
        @NotNull
        private final Action action;

        Instance(@NotNull Action action) {
            super(ID, ContextAwarePredicate.f_285567_);
            this.action = action;
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext serializer) {
            JsonObject json = super.m_7683_(serializer);
            json.addProperty("action", this.action.name());
            return json;
        }

        boolean test(Action action) {
            return this.action == action;
        }
    }

    public static enum Action {
        STAKE,
        NONE;

    }
}

