/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.convertible;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICurableConvertedCreature<T extends PathfinderMob>
extends IConvertedCreature<T> {
    public static final byte CURE_EVENT_ID = 40;

    default public T createCuredEntity(@NotNull PathfinderMob entity, @NotNull EntityType<T> newType) {
        PathfinderMob newEntity = (PathfinderMob)newType.m_20615_(entity.m_9236_());
        if (!1.$assertionsDisabled && newEntity == null) {
            throw new AssertionError();
        }
        newEntity.m_20258_(entity.m_20240_(new CompoundTag()));
        newEntity.f_20883_ = entity.f_20883_;
        newEntity.f_20885_ = entity.f_20885_;
        newEntity.m_20084_(UUID.randomUUID());
        return (T)newEntity;
    }

    default public T cureEntity(@NotNull ServerLevel world, @NotNull PathfinderMob entity, @NotNull EntityType<T> newType) {
        T newEntity = this.createCuredEntity(entity, newType);
        entity.m_142687_(Entity.RemovalReason.DISCARDED);
        entity.m_9236_().m_7967_(newEntity);
        newEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        if (!entity.m_20067_()) {
            world.m_5898_(null, 1027, entity.m_20183_(), 0);
        }
        VampirismAPI.getExtendedCreatureVampirism(newEntity).ifPresent(creature -> creature.setBlood(1));
        ForgeEventFactory.onLivingConvert((LivingEntity)entity, newEntity);
        return newEntity;
    }

    public EntityDataAccessor<Boolean> getConvertingDataParam();

    default public boolean handleSound(byte id, @NotNull PathfinderMob entity) {
        if (id == 40) {
            if (!entity.m_20067_()) {
                entity.m_9236_().m_7785_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), SoundEvents.f_12644_, entity.m_5720_(), 1.0f + entity.m_217043_().m_188501_(), entity.m_217043_().m_188501_() * 0.7f + 0.3f, false);
            }
            return true;
        }
        return false;
    }

    @NotNull
    default public InteractionResult interactWithCureItem(@NotNull Player player, @NotNull ItemStack stack, @NotNull PathfinderMob entity) {
        if (this.isConverting(entity)) {
            return InteractionResult.CONSUME;
        }
        if (!entity.m_21023_(MobEffects.f_19613_)) {
            return InteractionResult.CONSUME;
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        if (!entity.m_9236_().f_46443_) {
            this.startConverting(player.m_20148_(), entity.m_217043_().m_188503_(2400) + 2400, entity);
        }
        return InteractionResult.SUCCESS;
    }

    default public boolean isConverting(@NotNull PathfinderMob entity) {
        return (Boolean)entity.m_20088_().m_135370_(this.getConvertingDataParam());
    }

    default public void registerConvertingData(@NotNull PathfinderMob entity) {
        entity.m_20088_().m_135372_(this.getConvertingDataParam(), (Object)false);
    }

    default public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @NotNull PathfinderMob entity) {
        entity.m_20088_().m_135381_(this.getConvertingDataParam(), (Object)true);
        entity.m_21195_(MobEffects.f_19613_);
        entity.m_9236_().m_7605_((Entity)entity, (byte)40);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

