/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.blockentity.AlchemicalCauldronBlockEntity;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.vampirism.client.renderer.blockentity.AltarInfusionBESR;
import de.teamlapen.vampirism.client.renderer.blockentity.CoffinBESR;
import de.teamlapen.vampirism.client.renderer.blockentity.GarlicDiffuserBESR;
import de.teamlapen.vampirism.client.renderer.blockentity.PedestalBESR;
import de.teamlapen.vampirism.client.renderer.blockentity.TotemBESR;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModTiles;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ModBlocksRender {
    public static final Material[] COFFIN_TEXTURES = (Material[])Arrays.stream(DyeColor.values()).sorted(Comparator.comparingInt(DyeColor::m_41060_)).map(dye -> new Material(InventoryMenu.f_39692_, new ResourceLocation("vampirism", "block/coffin/coffin_" + dye.m_41065_()))).toArray(Material[]::new);

    public static void register() {
        ModBlocksRender.registerRenderType();
    }

    static void registerBlockColors(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RegisterColorHandlersEvent.Block event) {
        event.register((state, worldIn, pos, tintIndex) -> {
            if (tintIndex == 1) {
                return 0x9966FF;
            }
            return 0x8855FF;
        }, new Block[]{(Block)ModBlocks.ALCHEMICAL_FIRE.get()});
        event.register((state, worldIn, pos, tintIndex) -> {
            if (tintIndex == 255) {
                BlockEntity tile;
                BlockEntity blockEntity = tile = worldIn == null || pos == null ? null : worldIn.m_7702_(pos);
                if (tile instanceof AlchemicalCauldronBlockEntity) {
                    return ((AlchemicalCauldronBlockEntity)tile).getLiquidColorClient();
                }
            }
            return 0xFFFFFF;
        }, new Block[]{(Block)ModBlocks.ALCHEMICAL_CAULDRON.get()});
        event.register((state, worldIn, pos, tintIndex) -> {
            if (tintIndex == 255) {
                IFaction<?> f;
                BlockEntity tile;
                BlockEntity blockEntity = tile = worldIn == null || pos == null ? null : worldIn.m_7702_(pos);
                if (tile instanceof TotemBlockEntity && (f = ((TotemBlockEntity)tile).getControllingFaction()) != null) {
                    return f.getColor();
                }
            }
            return 0xFFFFFF;
        }, (Block[])TotemTopBlock.getBlocks().toArray(new TotemTopBlock[0]));
        event.register((state, worldIn, pos, tintIndex) -> 0x1E1F1F, new Block[]{(Block)ModBlocks.DARK_SPRUCE_LEAVES.get()});
    }

    static void registerBlockEntityRenderers(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModTiles.COFFIN.get(), CoffinBESR::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModTiles.ALTAR_INFUSION.get(), AltarInfusionBESR::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModTiles.BLOOD_PEDESTAL.get(), PedestalBESR::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModTiles.TOTEM.get(), TotemBESR::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModTiles.GARLIC_DIFFUSER.get(), GarlicDiffuserBESR::new);
    }

    private static void registerRenderType() {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.IMPURE_BLOOD.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.BLOOD.get()), (RenderType)RenderType.m_110466_());
    }
}

