/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.blocks;

import de.teamlapen.vampirism.blockentity.AltarInspirationBlockEntity;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedAltarInspirationModel
implements IDynamicBakedModel {
    public static final int FLUID_LEVELS = 10;
    public static final BakedModel[] FLUID_MODELS = new BakedModel[10];
    private final BakedModel baseModel;

    public BakedAltarInspirationModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(this.baseModel.getQuads(state, side, rand, ModelData.EMPTY, renderType));
        Integer level = (Integer)extraData.get(AltarInspirationBlockEntity.FLUID_LEVEL_PROP);
        if (level != null && level > 0 && level <= 10) {
            quads.addAll(FLUID_MODELS[level - 1].getQuads(state, side, rand, ModelData.EMPTY, renderType));
        }
        return quads;
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.baseModel.m_7547_();
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.baseModel.getRenderTypes(state, rand, data);
    }
}

