/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity.layers;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.HunterEquipmentModel;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HunterEquipmentLayer<T extends Mob, Q extends EntityModel<T>>
extends RenderLayer<T, Q> {
    @NotNull
    private final HunterEquipmentModel<T> equipmentModel;
    private final ResourceLocation textureExtra = new ResourceLocation("vampirism", "textures/entity/hunter_extra.png");
    private final Function<T, HunterEquipmentModel.StakeType> predicateStake;
    private final Function<T, HunterEquipmentModel.HatType> functionHat;
    @NotNull
    private final Supplier<Optional<ModelPart>> hatPart;

    public HunterEquipmentLayer(@NotNull RenderLayerParent<T, Q> entityRendererIn, @NotNull EntityModelSet modelSet, Function<T, HunterEquipmentModel.StakeType> predicateStake, Function<T, HunterEquipmentModel.HatType> functionHat, @NotNull @NotNull Supplier<@NotNull Optional<ModelPart>> hatPart) {
        super(entityRendererIn);
        this.equipmentModel = new HunterEquipmentModel(modelSet.m_171103_(ModEntitiesRender.HUNTER_EQUIPMENT));
        this.predicateStake = predicateStake;
        this.functionHat = functionHat;
        this.hatPart = hatPart;
    }

    public HunterEquipmentLayer(@NotNull RenderLayerParent<T, Q> entityRendererIn, @NotNull EntityModelSet modelSet, Function<T, HunterEquipmentModel.StakeType> predicateStake, Function<T, HunterEquipmentModel.HatType> functionHat, @Nullable ModelPart hatPart) {
        this(entityRendererIn, modelSet, predicateStake, functionHat, (Supplier<Optional<ModelPart>>)Suppliers.memoize(() -> Optional.ofNullable(hatPart)));
    }

    public void render(@NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, @NotNull T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entityIn.m_20145_()) {
            this.equipmentModel.setHat(this.hatPart.get().map(a -> a.f_104207_).orElse(true) != false ? this.functionHat.apply(entityIn) : HunterEquipmentModel.HatType.NONE);
            this.equipmentModel.setWeapons(this.predicateStake.apply(entityIn));
            HunterEquipmentLayer.m_117359_((EntityModel)this.m_117386_(), this.equipmentModel, (ResourceLocation)this.textureExtra, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entityIn, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

