/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.ai.sensing.VampireVillagerHostilesSensor;
import de.teamlapen.vampirism.entity.villager.Trades;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.schedule.ScheduleBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModVillage {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"vampirism");
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"vampirism");
    public static final DeferredRegister<SensorType<?>> SENSOR_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SENSOR_TYPES, (String)"vampirism");
    public static final DeferredRegister<Schedule> SCHEDULES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SCHEDULES, (String)"vampirism");
    public static final RegistryObject<PoiType> HUNTER_TOTEM = POI_TYPES.register("hunter_totem", () -> new PoiType(ModVillage.getAllStates((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER.get(), (Block)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER_CRAFTED.get()), 1, 1));
    public static final RegistryObject<PoiType> VAMPIRE_TOTEM = POI_TYPES.register("vampire_totem", () -> new PoiType(ModVillage.getAllStates((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE.get(), (Block)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE_CRAFTED.get()), 1, 1));
    public static final RegistryObject<PoiType> NO_FACTION_TOTEM = POI_TYPES.register("no_faction_totem", () -> new PoiType(ModVillage.getAllStates((Block)ModBlocks.TOTEM_TOP.get(), (Block)ModBlocks.TOTEM_TOP_CRAFTED.get()), 1, 1));
    public static final RegistryObject<PoiType> ALTAR_CLEANSING = POI_TYPES.register("church_altar", () -> new PoiType(ModVillage.getAllStates((Block)ModBlocks.ALTAR_CLEANSING.get()), 1, 1));
    public static final RegistryObject<SensorType<VampireVillagerHostilesSensor>> VAMPIRE_VILLAGER_HOSTILES = SENSOR_TYPES.register("vampire_villager_hostiles", () -> new SensorType(VampireVillagerHostilesSensor::new));
    public static final RegistryObject<Schedule> CONVERTED_DEFAULT = SCHEDULES.register("converted_default", () -> new ScheduleBuilder(new Schedule()).m_38040_(12000, Activity.f_37979_).m_38040_(10, Activity.f_37982_).m_38040_(14000, Activity.f_37980_).m_38040_(21000, Activity.f_37983_).m_38040_(23000, Activity.f_37979_).m_38039_());
    public static final RegistryObject<VillagerProfession> VAMPIRE_EXPERT = PROFESSIONS.register("vampire_expert", () -> new VillagerProfession("vampire_expert", holder -> holder.m_203656_(ModTags.PoiTypes.IS_VAMPIRE), holder -> holder.m_203656_(ModTags.PoiTypes.IS_VAMPIRE), ImmutableSet.of(), ImmutableSet.of(), null));
    public static final RegistryObject<VillagerProfession> HUNTER_EXPERT = PROFESSIONS.register("hunter_expert", () -> new VillagerProfession("hunter_expert", holder -> holder.m_203656_(ModTags.PoiTypes.IS_HUNTER), holder -> holder.m_203656_(ModTags.PoiTypes.IS_HUNTER), ImmutableSet.of(), ImmutableSet.of(), null));
    public static final RegistryObject<VillagerProfession> PRIEST = PROFESSIONS.register("priest", () -> new VillagerProfession("priest", holder -> holder.m_203565_(ALTAR_CLEANSING.getKey()), holder -> holder.m_203565_(ALTAR_CLEANSING.getKey()), ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)ModSounds.BLESSING_MUSIC.get()));

    static void register(IEventBus bus) {
        POI_TYPES.register(bus);
        PROFESSIONS.register(bus);
        SENSOR_TYPES.register(bus);
        SCHEDULES.register(bus);
    }

    public static void villagerTradeSetup() {
        VillagerTrades.f_35627_.computeIfAbsent((VillagerProfession)VAMPIRE_EXPERT.get(), trades -> new Int2ObjectOpenHashMap()).putAll(ModVillage.getVampireTrades());
        VillagerTrades.f_35627_.computeIfAbsent((VillagerProfession)HUNTER_EXPERT.get(), trades -> new Int2ObjectOpenHashMap()).putAll(ModVillage.getHunterTrades());
        VillagerTrades.f_35627_.computeIfAbsent((VillagerProfession)PRIEST.get(), trades -> new Int2ObjectOpenHashMap()).putAll(ModVillage.getPriestTrades());
    }

    private static Set<BlockState> getAllStates(Block ... blocks) {
        return (Set)Arrays.stream(blocks).flatMap(block -> block.m_49965_().m_61056_().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @NotNull
    private static Map<Integer, VillagerTrades.ItemListing[]> getHunterTrades() {
        return ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForSouls(new Trades.Price(10, 20), (ItemLike)ModItems.ITEM_GARLIC.get(), new Trades.Price(2, 5)), new Trades.ItemsForSouls(new Trades.Price(30, 40), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_CHEST_NORMAL.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_LEGS_NORMAL.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_FEET_NORMAL.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_HEAD_NORMAL.get(), new Trades.Price(1, 1), 6, 1), new Trades.VampireForestMapTrade(5, 3, 2)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForSouls(new Trades.Price(25, 45), (ItemLike)Items.f_42415_, new Trades.Price(1, 1), 2, 5), new Trades.ItemsForSouls(new Trades.Price(10, 20), (ItemLike)ModItems.CROSSBOW_ARROW_NORMAL.get(), new Trades.Price(5, 15)), new VillagerTrades.ItemsForEmeralds((Item)ModItems.SOUL_ORB_VAMPIRE.get(), 10, 10, 4), new Trades.ItemsForSouls(new Trades.Price(30, 40), (ItemLike)ModItems.HUNTER_COAT_CHEST_NORMAL.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), (ItemLike)ModItems.HUNTER_COAT_LEGS_NORMAL.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), (ItemLike)ModItems.HUNTER_COAT_FEET_NORMAL.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), (ItemLike)ModItems.HUNTER_COAT_HEAD_NORMAL.get(), new Trades.Price(1, 1), 6, 1), new Trades.ItemsForSouls(new Trades.Price(30, 40), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ENHANCED.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ENHANCED.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_FEET_ENHANCED.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ENHANCED.get(), new Trades.Price(1, 1), 6, 1)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForSouls(new Trades.Price(40, 64), (ItemLike)ModItems.VAMPIRE_BOOK.get(), new Trades.Price(1, 1), 10, 1), new Trades.ItemsForSouls(new Trades.Price(30, 40), (ItemLike)ModItems.HUNTER_COAT_CHEST_ENHANCED.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 35), (ItemLike)ModItems.HUNTER_COAT_LEGS_ENHANCED.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(10, 15), (ItemLike)ModItems.HUNTER_COAT_FEET_ENHANCED.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), (ItemLike)ModItems.HUNTER_COAT_HEAD_ENHANCED.get(), new Trades.Price(1, 1), 6, 1), new Trades.ItemsForSouls(new Trades.Price(30, 45), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 45), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(15, 30), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 30), (ItemLike)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get(), new Trades.Price(1, 1), 6, 1)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForSouls(new Trades.Price(20, 32), (ItemLike)Items.f_42415_, new Trades.Price(1, 2))}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForSouls(new Trades.Price(30, 55), (ItemLike)ModItems.HUNTER_COAT_CHEST_ULTIMATE.get(), new Trades.Price(1, 1), 8, 1), new Trades.ItemsForSouls(new Trades.Price(25, 55), (ItemLike)ModItems.HUNTER_COAT_LEGS_ULTIMATE.get(), new Trades.Price(1, 1), 7, 1), new Trades.ItemsForSouls(new Trades.Price(20, 35), (ItemLike)ModItems.HUNTER_COAT_FEET_ULTIMATE.get(), new Trades.Price(1, 1), 5, 1), new Trades.ItemsForSouls(new Trades.Price(20, 35), (ItemLike)ModItems.HUNTER_COAT_HEAD_ULTIMATE.get(), new Trades.Price(1, 1), 6, 1)});
    }

    @NotNull
    private static Map<Integer, VillagerTrades.ItemListing[]> getPriestTrades() {
        return ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new VillagerTrades.EmeraldForItems((ItemLike)ModItems.PURE_SALT.get(), 25, 2, 4), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.ITEM_GARLIC.get(), 30, 6, 2)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)ModItems.HOLY_WATER_BOTTLE_NORMAL.get(), 3, 5, 4), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.SOUL_ORB_VAMPIRE.get(), 10, 10, 4), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.VAMPIRE_BLOOD_BOTTLE.get(), 9, 4, 5), new VillagerTrades.ItemsForEmeralds((Item)ModItems.CRUCIFIX_NORMAL.get(), 1, 1, 1)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get(), 2, 5, 4)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get(), 1, 4, 4)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get(), 3, 4, 4)});
    }

    @NotNull
    private static Map<Integer, VillagerTrades.ItemListing[]> getVampireTrades() {
        return ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForHeart(new Trades.Price(10, 15), (ItemLike)ModItems.PURE_BLOOD_0.get(), new Trades.Price(1, 1)), new Trades.BloodBottleForHeart(new Trades.Price(3, 12), new Trades.Price(1, 15), 9), new VillagerTrades.EmeraldForItems((ItemLike)ModBlocks.VAMPIRE_ORCHID.get(), 4, 1, 3), new Trades.VampireForestMapTrade(5, 3, 2)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForHeart(new Trades.Price(25, 30), (ItemLike)ModItems.PURE_BLOOD_1.get(), new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(1, 5), (ItemLike)ModBlocks.COFFIN_RED.get(), new Trades.Price(1, 1), 2, 2), new Trades.ItemsForHeart(new Trades.Price(10, 25), (ItemLike)ModItems.BLOOD_INFUSED_IRON_INGOT.get(), new Trades.Price(1, 3))}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForHeart(new Trades.Price(30, 40), (ItemLike)ModItems.PURE_BLOOD_2.get(), new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(15, 30), (ItemLike)ModItems.BLOOD_INFUSED_ENHANCED_IRON_INGOT.get(), new Trades.Price(1, 2))}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForHeart(new Trades.Price(20, 30), (ItemLike)ModItems.PURE_BLOOD_3.get(), new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(10, 30), new ItemStack[]{new ItemStack((ItemLike)ModItems.VAMPIRE_CLOAK_BLACK_BLUE.get()), new ItemStack((ItemLike)ModItems.VAMPIRE_CLOAK_BLACK_RED.get()), new ItemStack((ItemLike)ModItems.VAMPIRE_CLOAK_BLACK_WHITE.get()), new ItemStack((ItemLike)ModItems.VAMPIRE_CLOAK_RED_BLACK.get()), new ItemStack((ItemLike)ModItems.VAMPIRE_CLOAK_WHITE_BLACK.get())}, new Trades.Price(1, 1), 10, 2)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new Trades.ItemsForHeart(new Trades.Price(30, 40), (ItemLike)ModItems.PURE_BLOOD_4.get(), new Trades.Price(1, 1), 10, 1), new Trades.ItemsForHeart(new Trades.Price(10, 30), new ItemStack[]{new ItemStack((ItemLike)ModItems.VAMPIRE_CLOAK_BLACK_BLUE.get()), new ItemStack((ItemLike)ModItems.VAMPIRE_CLOAK_BLACK_RED.get()), new ItemStack((ItemLike)ModItems.VAMPIRE_CLOAK_BLACK_WHITE.get()), new ItemStack((ItemLike)ModItems.VAMPIRE_CLOAK_RED_BLACK.get()), new ItemStack((ItemLike)ModItems.VAMPIRE_CLOAK_WHITE_BLACK.get())}, new Trades.Price(1, 1), 10, 2), new VillagerTrades.ItemsForEmeralds((Item)ModItems.HEART_SEEKER_ULTIMATE.get(), 40, 1, 15), new VillagerTrades.ItemsForEmeralds((Item)ModItems.HEART_STRIKER_ULTIMATE.get(), 40, 1, 15)});
    }
}

