/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data;

import de.teamlapen.vampirism.blocks.AlchemicalCauldronBlock;
import de.teamlapen.vampirism.blocks.AlchemyTableBlock;
import de.teamlapen.vampirism.blocks.AltarPillarBlock;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.DirectCursedBarkBlock;
import de.teamlapen.vampirism.blocks.GarlicBlock;
import de.teamlapen.vampirism.blocks.HunterTableBlock;
import de.teamlapen.vampirism.blocks.MedChairBlock;
import de.teamlapen.vampirism.blocks.SieveBlock;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class BlockStateGenerator
extends BlockStateProvider {
    public BlockStateGenerator(@NotNull PackOutput packOutput, @NotNull ExistingFileHelper exFileHelper) {
        super(packOutput, "vampirism", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ResourceLocation cutout = new ResourceLocation("cutout");
        ResourceLocation cutout_mipped = new ResourceLocation("cutout_mipped");
        ResourceLocation translucent = new ResourceLocation("translucent");
        ModelBuilder dark_spruce_sapling = ((BlockModelBuilder)this.models().cross("dark_spruce_sapling", this.modLoc("block/dark_spruce_sapling"))).renderType(cutout);
        ModelBuilder cursed_spruce_sapling = ((BlockModelBuilder)this.models().cross("cursed_spruce_sapling", this.modLoc("block/cursed_spruce_sapling"))).renderType(cutout);
        this.horizontalBlock((Block)ModBlocks.GARLIC_DIFFUSER_NORMAL.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("garlic_diffuser_normal", this.modLoc("block/garlic_diffuser"))).renderType(cutout));
        this.horizontalBlock((Block)ModBlocks.GARLIC_DIFFUSER_WEAK.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("garlic_diffuser_weak", this.modLoc("block/garlic_diffuser"))).renderType(cutout));
        this.horizontalBlock((Block)ModBlocks.GARLIC_DIFFUSER_IMPROVED.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("garlic_diffuser_improved", this.modLoc("block/garlic_diffuser"))).texture("garlic", "vampirism:block/garlic_diffuser_inside_improved")).renderType(cutout));
        this.horizontalBlock((Block)ModBlocks.ALTAR_CLEANSING.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/altar_cleansing")));
        this.horizontalBlock((Block)ModBlocks.BLOOD_GRINDER.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/blood_grinder")));
        this.simpleBlock((Block)ModBlocks.CASTLE_BLOCK_DARK_BRICK.get());
        this.simpleBlock((Block)ModBlocks.CASTLE_BLOCK_DARK_BRICK_BLOODY.get());
        this.simpleBlock((Block)ModBlocks.CASTLE_BLOCK_DARK_STONE.get());
        this.simpleBlock((Block)ModBlocks.CASTLE_BLOCK_NORMAL_BRICK.get());
        this.simpleBlock((Block)ModBlocks.CASTLE_BLOCK_PURPLE_BRICK.get());
        this.simpleBlock((Block)ModBlocks.CURSED_EARTH.get());
        this.simpleBlock((Block)ModBlocks.SUNSCREEN_BEACON.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("vampirism:block/sunscreen_beacon", "minecraft:block/beacon")).texture("beacon", "vampirism:block/cursed_earth")).renderType(cutout));
        BlockModelBuilder builder1 = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("vampirism:block/empty")).texture("particle", "minecraft:block/spruce_planks");
        CoffinBlock.COFFIN_BLOCKS.values().forEach(coffin -> this.getVariantBuilder((Block)coffin).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)builder1).build()));
        this.simpleBlock((Block)ModBlocks.VAMPIRE_ORCHID.get(), (ModelFile)((BlockModelBuilder)this.models().cross("vampire_orchid", this.modLoc("block/vampire_orchid"))).renderType(cutout));
        this.simpleBlock((Block)ModBlocks.TOTEM_TOP.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/totem_top")));
        this.simpleBlock((Block)ModBlocks.TOTEM_TOP_CRAFTED.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/totem_top_crafted")));
        this.simpleBlock((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER.get(), (ModelFile)this.models().withExistingParent("totem_top_vampirism_hunter", this.modLoc("block/totem_top")));
        this.simpleBlock((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE.get(), (ModelFile)this.models().withExistingParent("totem_top_vampirism_vampire", this.modLoc("block/totem_top")));
        this.simpleBlock((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER_CRAFTED.get(), (ModelFile)this.models().withExistingParent("totem_top_vampirism_hunter_crafted", this.modLoc("block/totem_top_crafted")));
        this.simpleBlock((Block)ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE_CRAFTED.get(), (ModelFile)this.models().withExistingParent("totem_top_vampirism_vampire_crafted", this.modLoc("block/totem_top_crafted")));
        this.simpleBlock((Block)ModBlocks.TOTEM_BASE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/totem_base")));
        this.simpleBlock((Block)ModBlocks.ALTAR_INFUSION.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/altar_infusion")));
        this.simpleBlock((Block)ModBlocks.ALTAR_INSPIRATION.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/altar_inspiration/altar_inspiration")));
        this.simpleBlock((Block)ModBlocks.ALTAR_TIP.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/altar_tip")));
        this.simpleBlock((Block)ModBlocks.BLOOD_CONTAINER.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/blood_container/blood_container")));
        this.simpleBlock((Block)ModBlocks.BLOOD_PEDESTAL.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/blood_pedestal")));
        this.simpleBlock((Block)ModBlocks.POTION_TABLE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/potion_table")));
        this.simpleBlock((Block)ModBlocks.FIRE_PLACE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/fire_place")));
        this.simpleBlock((Block)ModBlocks.POTTED_VAMPIRE_ORCHID.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("vampirism:block/potted_vampire_orchid", "minecraft:block/flower_pot_cross")).texture("plant", "vampirism:block/vampire_orchid")).renderType(cutout));
        this.simpleBlock((Block)ModBlocks.DARK_SPRUCE_LEAVES.get(), (ModelFile)this.models().getExistingFile(this.mcLoc("block/oak_leaves")));
        this.simpleBlock((Block)ModBlocks.DARK_SPRUCE_SAPLING.get(), (ModelFile)dark_spruce_sapling);
        this.simpleBlock((Block)ModBlocks.CURSED_SPRUCE_SAPLING.get(), (ModelFile)cursed_spruce_sapling);
        this.stairsBlock((StairBlock)ModBlocks.CASTLE_STAIRS_DARK_STONE.get(), this.modLoc("block/castle_block_dark_stone"));
        this.stairsBlock((StairBlock)ModBlocks.CASTLE_STAIRS_DARK_BRICK.get(), this.modLoc("block/castle_block_dark_brick"));
        this.stairsBlock((StairBlock)ModBlocks.CASTLE_STAIRS_PURPLE_BRICK.get(), this.modLoc("block/castle_block_purple_brick"));
        this.slabBlock((SlabBlock)ModBlocks.CASTLE_SLAB_DARK_BRICK.get(), this.modLoc("block/castle_block_dark_brick"), this.modLoc("block/castle_block_dark_brick"));
        this.slabBlock((SlabBlock)ModBlocks.CASTLE_SLAB_DARK_STONE.get(), this.modLoc("block/castle_block_dark_stone"), this.modLoc("block/castle_block_dark_stone"));
        this.slabBlock((SlabBlock)ModBlocks.CASTLE_SLAB_PURPLE_BRICK.get(), this.modLoc("block/castle_block_purple_brick"), this.modLoc("block/castle_block_purple_brick"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)ModBlocks.GARLIC.get()).partialState().with((Property)GarlicBlock.f_52244_, (Comparable)Integer.valueOf(0)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/garlic_stage_0"))).addModel()).partialState().with((Property)GarlicBlock.f_52244_, (Comparable)Integer.valueOf(1)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/garlic_stage_0"))).addModel()).partialState().with((Property)GarlicBlock.f_52244_, (Comparable)Integer.valueOf(2)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/garlic_stage_1"))).addModel()).partialState().with((Property)GarlicBlock.f_52244_, (Comparable)Integer.valueOf(3)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/garlic_stage_1"))).addModel()).partialState().with((Property)GarlicBlock.f_52244_, (Comparable)Integer.valueOf(4)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/garlic_stage_2"))).addModel()).partialState().with((Property)GarlicBlock.f_52244_, (Comparable)Integer.valueOf(5)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/garlic_stage_2"))).addModel()).partialState().with((Property)GarlicBlock.f_52244_, (Comparable)Integer.valueOf(6)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/garlic_stage_3"))).addModel()).partialState().with((Property)GarlicBlock.f_52244_, (Comparable)Integer.valueOf(7)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/garlic_stage_3"))).addModel();
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)ModBlocks.ALTAR_PILLAR.get()).partialState().with(AltarPillarBlock.TYPE_PROPERTY, (Comparable)((Object)AltarPillarBlock.EnumPillarType.NONE)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/altar_pillar"))).addModel()).partialState().with(AltarPillarBlock.TYPE_PROPERTY, (Comparable)((Object)AltarPillarBlock.EnumPillarType.BONE)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("altar_pillar_filled_bone", this.modLoc("block/altar_pillar_filled"))).texture("filler", this.mcLoc("block/bone_block_side"))).addModel()).partialState().with(AltarPillarBlock.TYPE_PROPERTY, (Comparable)((Object)AltarPillarBlock.EnumPillarType.GOLD)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("altar_pillar_filled_gold", this.modLoc("block/altar_pillar_filled"))).texture("filler", this.mcLoc("block/gold_block"))).addModel()).partialState().with(AltarPillarBlock.TYPE_PROPERTY, (Comparable)((Object)AltarPillarBlock.EnumPillarType.STONE)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("altar_pillar_filled_stone_bricks", this.modLoc("block/altar_pillar_filled"))).texture("filler", this.mcLoc("block/stone_bricks"))).addModel()).partialState().with(AltarPillarBlock.TYPE_PROPERTY, (Comparable)((Object)AltarPillarBlock.EnumPillarType.IRON)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("altar_pillar_filled_iron", this.modLoc("block/altar_pillar_filled"))).texture("filler", this.mcLoc("block/iron_block"))).addModel();
        ModelFile.ExistingModelFile sieve = this.models().getExistingFile(this.modLoc("block/blood_sieve"));
        ModelBuilder activeSieve = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("active_blood_sieve")).parent((ModelFile)sieve)).texture("filter", this.modLoc("block/blood_sieve_filter_active"));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)ModBlocks.BLOOD_SIEVE.get()).partialState().with((Property)SieveBlock.PROPERTY_ACTIVE, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)activeSieve).addModel()).partialState().with((Property)SieveBlock.PROPERTY_ACTIVE, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)sieve).addModel();
        this.getVariantBuilder((Block)ModBlocks.MED_CHAIR.get()).forAllStates(blockState -> {
            if (blockState.m_61143_(MedChairBlock.PART) == MedChairBlock.EnumPart.BOTTOM) {
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/medchairbase"))).rotationY(((int)((Direction)blockState.m_61143_((Property)MedChairBlock.FACING)).m_122435_() + 180) % 360).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/medchairhead"))).rotationY(((int)((Direction)blockState.m_61143_((Property)MedChairBlock.FACING)).m_122435_() + 180) % 360).build();
        });
        BlockModelBuilder fire_side_alt0 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fire_side_alt0", this.modLoc("block/fire_side_alt"))).renderType(cutout)).texture("particle", this.mcLoc("block/fire_0"))).texture("fire", this.mcLoc("block/fire_0"));
        BlockModelBuilder fire_side_alt1 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fire_side_alt1", this.modLoc("block/fire_side_alt"))).renderType(cutout)).texture("particle", this.mcLoc("block/fire_1"))).texture("fire", this.mcLoc("block/fire_1"));
        BlockModelBuilder fire_side0 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fire_side0", this.modLoc("block/fire_side"))).renderType(cutout)).texture("particle", this.mcLoc("block/fire_0"))).texture("fire", this.mcLoc("block/fire_0"));
        BlockModelBuilder fire_side1 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fire_side1", this.modLoc("block/fire_side"))).renderType(cutout)).texture("particle", this.mcLoc("block/fire_1"))).texture("fire", this.mcLoc("block/fire_1"));
        BlockModelBuilder fire_floor0 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fire_floor0", this.modLoc("block/fire_floor"))).renderType(cutout)).texture("particle", this.mcLoc("block/fire_0"))).texture("fire", this.mcLoc("block/fire_0"));
        BlockModelBuilder fire_floor1 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fire_floor1", this.modLoc("block/fire_floor"))).renderType(cutout)).texture("particle", this.mcLoc("block/fire_1"))).texture("fire", this.mcLoc("block/fire_1"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)ModBlocks.ALCHEMICAL_FIRE.get()).part().modelFile((ModelFile)fire_floor0).nextModel().modelFile((ModelFile)fire_floor1).addModel()).end().part().modelFile((ModelFile)fire_side0).nextModel().modelFile((ModelFile)fire_side1).nextModel().modelFile((ModelFile)fire_side_alt0).nextModel().modelFile((ModelFile)fire_side_alt1).addModel()).end().part().modelFile((ModelFile)fire_side0).rotationY(90).nextModel().modelFile((ModelFile)fire_side1).rotationY(90).nextModel().modelFile((ModelFile)fire_side_alt0).rotationY(90).nextModel().modelFile((ModelFile)fire_side_alt1).rotationY(90).addModel()).end().part().modelFile((ModelFile)fire_side0).rotationY(180).nextModel().modelFile((ModelFile)fire_side1).rotationY(180).nextModel().modelFile((ModelFile)fire_side_alt0).rotationY(180).nextModel().modelFile((ModelFile)fire_side_alt1).rotationY(180).addModel()).end().part().modelFile((ModelFile)fire_side0).rotationY(270).nextModel().modelFile((ModelFile)fire_side1).rotationY(270).nextModel().modelFile((ModelFile)fire_side_alt0).rotationY(270).nextModel().modelFile((ModelFile)fire_side_alt1).rotationY(270).addModel()).end();
        ModelFile.ExistingModelFile cauldronLiquid = this.models().getExistingFile(this.modLoc("block/alchemy_cauldron_liquid"));
        ModelBuilder cauldronLiquidBoiling = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("cauldron_boiling")).parent((ModelFile)cauldronLiquid)).texture("liquid", this.modLoc("block/blank_liquid_boiling"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)ModBlocks.ALCHEMICAL_CAULDRON.get()).part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/alchemy_cauldron"))).addModel()).end().part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/alchemy_cauldron_fire"))).addModel()).condition((Property)AlchemicalCauldronBlock.f_48684_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)cauldronLiquid).addModel()).condition((Property)AlchemicalCauldronBlock.LIQUID, (Comparable[])new Integer[]{1}).end().part().modelFile((ModelFile)cauldronLiquidBoiling).addModel()).condition((Property)AlchemicalCauldronBlock.LIQUID, (Comparable[])new Integer[]{2}).end();
        ModelFile.ExistingModelFile tentModel = this.models().getExistingFile(this.modLoc("block/tent"));
        ModelFile.ExistingModelFile tentBackLeft = this.models().getExistingFile(this.modLoc("block/tentback"));
        ModelFile.ExistingModelFile tentBackRight = this.models().getExistingFile(this.modLoc("block/tentback_flipped"));
        ModelBuilder tentTR = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("tent_tr")).parent((ModelFile)tentModel)).texture("floor", this.modLoc("block/tent/floor_tr"));
        ModelBuilder tentTL = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("tent_tl")).parent((ModelFile)tentModel)).texture("floor", this.modLoc("block/tent/floor_tl"));
        ModelBuilder tentBL = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("tent_bl")).parent((ModelFile)tentModel)).texture("floor", this.modLoc("block/tent/floor_bl"));
        ModelBuilder tentBR = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("tent_br")).parent((ModelFile)tentModel)).texture("floor", this.modLoc("block/tent/floor_br"));
        Arrays.stream(new TentBlock[]{(TentBlock)((Object)ModBlocks.TENT.get()), (TentBlock)((Object)ModBlocks.TENT_MAIN.get())}).forEach(arg_0 -> this.lambda$registerStatesAndModels$3((ModelFile)tentBR, (ModelFile)tentBL, (ModelFile)tentTL, (ModelFile)tentTR, (ModelFile)tentBackLeft, (ModelFile)tentBackRight, arg_0));
        ModelFile.ExistingModelFile weaponTable = this.models().getExistingFile(this.modLoc("block/weapon_table/weapon_table"));
        ModelFile.ExistingModelFile weaponTableL1 = this.models().getExistingFile(this.modLoc("block/weapon_table/weapon_table_lava1"));
        ModelFile.ExistingModelFile weaponTableL2 = this.models().getExistingFile(this.modLoc("block/weapon_table/weapon_table_lava2"));
        ModelFile.ExistingModelFile weaponTableL3 = this.models().getExistingFile(this.modLoc("block/weapon_table/weapon_table_lava3"));
        ModelFile.ExistingModelFile weaponTableL4 = this.models().getExistingFile(this.modLoc("block/weapon_table/weapon_table_lava4"));
        ModelFile.ExistingModelFile weaponTableL5 = this.models().getExistingFile(this.modLoc("block/weapon_table/weapon_table_lava5"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)ModBlocks.WEAPON_TABLE.get()).part().modelFile((ModelFile)weaponTable).rotationY(0).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)weaponTable).rotationY(90).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)weaponTable).rotationY(180).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)weaponTable).rotationY(270).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).end().part().modelFile((ModelFile)weaponTableL1).rotationY(0).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{1}).end().part().modelFile((ModelFile)weaponTableL1).rotationY(90).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{1}).end().part().modelFile((ModelFile)weaponTableL1).rotationY(180).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{1}).end().part().modelFile((ModelFile)weaponTableL1).rotationY(270).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{1}).end().part().modelFile((ModelFile)weaponTableL2).rotationY(0).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)weaponTableL2).rotationY(90).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)weaponTableL2).rotationY(180).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)weaponTableL2).rotationY(270).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)weaponTableL3).rotationY(0).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{3}).end().part().modelFile((ModelFile)weaponTableL3).rotationY(90).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{3}).end().part().modelFile((ModelFile)weaponTableL3).rotationY(180).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{3}).end().part().modelFile((ModelFile)weaponTableL3).rotationY(270).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{3}).end().part().modelFile((ModelFile)weaponTableL4).rotationY(0).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{4}).end().part().modelFile((ModelFile)weaponTableL4).rotationY(90).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{4}).end().part().modelFile((ModelFile)weaponTableL4).rotationY(180).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{4}).end().part().modelFile((ModelFile)weaponTableL4).rotationY(270).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{4}).end().part().modelFile((ModelFile)weaponTableL5).rotationY(0).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{5}).end().part().modelFile((ModelFile)weaponTableL5).rotationY(90).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{5}).end().part().modelFile((ModelFile)weaponTableL5).rotationY(180).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{5}).end().part().modelFile((ModelFile)weaponTableL5).rotationY(270).addModel()).condition((Property)WeaponTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)WeaponTableBlock.LAVA, (Comparable[])new Integer[]{5}).end();
        ModelFile.ExistingModelFile hunterTable = this.models().getExistingFile(this.modLoc("block/hunter_table/hunter_table"));
        ModelFile.ExistingModelFile hunterTableBottle = this.models().getExistingFile(this.modLoc("block/hunter_table/hunter_table_bottle"));
        ModelFile.ExistingModelFile hunterTableGarlic = this.models().getExistingFile(this.modLoc("block/hunter_table/hunter_table_garlic"));
        ModelFile.ExistingModelFile hunterTableHammer = this.models().getExistingFile(this.modLoc("block/hunter_table/hunter_table_hammer"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)ModBlocks.HUNTER_TABLE.get()).part().modelFile((ModelFile)hunterTable).rotationY(0).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)hunterTable).rotationY(90).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)hunterTable).rotationY(180).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)hunterTable).rotationY(270).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).end().part().modelFile((ModelFile)hunterTableBottle).rotationY(0).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.POTION, HunterTableBlock.TABLE_VARIANT.POTION_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_POTION, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end().part().modelFile((ModelFile)hunterTableBottle).rotationY(90).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.POTION, HunterTableBlock.TABLE_VARIANT.POTION_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_POTION, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end().part().modelFile((ModelFile)hunterTableBottle).rotationY(180).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.POTION, HunterTableBlock.TABLE_VARIANT.POTION_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_POTION, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end().part().modelFile((ModelFile)hunterTableBottle).rotationY(270).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.POTION, HunterTableBlock.TABLE_VARIANT.POTION_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_POTION, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end().part().modelFile((ModelFile)hunterTableGarlic).rotationY(0).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.CAULDRON, HunterTableBlock.TABLE_VARIANT.POTION_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_CAULDRON, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end().part().modelFile((ModelFile)hunterTableGarlic).rotationY(90).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.CAULDRON, HunterTableBlock.TABLE_VARIANT.POTION_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_CAULDRON, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end().part().modelFile((ModelFile)hunterTableGarlic).rotationY(180).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.CAULDRON, HunterTableBlock.TABLE_VARIANT.POTION_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_CAULDRON, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end().part().modelFile((ModelFile)hunterTableGarlic).rotationY(270).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.CAULDRON, HunterTableBlock.TABLE_VARIANT.POTION_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_CAULDRON, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end().part().modelFile((ModelFile)hunterTableHammer).rotationY(0).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.WEAPON, HunterTableBlock.TABLE_VARIANT.WEAPON_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_POTION, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end().part().modelFile((ModelFile)hunterTableHammer).rotationY(90).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.WEAPON, HunterTableBlock.TABLE_VARIANT.WEAPON_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_POTION, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end().part().modelFile((ModelFile)hunterTableHammer).rotationY(180).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.WEAPON, HunterTableBlock.TABLE_VARIANT.WEAPON_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_POTION, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end().part().modelFile((ModelFile)hunterTableHammer).rotationY(270).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition(HunterTableBlock.VARIANT, (Comparable[])new HunterTableBlock.TABLE_VARIANT[]{HunterTableBlock.TABLE_VARIANT.WEAPON, HunterTableBlock.TABLE_VARIANT.WEAPON_CAULDRON, HunterTableBlock.TABLE_VARIANT.WEAPON_POTION, HunterTableBlock.TABLE_VARIANT.COMPLETE}).end();
        this.simpleBlock((Block)ModBlocks.CHANDELIER.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/chandelier")));
        this.horizontalBlock((Block)ModBlocks.CANDELABRA.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/candelabra")));
        this.horizontalBlock((Block)ModBlocks.CANDELABRA_WALL.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/candelabra_wall")));
        this.horizontalBlock((Block)ModBlocks.CROSS.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/cross")));
        this.horizontalBlock((Block)ModBlocks.TOMBSTONE1.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/tombstone1")));
        this.horizontalBlock((Block)ModBlocks.TOMBSTONE2.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/tombstone2")));
        this.horizontalBlock((Block)ModBlocks.TOMBSTONE3.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/tombstone3")));
        this.horizontalBlock((Block)ModBlocks.GRAVE_CAGE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/grave_cage")));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)ModBlocks.CURSED_GRASS.get()).part().modelFile((ModelFile)this.models().cubeBottomTop("vampirism:cursed_grass", this.modLoc("block/cursed_grass_side"), this.modLoc("block/cursed_earth"), this.modLoc("block/cursed_grass_top"))).addModel()).end().part().modelFile((ModelFile)this.models().cubeBottomTop("vampirism:cursed_grass_snowy", this.modLoc("block/cursed_grass_side_snowy"), this.modLoc("block/cursed_earth"), this.modLoc("block/cursed_grass_top"))).addModel()).condition((Property)BlockStateProperties.f_61451_, (Comparable[])new Boolean[]{true}).end();
        this.simpleBlock((Block)ModBlocks.CURSED_ROOTS.get(), (ModelFile)((BlockModelBuilder)this.models().cross("cursed_roots", this.modLoc("block/cursed_roots"))).renderType(cutout));
        this.simpleBlock((Block)ModBlocks.POTTED_CURSED_ROOTS.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("vampirism:block/potted_cursed_roots", "minecraft:block/flower_pot_cross")).texture("plant", "vampirism:block/cursed_roots"));
        this.trapdoorBlock((TrapDoorBlock)ModBlocks.DARK_SPRUCE_TRAPDOOR.get(), new ResourceLocation("vampirism", "block/dark_spruce_trapdoor"), true);
        this.trapdoorBlock((TrapDoorBlock)ModBlocks.CURSED_SPRUCE_TRAPDOOR.get(), new ResourceLocation("vampirism", "block/cursed_spruce_trapdoor"), true);
        this.doorBlock((DoorBlock)ModBlocks.DARK_SPRUCE_DOOR.get(), new ResourceLocation("vampirism", "block/dark_spruce_door_bottom"), new ResourceLocation("vampirism", "block/dark_spruce_door_top"));
        this.doorBlock((DoorBlock)ModBlocks.CURSED_SPRUCE_DOOR.get(), new ResourceLocation("vampirism", "block/cursed_spruce_door_bottom"), new ResourceLocation("vampirism", "block/cursed_spruce_door_top"));
        this.createWoodStates();
        this.createCursedBark();
        this.horizontalBlock((Block)ModBlocks.VAMPIRE_RACK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/vampire_rack")));
        this.horizontalBlock((Block)ModBlocks.THRONE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/throne")));
        for (DyeColor dye : DyeColor.values()) {
            ((BlockModelBuilder)this.models().withExistingParent("vampirism:block/coffin/coffin_" + dye.m_41065_(), "vampirism:block/coffin")).texture("0", "vampirism:block/coffin/coffin_" + dye.m_41065_());
            ((BlockModelBuilder)this.models().withExistingParent("vampirism:block/coffin/coffin_bottom_" + dye.m_41065_(), "vampirism:block/coffin_bottom")).texture("0", "vampirism:block/coffin/coffin_" + dye.m_41065_());
            ((BlockModelBuilder)this.models().withExistingParent("vampirism:block/coffin/coffin_top_" + dye.m_41065_(), "vampirism:block/coffin_top")).texture("0", "vampirism:block/coffin/coffin_" + dye.m_41065_());
        }
        MultiPartBlockStateBuilder alchemy_table = this.getMultipartBuilder((Block)ModBlocks.ALCHEMY_TABLE.get());
        this.applyHorizontalModel(alchemy_table, (ModelFile)this.models().getExistingFile(this.modLoc("block/alchemy_table/alchemy_table")));
        this.applyHorizontalModel(alchemy_table, (ModelFile)this.models().getExistingFile(this.modLoc("block/alchemy_table/alchemy_table_input_0")), partBuilder -> partBuilder.condition((Property)AlchemyTableBlock.HAS_BOTTLE_INPUT_0, (Comparable[])new Boolean[]{true}));
        this.applyHorizontalModel(alchemy_table, (ModelFile)this.models().getExistingFile(this.modLoc("block/alchemy_table/alchemy_table_input_1")), partBuilder -> partBuilder.condition((Property)AlchemyTableBlock.HAS_BOTTLE_INPUT_1, (Comparable[])new Boolean[]{true}));
        this.applyHorizontalModel(alchemy_table, (ModelFile)this.models().getExistingFile(this.modLoc("block/alchemy_table/alchemy_table_output_0")), partBuilder -> partBuilder.condition((Property)AlchemyTableBlock.HAS_BOTTLE_OUTPUT_0, (Comparable[])new Boolean[]{true}));
        this.applyHorizontalModel(alchemy_table, (ModelFile)this.models().getExistingFile(this.modLoc("block/alchemy_table/alchemy_table_output_1")), partBuilder -> partBuilder.condition((Property)AlchemyTableBlock.HAS_BOTTLE_OUTPUT_1, (Comparable[])new Boolean[]{true}));
    }

    private void createWoodStates() {
        this.simpleBlock((Block)ModBlocks.DARK_SPRUCE_PLANKS.get());
        this.simpleBlock((Block)ModBlocks.CURSED_SPRUCE_PLANKS.get());
        this.stairsBlock((StairBlock)ModBlocks.DARK_SPRUCE_STAIRS.get(), this.blockTexture((Block)ModBlocks.DARK_SPRUCE_PLANKS.get()));
        this.stairsBlock((StairBlock)ModBlocks.CURSED_SPRUCE_STAIRS.get(), this.blockTexture((Block)ModBlocks.CURSED_SPRUCE_PLANKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.DARK_SPRUCE_SLAB.get(), this.blockTexture((Block)ModBlocks.DARK_SPRUCE_PLANKS.get()), this.blockTexture((Block)ModBlocks.DARK_SPRUCE_PLANKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.CURSED_SPRUCE_SLAB.get(), this.blockTexture((Block)ModBlocks.CURSED_SPRUCE_PLANKS.get()), this.blockTexture((Block)ModBlocks.CURSED_SPRUCE_PLANKS.get()));
        this.fenceBlock((FenceBlock)ModBlocks.DARK_SPRUCE_FENCE.get(), this.blockTexture((Block)ModBlocks.DARK_SPRUCE_PLANKS.get()));
        this.fenceBlock((FenceBlock)ModBlocks.CURSED_SPRUCE_FENCE.get(), this.blockTexture((Block)ModBlocks.CURSED_SPRUCE_PLANKS.get()));
        ((BlockModelBuilder)this.models().withExistingParent("dark_spruce_fence_inventory", new ResourceLocation("block/fence_inventory"))).texture("texture", "block/dark_spruce_planks");
        ((BlockModelBuilder)this.models().withExistingParent("cursed_spruce_fence_inventory", new ResourceLocation("block/fence_inventory"))).texture("texture", "block/cursed_spruce_planks");
        this.fenceGateBlock((FenceGateBlock)ModBlocks.DARK_SPRUCE_FENCE_GATE.get(), this.blockTexture((Block)ModBlocks.DARK_SPRUCE_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)ModBlocks.CURSED_SPRUCE_FENCE_GATE.get(), this.blockTexture((Block)ModBlocks.CURSED_SPRUCE_PLANKS.get()));
        this.logBlock((RotatedPillarBlock)ModBlocks.DARK_SPRUCE_LOG.get());
        this.logBlock((RotatedPillarBlock)ModBlocks.CURSED_SPRUCE_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.DARK_SPRUCE_WOOD.get(), this.blockTexture((Block)ModBlocks.DARK_SPRUCE_LOG.get()), this.blockTexture((Block)ModBlocks.DARK_SPRUCE_LOG.get()));
        this.axisBlock((RotatedPillarBlock)ModBlocks.CURSED_SPRUCE_WOOD.get(), this.blockTexture((Block)ModBlocks.CURSED_SPRUCE_LOG.get()), this.blockTexture((Block)ModBlocks.CURSED_SPRUCE_LOG.get()));
        this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_DARK_SPRUCE_LOG.get());
        this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_CURSED_SPRUCE_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_DARK_SPRUCE_WOOD.get(), this.blockTexture((Block)ModBlocks.STRIPPED_DARK_SPRUCE_LOG.get()), this.blockTexture((Block)ModBlocks.STRIPPED_DARK_SPRUCE_LOG.get()));
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_CURSED_SPRUCE_WOOD.get(), this.blockTexture((Block)ModBlocks.STRIPPED_CURSED_SPRUCE_LOG.get()), this.blockTexture((Block)ModBlocks.STRIPPED_CURSED_SPRUCE_LOG.get()));
        this.button((Block)ModBlocks.DARK_SPRUCE_BUTTON.get(), this.blockTexture((Block)ModBlocks.DARK_SPRUCE_PLANKS.get()));
        this.button((Block)ModBlocks.CURSED_SPRUCE_BUTTON.get(), this.blockTexture((Block)ModBlocks.CURSED_SPRUCE_PLANKS.get()));
        this.pressurePlate((Block)ModBlocks.DARK_SPRUCE_PRESSURE_PLACE.get(), this.blockTexture((Block)ModBlocks.DARK_SPRUCE_PLANKS.get()));
        this.pressurePlate((Block)ModBlocks.CURSED_SPRUCE_PRESSURE_PLACE.get(), this.blockTexture((Block)ModBlocks.CURSED_SPRUCE_PLANKS.get()));
        this.simpleBlock((Block)ModBlocks.DARK_SPRUCE_WALL_SIGN.get(), (ModelFile)((BlockModelBuilder)this.models().getBuilder("vampirism:dark_spruce_wall_sign")).texture("particle", "vampirism:block/dark_spruce_planks"));
        this.simpleBlock((Block)ModBlocks.CURSED_SPRUCE_WALL_SIGN.get(), (ModelFile)((BlockModelBuilder)this.models().getBuilder("vampirism:cursed_spruce_wall_sign")).texture("particle", "vampirism:block/cursed_spruce_planks"));
        this.simpleBlock((Block)ModBlocks.DARK_SPRUCE_SIGN.get(), (ModelFile)((BlockModelBuilder)this.models().getBuilder("vampirism:dark_spruce_sign")).texture("particle", "vampirism:block/dark_spruce_planks"));
        this.simpleBlock((Block)ModBlocks.CURSED_SPRUCE_SIGN.get(), (ModelFile)((BlockModelBuilder)this.models().getBuilder("vampirism:cursed_spruce_sign")).texture("particle", "vampirism:block/cursed_spruce_planks"));
    }

    private void createCursedBark() {
        ModelFile.ExistingModelFile side = this.models().getExistingFile(new ResourceLocation("vampirism", "cursed_bark_side"));
        ModelFile.ExistingModelFile side2 = this.models().getExistingFile(new ResourceLocation("vampirism", "cursed_bark_side_2"));
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)ModBlocks.DIRECT_CURSED_BARK.get()).part().modelFile((ModelFile)side).rotationY(90).addModel()).condition(DirectCursedBarkBlock.EAST_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.VERTICAL}).end().part().modelFile((ModelFile)side).addModel()).condition(DirectCursedBarkBlock.NORTH_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.VERTICAL}).end().part().modelFile((ModelFile)side).rotationY(270).addModel()).condition(DirectCursedBarkBlock.WEST_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.VERTICAL}).end().part().modelFile((ModelFile)side).rotationY(180).addModel()).condition(DirectCursedBarkBlock.SOUTH_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.VERTICAL}).end().part().modelFile((ModelFile)side).rotationX(270).addModel()).condition(DirectCursedBarkBlock.UP_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.VERTICAL}).end().part().modelFile((ModelFile)side).rotationX(90).addModel()).condition(DirectCursedBarkBlock.DOWN_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.VERTICAL}).end().part().modelFile((ModelFile)side2).rotationY(90).addModel()).condition(DirectCursedBarkBlock.EAST_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.HORIZONTAL}).end().part().modelFile((ModelFile)side2).rotationX(180).rotationY(180).addModel()).condition(DirectCursedBarkBlock.NORTH_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.HORIZONTAL}).end().part().modelFile((ModelFile)side2).rotationY(270).addModel()).condition(DirectCursedBarkBlock.WEST_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.HORIZONTAL}).end().part().modelFile((ModelFile)side2).rotationY(180).addModel()).condition(DirectCursedBarkBlock.SOUTH_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.HORIZONTAL}).end().part().modelFile((ModelFile)side2).rotationX(270).addModel()).condition(DirectCursedBarkBlock.UP_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.HORIZONTAL}).end().part().modelFile((ModelFile)side2).rotationX(90).rotationY(180).addModel()).condition(DirectCursedBarkBlock.DOWN_TYPE, (Comparable[])new DirectCursedBarkBlock.Type[]{DirectCursedBarkBlock.Type.HORIZONTAL}).end();
        this.simpleBlock((Block)ModBlocks.DIAGONAL_CURSED_BARK.get(), (ModelFile)this.models().getBuilder("vampirism:cursed_bark_empty"));
    }

    private void button(Block block, @NotNull ResourceLocation texture) {
        ResourceLocation id = RegUtil.id(block);
        ModelBuilder button = ((BlockModelBuilder)this.models().withExistingParent("block/" + id.m_135815_(), new ResourceLocation("block/button"))).texture("texture", texture.m_135815_());
        ModelBuilder button_pressed = ((BlockModelBuilder)this.models().withExistingParent("block/" + id.m_135815_() + "_pressed", new ResourceLocation("block/button_pressed"))).texture("texture", texture.m_135815_());
        ModelBuilder button_inventory = ((BlockModelBuilder)this.models().withExistingParent("block/" + id.m_135815_() + "_inventory", new ResourceLocation("block/button_inventory"))).texture("texture", texture.m_135815_());
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).rotationY(270).rotationX(180).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).rotationY(270).rotationX(180).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).rotationY(180).rotationX(180).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).rotationY(180).rotationX(180).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).rotationX(180).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).rotationX(180).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).rotationY(90).rotationX(180).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.CEILING).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).rotationX(90).rotationX(180).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).rotationY(90).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).rotationY(90).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).rotationY(180).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).rotationY(180).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).rotationY(270).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.FLOOR).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).rotationX(270).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).rotationY(90).rotationX(90).uvLock(true).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.EAST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).rotationY(90).rotationX(90).uvLock(true).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).rotationX(90).uvLock(true).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.NORTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).rotationX(90).uvLock(true).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).rotationY(180).rotationX(90).uvLock(true).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.SOUTH).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).rotationY(180).rotationX(90).uvLock(true).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)button).rotationY(270).rotationX(90).uvLock(true).addModel()).partialState().with((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.WALL).with((Property)ButtonBlock.f_54117_, (Comparable)Direction.WEST).with((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)button_pressed).rotationY(270).rotationX(90).uvLock(true).addModel();
    }

    private void pressurePlate(Block block, @NotNull ResourceLocation texture) {
        ResourceLocation id = RegUtil.id(block);
        ModelBuilder pressure_plate = ((BlockModelBuilder)this.models().withExistingParent("block/" + id.m_135815_(), new ResourceLocation("block/pressure_plate_up"))).texture("texture", texture.m_135815_());
        ModelBuilder pressure_plate_down = ((BlockModelBuilder)this.models().withExistingParent("block/" + id.m_135815_() + "_down", new ResourceLocation("block/pressure_plate_down"))).texture("texture", texture.m_135815_());
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)pressure_plate).addModel()).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)pressure_plate_down).addModel();
    }

    @NotNull
    private MultiPartBlockStateBuilder applyHorizontalModel(@NotNull MultiPartBlockStateBuilder builder, ModelFile file) {
        return this.applyHorizontalModel(builder, file, partBuilder -> {});
    }

    @NotNull
    private MultiPartBlockStateBuilder applyHorizontalModel(@NotNull MultiPartBlockStateBuilder builder, ModelFile file, @NotNull Consumer<MultiPartBlockStateBuilder.PartBuilder> conditions) {
        MultiPartBlockStateBuilder.PartBuilder partBuilder = ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(file).rotationY(0).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH});
        conditions.accept(partBuilder);
        partBuilder.end();
        partBuilder = ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(file).rotationY(90).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST});
        conditions.accept(partBuilder);
        partBuilder.end();
        partBuilder = ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(file).rotationY(180).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH});
        conditions.accept(partBuilder);
        partBuilder.end();
        partBuilder = ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(file).rotationY(270).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST});
        conditions.accept(partBuilder);
        partBuilder.end();
        return builder;
    }

    @NotNull
    private MultiPartBlockStateBuilder getHorizontalMultiPartBlockStateBuilder(Block block, ModelFile file, @NotNull Consumer<MultiPartBlockStateBuilder.PartBuilder> conditions) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        MultiPartBlockStateBuilder.PartBuilder partBuilder = ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(file).rotationY(0).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH});
        conditions.accept(partBuilder);
        partBuilder.end();
        partBuilder = ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(file).rotationY(90).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.EAST});
        conditions.accept(partBuilder);
        partBuilder.end();
        partBuilder = ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(file).rotationY(180).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH});
        conditions.accept(partBuilder);
        partBuilder.end();
        partBuilder = ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(file).rotationY(270).addModel()).condition((Property)HunterTableBlock.FACING, (Comparable[])new Direction[]{Direction.WEST});
        conditions.accept(partBuilder);
        partBuilder.end();
        return builder;
    }

    private /* synthetic */ void lambda$registerStatesAndModels$3(ModelFile tentBR, ModelFile tentBL, ModelFile tentTL, ModelFile tentTR, ModelFile tentBackLeft, ModelFile tentBackRight, TentBlock t) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(t).part().modelFile(tentBR).rotationY(0).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{0}).end().part().modelFile(tentBR).rotationY(90).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{0}).end().part().modelFile(tentBR).rotationY(180).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{0}).end().part().modelFile(tentBR).rotationY(270).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{0}).end().part().modelFile(tentBL).rotationY(0).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{1}).end().part().modelFile(tentBL).rotationY(90).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{1}).end().part().modelFile(tentBL).rotationY(180).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{1}).end().part().modelFile(tentBL).rotationY(270).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{1}).end().part().modelFile(tentTL).rotationY(0).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{2}).end().part().modelFile(tentTL).rotationY(90).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{2}).end().part().modelFile(tentTL).rotationY(180).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{2}).end().part().modelFile(tentTL).rotationY(270).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{2}).end().part().modelFile(tentTR).rotationY(0).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{3}).end().part().modelFile(tentTR).rotationY(90).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{3}).end().part().modelFile(tentTR).rotationY(180).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{3}).end().part().modelFile(tentTR).rotationY(270).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{3}).end().part().modelFile(tentBackLeft).rotationY(180).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{2}).end().part().modelFile(tentBackLeft).rotationY(270).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{2}).end().part().modelFile(tentBackLeft).rotationY(0).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{2}).end().part().modelFile(tentBackLeft).rotationY(90).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{2}).end().part().modelFile(tentBackRight).rotationY(0).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{3}).end().part().modelFile(tentBackRight).rotationY(90).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{3}).end().part().modelFile(tentBackRight).rotationY(180).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{3}).end().part().modelFile(tentBackRight).rotationY(270).addModel()).condition((Property)TentBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)TentBlock.POSITION, (Comparable[])new Integer[]{3}).end();
    }
}

