/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.api.items.oil.IWeaponOil;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.blocks.CastleBricksBlock;
import de.teamlapen.vampirism.blocks.CastleSlabBlock;
import de.teamlapen.vampirism.blocks.CastleStairsBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.ai.goals.GolemTargetNonVillageFactionGoal;
import de.teamlapen.vampirism.entity.ai.goals.NearestTargetGoalModifier;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.items.VampirismVampireSwordItem;
import de.teamlapen.vampirism.items.oil.EvasionOil;
import de.teamlapen.vampirism.util.DifficultyCalculator;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.OilUtils;
import de.teamlapen.vampirism.util.TotemHelper;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ModEntityEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(ModEntityEventHandler.class);
    private static final Object2BooleanMap<String> entityAIReplacementWarnMap = new Object2BooleanArrayMap();
    private final Set<ResourceLocation> unknownZombies = new HashSet<ResourceLocation>();
    private boolean warnAboutGolem = true;

    public static <T extends Mob, S extends LivingEntity, Q extends NearestAttackableTargetGoal<S>> void makeVampireFriendly(String name, @NotNull T e, @NotNull Class<Q> targetClass, @NotNull Class<S> targetEntityClass, int attackPriority, @NotNull Predicate<EntityType<? extends T>> typeCheck) {
        Goal target = null;
        for (WrappedGoal t : e.f_21346_.f_25345_) {
            Goal g = t.m_26015_();
            if (!targetClass.equals(g.getClass()) || t.m_26012_() != attackPriority || !targetEntityClass.equals(((NearestAttackableTargetGoal)g).f_26048_)) continue;
            target = g;
            break;
        }
        if (target != null) {
            EntityType type = e.m_6095_();
            if (typeCheck.test(type)) {
                ((NearestTargetGoalModifier)target).ignoreVampires();
            }
        } else if (entityAIReplacementWarnMap.getOrDefault((Object)name, true)) {
            LOGGER.warn("Could not modify {} attack target task for {}", (Object)name, (Object)e.m_6095_().m_20676_());
            entityAIReplacementWarnMap.put((Object)name, false);
        }
    }

    @SubscribeEvent
    public void onAttachCapabilityEntity(@NotNull AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PathfinderMob) {
            event.addCapability(REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.createNewCapability((PathfinderMob)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onFinalizeSpawn(@NotNull MobSpawnEvent.FinalizeSpawn event) {
        BlockPos pos = new BlockPos((int)(event.getX() - (double)0.4f), (int)event.getY(), (int)(event.getZ() - (double)0.4f)).m_7495_();
        if (!event.getLevel().m_46805_(pos)) {
            return;
        }
        BlockState blockState = event.getLevel().m_8055_(pos);
        Block b = blockState.m_60734_();
        boolean deny = false;
        CastleBricksBlock.EnumVariant v = null;
        if (b instanceof CastleBricksBlock) {
            deny = true;
            v = ((CastleBricksBlock)b).getVariant();
        } else if (b instanceof CastleSlabBlock) {
            deny = true;
            v = ((CastleSlabBlock)b).getVariant();
        } else if (b instanceof CastleStairsBlock) {
            deny = true;
            v = ((CastleStairsBlock)b).getVariant();
        }
        if (deny && (v == CastleBricksBlock.EnumVariant.DARK_STONE || event.getEntity().getClassification(false) != VReference.VAMPIRE_CREATURE_TYPE)) {
            event.setSpawnCancelled(true);
        }
    }

    @SubscribeEvent
    public void onEntityEquipmentChange(@NotNull LivingEquipmentChangeEvent event) {
        if (event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR && event.getEntity() instanceof Player) {
            VampirePlayer.getOpt((Player)event.getEntity()).ifPresent(VampirePlayer::requestNaturalArmorUpdate);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(@NotNull EntityJoinLevelEvent event) {
        if (!event.getLevel().m_5776_()) {
            IAdjustableLevel entity;
            Entity entity2 = event.getEntity();
            if (entity2 instanceof IAdjustableLevel && (entity = (IAdjustableLevel)entity2).getEntityLevel() == -1) {
                Difficulty d = DifficultyCalculator.findDifficultyForPos(event.getLevel(), event.getEntity().m_20183_(), 30);
                int l = entity.suggestEntityLevel(d);
                if (l > entity.getMaxEntityLevel()) {
                    l = entity.getMaxEntityLevel();
                } else if (l < 0) {
                    event.setCanceled(true);
                }
                entity.setEntityLevel(l);
                if (entity instanceof PathfinderMob) {
                    ((PathfinderMob)entity).m_21153_(((PathfinderMob)entity).m_21233_());
                }
            }
            if (((Boolean)VampirismConfig.BALANCE.creeperIgnoreVampire.get()).booleanValue() && event.getEntity() instanceof Creeper) {
                ((Creeper)event.getEntity()).f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)((Creeper)event.getEntity()), Player.class, 20.0f, 1.1, 1.3, Helper::isVampire));
                ModEntityEventHandler.makeVampireFriendly("creeper", (Creeper)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 1, type -> type == EntityType.f_20558_);
                return;
            }
            if (((Boolean)VampirismConfig.BALANCE.zombieIgnoreVampire.get()).booleanValue() && event.getEntity() instanceof Zombie) {
                ModEntityEventHandler.makeVampireFriendly("zombie", (Zombie)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 2, type -> type == EntityType.f_20501_ || type == EntityType.f_20458_ || type == EntityType.f_20530_ || type == EntityType.f_20562_);
                ModEntityEventHandler.makeVampireFriendly("villager zombie", (Zombie)event.getEntity(), NearestAttackableTargetGoal.class, AbstractVillager.class, 3, type -> type == EntityType.f_20501_ || type == EntityType.f_20458_ || type == EntityType.f_20530_ || type == EntityType.f_20562_);
                return;
            }
            if (((Boolean)VampirismConfig.BALANCE.skeletonIgnoreVampire.get()).booleanValue() && (event.getEntity() instanceof Skeleton || event.getEntity() instanceof Stray)) {
                ModEntityEventHandler.makeVampireFriendly("skeleton", (AbstractSkeleton)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 2, type -> type == EntityType.f_20524_);
            }
            if (event.getEntity() instanceof IronGolem) {
                ((IronGolem)event.getEntity()).f_21346_.m_25352_(4, (Goal)new GolemTargetNonVillageFactionGoal((IronGolem)event.getEntity()));
                Goal mobTarget = null;
                for (WrappedGoal t2 : ((IronGolem)event.getEntity()).f_21346_.f_25345_) {
                    if (!(t2.m_26015_() instanceof NearestAttackableTargetGoal) || t2.m_26012_() != 3 || !Mob.class.equals((Object)((NearestAttackableTargetGoal)t2.m_26015_()).f_26048_)) continue;
                    mobTarget = t2.m_26015_();
                    break;
                }
                if (mobTarget != null) {
                    ((NearestTargetGoalModifier)mobTarget).ignoreFactionEntities();
                } else if (this.warnAboutGolem) {
                    LOGGER.warn("Could not replace villager iron golem target task");
                    this.warnAboutGolem = false;
                }
                return;
            }
            if (event.getEntity() instanceof Villager) {
                Optional<TotemBlockEntity> tile = TotemHelper.getTotemNearPos((ServerLevel)event.getLevel(), event.getEntity().m_20183_(), true);
                if (tile.filter(t -> VReference.HUNTER_FACTION.equals(t.getControllingFaction())).isPresent()) {
                    ExtendedCreature.getSafe(event.getEntity()).ifPresent(e -> e.setPoisonousBlood(true));
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public void onEntityLootingEvent(@NotNull LootingLevelEvent event) {
        IItemWithTier.TIER hunterCoatTier;
        if (event.getDamageSource() != null && event.getDamageSource().m_7639_() instanceof Player && ((hunterCoatTier = VampirismPlayerAttributes.get((Player)((Player)event.getDamageSource().m_7639_())).getHuntSpecial().fullHunterCoat) == IItemWithTier.TIER.ENHANCED || hunterCoatTier == IItemWithTier.TIER.ULTIMATE)) {
            event.setLootingLevel(Math.min(event.getLootingLevel() + 1, 3));
        }
    }

    @SubscribeEvent
    public void onEntityVisibilityCheck(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEvent.LivingVisibilityEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && VampirismPlayerAttributes.get(player = (Player)livingEntity).getHuntSpecial().isDisguised()) {
            event.modifyVisibility((VampirismPlayerAttributes.get((Player)((Player)event.getEntity())).getHuntSpecial().fullHunterCoat != null ? 0.5 : 1.0) * (Double)VampirismConfig.BALANCE.haDisguiseVisibilityMod.get());
        }
    }

    @SubscribeEvent
    public void onEyeHeightSet(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityEvent.Size event) {
        if (event.getEntity() instanceof VampireBaseEntity || event.getEntity() instanceof HunterBaseEntity) {
            event.setNewEyeHeight(event.getOldEyeHeight() * 0.875f);
        }
        if (event.getEntity() instanceof LivingEntity) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onItemUseFinish(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof MinionEntity && event.getItem().m_41720_() instanceof PotionItem) {
            ItemStack stack = event.getResultStack();
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                event.setResultStack(new ItemStack((ItemLike)Items.f_42590_));
                return;
            }
            ((MinionEntity)event.getEntity()).getInventory().ifPresent(inv -> inv.addItemStack(new ItemStack((ItemLike)Items.f_42590_)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingEquipmentChange(@NotNull LivingEquipmentChangeEvent event) {
        if (event.getTo().m_41720_() instanceof VampirismVampireSwordItem) {
            ((VampirismVampireSwordItem)event.getTo().m_41720_()).updateTrainedCached(event.getTo(), event.getEntity());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEvent.LivingTickEvent event) {
        if (event.getEntity() instanceof PathfinderMob) {
            event.getEntity().m_20193_().m_46473_().m_6180_("vampirism_extended_creature");
            ExtendedCreature.getSafe((Entity)event.getEntity()).ifPresent(IExtendedCreatureVampirism::tick);
            event.getEntity().m_20193_().m_46473_().m_7238_();
        }
    }

    @SubscribeEvent
    public void onStartAttackHit(AttackEntityEvent event) {
        if (!Helper.isHunter(event.getEntity()) && OilUtils.getAppliedOil(event.getEntity().m_21205_()).isPresent()) {
            event.setCanceled(true);
            event.getEntity().m_5661_((Component)Component.m_237115_((String)"text.vampirism.oils.cannot_use"), true);
        }
    }

    @SubscribeEvent
    public void onActuallyHurt(@NotNull LivingHurtEvent event) {
        Entity entity;
        if (event.getSource().m_276093_(DamageTypes.f_268464_) && (entity = event.getSource().m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = player.m_21205_();
            OilUtils.getAppliedOil(stack).ifPresent(oil -> {
                if (oil instanceof IWeaponOil) {
                    event.setAmount(event.getAmount() + ((IWeaponOil)oil).onHit(stack, event.getAmount(), (IWeaponOil)oil, event.getEntity(), (LivingEntity)player));
                    oil.reduceDuration(stack, (IApplicableOil)oil, oil.getDurationReduction());
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingDamage(@NotNull LivingDamageEvent event) {
        block2: {
            ItemStack armorStack;
            Entity entity;
            if (event.getSource().m_276093_(DamageTypes.f_268464_) && (entity = event.getSource().m_7639_()) instanceof Player) {
                Player player = (Player)entity;
                ItemStack stack = player.m_21205_();
                OilUtils.getAppliedOil(stack).ifPresent(oil -> {
                    if (oil instanceof IWeaponOil) {
                        event.setAmount(event.getAmount() + ((IWeaponOil)oil).onDamage(stack, event.getAmount(), (IWeaponOil)oil, event.getEntity(), (LivingEntity)player));
                    }
                });
            }
            if (!event.getSource().m_269533_(ModTags.DamageTypes.ENTITY_PHYSICAL) || event.getSource().m_269533_(DamageTypeTags.f_268490_)) break block2;
            Iterator iterator = event.getEntity().m_6168_().iterator();
            while (iterator.hasNext() && !OilUtils.getAppliedOil(armorStack = (ItemStack)iterator.next()).map(oil -> {
                EvasionOil evasionOil;
                if (oil instanceof EvasionOil && (evasionOil = (EvasionOil)oil).evasionChance() > Optional.ofNullable(event.getSource().m_7639_()).map(entity -> Float.valueOf(entity.m_9236_().f_46441_.m_188501_())).orElse(Float.valueOf(1.0f)).floatValue()) {
                    event.setAmount(0.0f);
                    oil.reduceDuration(armorStack, (IApplicableOil)oil, oil.getDurationReduction());
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) {
            }
        }
    }
}

