/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.api.entity.convertible.ICurableConvertedCreature;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.VampirismVillagerEntity;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.villager.Trades;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.TotemHelper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertedVillagerEntity
extends VampirismVillagerEntity
implements ICurableConvertedCreature<Villager> {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    public static final List<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES;
    private static final EntityDataAccessor<Boolean> CONVERTING;
    @NotNull
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean sundamageCache;
    private int bloodTimer = 0;
    private int conversionTime;
    @Nullable
    private UUID conversationStarter;

    public ConvertedVillagerEntity(EntityType<? extends ConvertedVillagerEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ConversionTime", this.isConverting((PathfinderMob)this) ? this.conversionTime : -1);
        if (this.conversationStarter != null) {
            compound.m_128362_("ConversionPlayer", this.conversationStarter);
        }
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.isConverting((PathfinderMob)this)) {
            --this.conversionTime;
            if (this.conversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20492_, timer -> {
                this.conversionTime = timer;
            })) {
                this.cureEntity((ServerLevel)this.m_9236_(), (PathfinderMob)this, (EntityType<Villager>)EntityType.f_20492_);
            }
        }
        if (this.f_19797_ % 40 == 1) {
            this.isGettingGarlicDamage((LevelAccessor)this.m_9236_(), true);
        }
        if (this.f_19797_ % 8 == 2) {
            this.isGettingSundamage((LevelAccessor)this.m_9236_(), true);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isGettingSundamage((LevelAccessor)this.m_9236_()) && this.f_19797_ % 40 == 11) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 42));
            }
            if (this.isGettingGarlicDamage((LevelAccessor)this.m_9236_()) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)this.m_9236_()), this.f_19797_);
            }
        }
        ++this.bloodTimer;
        super.m_8107_();
    }

    public Optional<BlockPos> getClosestVampireForest(Level level, BlockPos blockPos) {
        Optional<Object> optional;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            optional = TotemHelper.getTotemNearPos(serverLevel, blockPos, true).flatMap(TotemBlockEntity::getVampireForestLocation);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    @NotNull
    public Villager cureEntity(@NotNull ServerLevel world, @NotNull PathfinderMob entity, @NotNull EntityType<Villager> newType) {
        Player playerentity;
        Villager villager = ICurableConvertedCreature.super.cureEntity(world, entity, newType);
        villager.m_34375_(this.m_7141_());
        villager.m_35455_((Tag)this.m_35517_().m_262795_((DynamicOps)NbtOps.f_128958_));
        villager.m_35476_(this.m_6616_());
        villager.m_35546_(this.m_7809_());
        if (this.conversationStarter != null && (playerentity = world.m_46003_(this.conversationStarter)) instanceof ServerPlayer) {
            ModAdvancements.TRIGGER_CURED_VAMPIRE_VILLAGER.trigger((ServerPlayer)playerentity, (Entity)this, villager);
            world.m_8670_(ReputationEventType.f_26985_, (Entity)playerentity, (ReputationEventHandler)villager);
        }
        return villager;
    }

    @Override
    public boolean m_7327_(@NotNull Entity entity) {
        if (!this.m_9236_().f_46443_ && this.wantsBlood() && entity instanceof Player && !Helper.isHunter(entity) && !UtilLib.canReallySee((LivingEntity)entity, (LivingEntity)this, true)) {
            int amt = VampirePlayer.getOpt((Player)entity).map(vampire -> vampire.onBite(this)).orElse(0);
            this.drinkBlood(amt, 0.7f);
            return true;
        }
        return super.m_7327_(entity);
    }

    @Override
    public EntityDataAccessor<Boolean> getConvertingDataParam() {
        return CONVERTING;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, amt * 20));
        this.bloodTimer = -1200 - this.f_19796_.m_188503_(1200);
    }

    @Override
    @NotNull
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @NotNull
    protected Component m_5677_() {
        ResourceLocation profName = RegUtil.id(this.m_7141_().m_35571_());
        return Component.m_237115_((String)(EntityType.f_20492_.m_20675_() + "." + (String)(!"minecraft".equals(profName.m_135827_()) ? profName.m_135827_() + "." : "") + profName.m_135815_()));
    }

    public void m_7822_(byte id) {
        if (!this.handleSound(id, (PathfinderMob)this)) {
            super.m_7822_(id);
        }
    }

    @Override
    @NotNull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.m_9236_().m_46473_());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42436_) {
            return this.interactWithCureItem(player, stack, (PathfinderMob)this);
        }
        return super.m_6071_(player, hand);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("ConversionTime", 99) && compound.m_128451_("ConversionTime") > -1) {
            this.startConverting(compound.m_128403_("ConversionPlayer") ? compound.m_128342_("ConversionPlayer") : null, compound.m_128451_("ConversionTime"), (PathfinderMob)this);
        }
    }

    @Override
    public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @NotNull PathfinderMob entity) {
        ICurableConvertedCreature.super.startConverting(conversionStarterIn, conversionTimeIn, entity);
        this.conversationStarter = conversionStarterIn;
        this.conversionTime = conversionTimeIn;
    }

    public void m_35424_(@NotNull Brain<Villager> brain) {
        super.m_35424_(brain);
        if (!this.m_6162_()) {
            brain.m_21912_((Schedule)ModVillage.CONVERTED_DEFAULT.get());
            brain.m_21862_(this.m_9236_().m_46468_(), this.m_9236_().m_46467_());
        }
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodTimer > 0;
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, amt * 20));
        this.bloodTimer = 0;
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerConvertingData((PathfinderMob)this);
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> dynamicIn) {
        Brain brain = Brain.m_21923_((Collection)f_35367_, SENSOR_TYPES).m_22073_(dynamicIn);
        this.m_35424_((Brain<Villager>)brain);
        return brain;
    }

    protected void m_7604_() {
        super.m_7604_();
        if (!this.m_6616_().isEmpty() && this.m_217043_().m_188503_(3) == 0) {
            this.m_35277_(this.m_6616_(), Trades.converted_trades, 1);
        }
    }

    static {
        CONVERTING = SynchedEntityData.m_135353_(ConvertedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SENSOR_TYPES = Lists.newArrayList((Iterable)Villager.f_35368_);
        SENSOR_TYPES.remove(SensorType.f_26815_);
        SENSOR_TYPES.add((SensorType<? extends Sensor<? super Villager>>)((SensorType)ModVillage.VAMPIRE_VILLAGER_HOSTILES.get()));
    }

    public static class ConvertingHandler
    implements IConvertingHandler<Villager> {
        @Override
        public IConvertedCreature<Villager> createFrom(@NotNull Villager entity) {
            CompoundTag nbt = new CompoundTag();
            entity.m_20240_(nbt);
            ConvertedVillagerEntity converted = (ConvertedVillagerEntity)((EntityType)ModEntities.VILLAGER_CONVERTED.get()).m_20615_(entity.m_9236_());
            converted.m_20258_(nbt);
            converted.m_20084_(Mth.m_216261_((RandomSource)converted.f_19796_));
            converted.f_20883_ = entity.f_20883_;
            converted.f_20885_ = entity.f_20885_;
            return converted;
        }
    }
}

