/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.ICurableConvertedCreature;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.ConvertedCreature;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CurableConvertedCreature<T extends PathfinderMob, Z extends PathfinderMob>
extends ConvertedCreature<T>,
ICurableConvertedCreature<T> {
    public Data<T> data();

    default public boolean hurtC(DamageSource damageSource, float amount) {
        PathfinderMob entity = (PathfinderMob)this;
        if (this.data().vulnerableToFire) {
            if (damageSource.m_276093_(DamageTypes.f_268631_)) {
                return DamageHandler.hurtModded((Entity)entity, ModDamageSources::vampireInFire, this.calculateFireDamage(amount));
            }
            if (damageSource.m_276093_(DamageTypes.f_268468_)) {
                return DamageHandler.hurtModded((Entity)entity, ModDamageSources::vampireOnFire, this.calculateFireDamage(amount));
            }
        }
        return this.hurtSuper(damageSource, amount);
    }

    default public InteractionResult mobInteractC(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42436_) {
            return this.interactWithCureItem(player, stack, (PathfinderMob)this);
        }
        return this.mobInteractSuper(player, hand);
    }

    @Override
    default public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        ((PathfinderMob)this).m_7292_(new MobEffectInstance(MobEffects.f_19605_, amt * 20));
    }

    @Nullable
    default public Component getNameC(@NotNull Supplier<Component> baseName) {
        if (this.data().name == null) {
            this.data().name = Component.m_237115_((String)"entity.vampirism.vampire").m_7220_(baseName.get());
        }
        return this.data().name;
    }

    default public void handleEntityEventC(byte id) {
        if (!this.handleSound(id, (PathfinderMob)this)) {
            this.handleEntityEventSuper(id);
        }
    }

    @Override
    default public boolean doesResistGarlic(@NotNull EnumStrength strength) {
        return !strength.isStrongerThan(EnumStrength.NONE);
    }

    @Override
    @NotNull
    default public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.data().garlicCache = Helper.getGarlicStrength((Entity)((PathfinderMob)this), iWorld);
        }
        return this.data().garlicCache;
    }

    @Override
    default public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.data().sundamageCache;
        }
        this.data().sundamageCache = Helper.gettingSundamge((LivingEntity)((PathfinderMob)this), iWorld, ((PathfinderMob)this).m_9236_().m_46473_());
        return this.data().sundamageCache;
    }

    @Override
    default public boolean isIgnoringSundamage() {
        return ((PathfinderMob)this).m_21023_((MobEffect)ModEffects.SUNSCREEN.get());
    }

    default public void aiStepC(@NotNull EntityType<T> originalType) {
        PathfinderMob entity = (PathfinderMob)this;
        if (!entity.m_9236_().f_46443_ && entity.m_6084_() && this.isConverting(entity)) {
            --this.data().conversionTime;
            if (this.data().conversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)entity, originalType, timer -> {
                this.data().conversionTime = timer;
            })) {
                this.cureEntity((ServerLevel)entity.m_9236_(), entity, originalType);
            }
        }
        if (entity.f_19797_ % 40 == 1) {
            this.isGettingGarlicDamage((LevelAccessor)entity.m_9236_(), true);
        }
        if (entity.f_19797_ % 8 == 2) {
            this.isGettingSundamage((LevelAccessor)entity.m_9236_(), true);
        }
        if (!entity.m_9236_().f_46443_) {
            double dmg;
            if (this.isGettingSundamage((LevelAccessor)entity.m_9236_()) && entity.f_19797_ % 40 == 11 && (dmg = entity.m_21051_((Attribute)ModAttributes.SUNDAMAGE.get()).m_22135_()) > 0.0) {
                DamageHandler.hurtModded((Entity)entity, ModDamageSources::sunDamage, (float)dmg);
            }
            if (this.isGettingGarlicDamage((LevelAccessor)entity.m_9236_()) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)entity.m_9236_()), entity.f_19797_);
            }
            if (entity.m_6084_() && entity.m_20069_()) {
                entity.m_20301_(300);
                if (entity.f_19797_ % 16 == 4) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, 0));
                }
            }
        }
    }

    default public void dieC(@NotNull DamageSource cause) {
        if (cause.m_7640_() instanceof CrossbowArrowEntity && Helper.isHunter(cause.m_7639_())) {
            this.data().dropSoul = true;
        } else if (cause.m_7640_() instanceof Player && Helper.isHunter(cause.m_7640_())) {
            ItemStack weapon = ((Player)cause.m_7640_()).m_21205_();
            if (!weapon.m_41619_() && weapon.m_41720_() instanceof IVampireFinisher) {
                this.data().dropSoul = true;
            }
        } else {
            this.data().dropSoul = false;
        }
    }

    default public void readAdditionalSaveDataC(@NotNull CompoundTag compound) {
        if (compound.m_128425_("ConversionTime", 99) && compound.m_128451_("ConversionTime") > -1) {
            this.startConverting(compound.m_128403_("ConversionPlayer") ? compound.m_128342_("ConversionPlayer") : null, compound.m_128451_("ConversionTime"), (PathfinderMob)this);
        }
    }

    default public void addAdditionalSaveDataC(@NotNull CompoundTag compound) {
        compound.m_128405_("ConversionTime", this.isConverting((PathfinderMob)this) ? this.data().conversionTime : -1);
        if (this.data().conversationStarter != null) {
            compound.m_128362_("ConversionPlayer", this.data().conversationStarter);
        }
    }

    @Override
    default public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @NotNull PathfinderMob entity) {
        ICurableConvertedCreature.super.startConverting(conversionStarterIn, conversionTimeIn, entity);
        this.data().conversationStarter = conversionStarterIn;
        this.data().conversionTime = conversionTimeIn;
    }

    @Override
    default public boolean useBlood(int amt, boolean allowPartial) {
        ((PathfinderMob)this).m_7292_(new MobEffectInstance(MobEffects.f_19613_, amt * 20));
        return true;
    }

    @Override
    default public boolean wantsBlood() {
        return false;
    }

    default public float calculateFireDamage(float amount) {
        return amount;
    }

    default public void tickDeathC() {
        PathfinderMob entity = (PathfinderMob)this;
        if (entity.f_20919_ == 19 && !entity.m_9236_().f_46443_ && this.data().dropSoul && entity.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            entity.m_9236_().m_7967_((Entity)new SoulOrbEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoulOrbEntity.VARIANT.VAMPIRE));
        }
    }

    default public void registerGoalsC() {
        PathfinderMob entity = (PathfinderMob)this;
        entity.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal(entity, PathfinderMob.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION)));
        entity.f_21345_.m_25352_(4, (Goal)new RestrictSunGoal(entity));
        entity.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(entity, new Class[0]));
        entity.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)entity, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        entity.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)entity, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, false, false, false, null)));
    }

    @Override
    @NotNull
    default public LivingEntity getRepresentingEntity() {
        return (PathfinderMob)this;
    }

    public void handleEntityEventSuper(byte var1);

    public InteractionResult mobInteractSuper(@NotNull Player var1, @NotNull InteractionHand var2);

    public boolean hurtSuper(DamageSource var1, float var2);

    public static <T extends PathfinderMob, Z extends PathfinderMob> void createFrom() {
    }

    public static class Data<T> {
        public boolean vulnerableToFire = true;
        @NotNull
        public EnumStrength garlicCache = EnumStrength.NONE;
        public T entityCreature;
        public boolean sundamageCache;
        public boolean dropSoul = false;
        @Nullable
        public Component name;
        public int conversionTime;
        @Nullable
        public UUID conversationStarter;
    }
}

