/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.entity.converted.BiteableEntryManager;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampirismEntityRegistry
implements IVampirismEntityRegistry {
    @NotNull
    public static final BiteableEntryManager biteableEntryManager = new BiteableEntryManager();
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private final Map<EntityType<? extends PathfinderMob>, IConvertingHandler<?>> convertibles = new ConcurrentHashMap();
    @NotNull
    private final Map<EntityType<? extends PathfinderMob>, ResourceLocation> convertibleOverlay = new ConcurrentHashMap<EntityType<? extends PathfinderMob>, ResourceLocation>();
    private final Map<Class<? extends PathfinderMob>, Function<? extends PathfinderMob, IExtendedCreatureVampirism>> extendedCreatureConstructors = new ConcurrentHashMap<Class<? extends PathfinderMob>, Function<? extends PathfinderMob, IExtendedCreatureVampirism>>();
    private Function<IConvertingHandler.IDefaultHelper, IConvertingHandler<?>> defaultConvertingHandlerCreator;
    private boolean finished = false;

    @Override
    public void addConvertible(EntityType<? extends PathfinderMob> type, ResourceLocation overlayLocation) {
        this.addConvertible(type, overlayLocation, new DefaultConvertingHandler(null));
    }

    @Override
    public void addConvertible(EntityType<? extends PathfinderMob> type, ResourceLocation overlay_loc, IConvertingHandler.IDefaultHelper helper) {
        this.addConvertible(type, overlay_loc, this.defaultConvertingHandlerCreator.apply(helper));
    }

    @Override
    public void addConvertible(EntityType<? extends PathfinderMob> type, @Nullable ResourceLocation overlay_loc, @NotNull IConvertingHandler<?> handler) {
        if (this.finished) {
            throw new IllegalStateException("Register convertibles during InterModEnqueueEvent");
        }
        this.convertibles.put(type, handler);
        if (FMLEnvironment.dist.isClient() && overlay_loc != null) {
            this.convertibleOverlay.put(type, overlay_loc);
        }
    }

    @Override
    public <T extends PathfinderMob> void addCustomExtendedCreature(Class<? extends T> clazz, Function<T, IExtendedCreatureVampirism> constructor) {
        if (this.finished) {
            throw new IllegalStateException("Register extended creatures during InterModEnqueueEvent");
        }
        this.extendedCreatureConstructors.put(clazz, constructor);
    }

    public void applyNewResources(@NotNull Map<ResourceLocation, Float> valuesIn) {
        HashMap values = Maps.newHashMap(valuesIn);
        HashMap biteables = Maps.newHashMap();
        HashSet blacklist = Sets.newHashSet();
        IConvertingHandler<?> defaultHandler = this.defaultConvertingHandlerCreator.apply(null);
        for (Map.Entry<EntityType<PathfinderMob>, IConvertingHandler<?>> entry : this.convertibles.entrySet()) {
            ResourceLocation id = RegUtil.id(entry.getKey());
            if (id == null) {
                LOGGER.warn("Cannot register convertible {} since there is no EntityString for it", entry.getKey());
                continue;
            }
            Float bloodF = (Float)values.remove(id);
            if (bloodF == null) {
                LOGGER.warn("Missing blood value for convertible creature {} ({})", (Object)entry.getKey().m_20676_(), (Object)id);
                continue;
            }
            int blood = Math.round(bloodF.floatValue());
            LOGGER.debug("Registering convertible {} with blood {} and handler {}", (Object)entry.getKey().m_20676_().getString(), (Object)blood, (Object)entry.getValue().getClass().getName());
            BiteableEntry biteEntry = new BiteableEntry(blood, entry.getValue() == null ? defaultHandler : entry.getValue());
            biteables.put(id, biteEntry);
        }
        LOGGER.info("Registered {} convertibles", (Object)biteables.size());
        for (Map.Entry<Object, IConvertingHandler<Object>> entry : values.entrySet()) {
            if (!RegUtil.has(ForgeRegistries.ENTITY_TYPES, (ResourceLocation)entry.getKey())) continue;
            int blood = Math.abs(Math.round(((Float)((Object)entry.getValue())).floatValue()));
            if (blood == 0) {
                blacklist.add((ResourceLocation)entry.getKey());
                continue;
            }
            biteables.put((ResourceLocation)entry.getKey(), new BiteableEntry(blood));
        }
        biteableEntryManager.setNewBiteables(biteables, blacklist);
    }

    @Override
    @Nullable
    public IConvertedCreature<?> convert(@NotNull PathfinderMob entity) {
        BiteableEntry b = biteableEntryManager.get(entity);
        if (b != null && b.convertingHandler != null) {
            return b.convertingHandler.createFrom(entity);
        }
        LOGGER.warn("Failed to find convertible entry for {}", (Object)entity);
        return null;
    }

    public void finishRegistration() {
        this.finished = true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Map<EntityType<? extends PathfinderMob>, ResourceLocation> getConvertibleOverlay() {
        return this.convertibleOverlay;
    }

    @Override
    @Nullable
    public <T extends PathfinderMob> Function<T, IExtendedCreatureVampirism> getCustomExtendedCreatureConstructor(@NotNull T entity) {
        return this.extendedCreatureConstructors.get(entity.getClass());
    }

    @Override
    @Nullable
    public BiteableEntry getEntry(@NotNull PathfinderMob creature) {
        return biteableEntryManager.get(creature);
    }

    @Override
    @Nullable
    public BiteableEntry getOrCreateEntry(PathfinderMob creature) {
        return biteableEntryManager.getOrCalculate(creature);
    }

    @ApiStatus.Internal
    public VampirismEntityRegistry setDefaultConvertingHandlerCreator(Function<IConvertingHandler.IDefaultHelper, IConvertingHandler<?>> creator) {
        this.defaultConvertingHandlerCreator = creator;
        return this;
    }
}

