/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.hunter.IBasicHunter;
import de.teamlapen.vampirism.api.entity.hunter.IVampirismCrossbowUser;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.ai.goals.AttackRangedCrossbowGoal;
import de.teamlapen.vampirism.entity.ai.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.inventory.HunterBasicMenu;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import de.teamlapen.vampirism.util.HunterVillage;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicHunterEntity
extends HunterBaseEntity
implements IBasicHunter,
ForceLookEntityGoal.TaskOwner,
IVampirismCrossbowUser,
IEntityActionUser {
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(BasicHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WATCHED_ID = SynchedEntityData.m_135353_(BasicHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(BasicHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(BasicHunterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component name = Component.m_237115_((String)"container.hunter");
    private final int MAX_LEVEL = 3;
    @NotNull
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    @NotNull
    private final EntityActionTier entitytier;
    @Nullable
    private Player trainee;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private boolean attack;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampirismEntity.getAttributeBuilder().m_22268_(Attributes.f_22276_, (double)BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder.m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, BalanceMobProps.mobProps.VAMPIRE_HUNTER_SPEED);
    }

    public BasicHunterEntity(EntityType<? extends BasicHunterEntity> type, Level world) {
        super(type, world, true);
        this.saveHome = true;
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.setDontDropEquipment();
        this.entitytier = EntityActionTier.Medium;
        this.entityclass = EntityClassType.getRandomClass(this.m_217043_());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<BasicHunterEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("level", this.getEntityLevel());
        nbt.m_128379_("crossbow", this.isHoldingCrossbow());
        nbt.m_128379_("attack", this.attack);
        nbt.m_128405_("type", this.getEntityTextureType());
        nbt.m_128405_("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
    }

    @Override
    public void attackVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = true;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.trainee != null && !(this.trainee.f_36096_ instanceof HunterBasicMenu)) {
            this.trainee = null;
        }
        if (!this.m_9236_().f_46443_) {
            LivingEntity target = this.m_5448_();
            int id = target == null ? 0 : target.m_19879_();
            this.updateWatchedId(id);
            if (this.f_19797_ % 512 == 0 && this.m_217043_().m_188503_(500) == 0) {
                BlockPos randomDestination = new BlockPos(this.m_217043_().m_188503_(30000) - 15000, 100, this.m_217043_().m_188503_(30000) - 15000);
                randomDestination = this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomDestination);
                this.setHomeArea(randomDestination, 10);
            }
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    public void convertToMinion(@NotNull Player lord) {
        FactionPlayerHandler.getOpt(lord).ifPresent(fph -> {
            if (fph.getMaxMinions() > 0) {
                MinionWorldData.getData(lord.m_9236_()).map(w -> w.getOrCreateController((FactionPlayerHandler)fph)).ifPresent(controller -> {
                    if (controller.hasFreeMinionSlot()) {
                        if (fph.getCurrentFaction() == this.getFaction()) {
                            boolean hasIncreasedStats = fph.getCurrentFactionPlayer().map(s -> s.getSkillHandler().isSkillEnabled((ISkill)HunterSkills.MINION_STATS_INCREASE.get())).orElse(false);
                            HunterMinionEntity.HunterMinionData data = new HunterMinionEntity.HunterMinionData("Minion", this.getEntityTextureType(), this.getEntityTextureType() % 4, false, hasIncreasedStats);
                            data.updateEntityCaps(this.serializeCaps());
                            int id = controller.createNewMinionSlot(data, (EntityType)ModEntities.HUNTER_MINION.get());
                            if (id < 0) {
                                LOGGER.error("Failed to get minion slot");
                                return;
                            }
                            HunterMinionEntity minion = (HunterMinionEntity)((EntityType)ModEntities.HUNTER_MINION.get()).m_20615_(this.m_9236_());
                            minion.claimMinionSlot(id, (PlayerMinionController)controller);
                            minion.m_20359_((Entity)this);
                            minion.markAsConverted();
                            controller.activateTask(0, (IMinionTask)MinionTasks.STAY.get());
                            UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)minion);
                        } else {
                            LOGGER.warn("Wrong faction for minion");
                        }
                    } else {
                        LOGGER.warn("No free slot");
                    }
                });
            } else {
                LOGGER.error("Can't have minions");
            }
        });
    }

    @Override
    public void defendVillage(ICaptureAttributes attributes) {
        this.villageAttributes = attributes;
        this.attack = false;
    }

    @Override
    public ActionHandlerEntity<?> getActionHandler() {
        return this.entityActionHandler;
    }

    @Override
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public void m_6667_(@NotNull DamageSource cause) {
        if (this.villageAttributes == null) {
            BadOmenEffect.handlePotentialBannerKill(cause.m_7639_(), this);
        }
        super.m_6667_(cause);
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    @NotNull
    public Optional<Player> getForceLookTarget() {
        return Optional.ofNullable(this.trainee);
    }

    public boolean m_7327_(@NotNull Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag && this.m_21205_().m_41619_()) {
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
        return flag;
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason != MobSpawnType.SPAWN_EGG && reason != MobSpawnType.BUCKET && reason != MobSpawnType.CONVERSION && reason != MobSpawnType.COMMAND && this.m_217043_().m_188503_(50) == 0) {
            this.m_8061_(EquipmentSlot.HEAD, HunterVillage.createBanner());
        }
        this.m_20088_().m_135381_(TYPE, (Object)this.m_217043_().m_188503_(126));
        SpawnGroupData livingData = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (this.m_217043_().m_188503_(4) == 0) {
            this.m_21559_(true);
            Item crossBow = this.getEntityLevel() > 1 ? (Item)ModItems.ENHANCED_CROSSBOW.get() : (Item)ModItems.BASIC_CROSSBOW.get();
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)crossBow));
        } else {
            this.m_21559_(false);
        }
        return livingData;
    }

    @Override
    public int getMaxEntityLevel() {
        return 3;
    }

    @Override
    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public int getEntityTextureType() {
        return Math.max(0, (Integer)this.m_20088_().m_135370_(TYPE));
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public boolean isLookingForHome() {
        return this.getHome() == null;
    }

    @Override
    public int getEntityLevel() {
        return (Integer)this.m_20088_().m_135370_(LEVEL);
    }

    @Override
    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.m_20088_().m_135381_(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 3) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1000000, 1));
            }
        }
    }

    @Override
    public void makeNormalHunter() {
        super.setHome(null);
        this.disableMoveTowardsRestriction();
    }

    @Override
    public void makeVillageHunter(AABB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tagCompund) {
        super.m_7378_(tagCompund);
        if (tagCompund.m_128441_("level")) {
            this.setEntityLevel(tagCompund.m_128451_("level"));
        }
        if (tagCompund.m_128441_("crossbow") && tagCompund.m_128471_("crossbow")) {
            this.m_21559_(true);
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.BASIC_CROSSBOW.get()));
        } else {
            this.m_21559_(false);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        if (tagCompund.m_128441_("attack")) {
            this.attack = tagCompund.m_128471_("attack");
        }
        if (tagCompund.m_128441_("type")) {
            int t = tagCompund.m_128451_("type");
            this.m_20088_().m_135381_(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
    }

    @Override
    public void stopVillageAttackDefense() {
        this.m_6593_(null);
        this.villageAttributes = null;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return super.m_6785_(distanceToClosestPlayer) && this.getHome() != null;
    }

    @Override
    public int suggestEntityLevel(@NotNull Difficulty d) {
        return switch (this.f_19796_.m_188503_(6)) {
            case 0 -> (int)((float)d.minPercLevel / 100.0f * 3.0f);
            case 1 -> (int)((float)d.avgPercLevel / 100.0f * 3.0f);
            case 2 -> (int)((float)d.maxPercLevel / 100.0f * 3.0f);
            default -> this.f_19796_.m_188503_(4);
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(LEVEL, (Object)-1);
        this.m_20088_().m_135372_(WATCHED_ID, (Object)0);
        this.m_20088_().m_135372_(TYPE, (Object)-1);
        this.m_20088_().m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    public int m_213860_() {
        return 6 + this.getEntityLevel();
    }

    @Override
    @NotNull
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? (EntityType)ModEntities.HUNTER_IMOB.get() : (EntityType)ModEntities.HUNTER.get();
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.tryCureSanguinare(player)) {
            return InteractionResult.SUCCESS;
        }
        int hunterLevel = VampirismPlayerAttributes.get((Player)player).hunterLevel;
        if (this.m_6084_() && !player.m_6144_() && hand == InteractionHand.MAIN_HAND && !this.m_9236_().f_46443_) {
            if (HunterLevelingConf.instance().isLevelValidForBasicHunter(hunterLevel + 1)) {
                if (this.trainee == null) {
                    player.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new HunterBasicMenu(id, playerInventory, this), name));
                    this.trainee = player;
                    this.m_21573_().m_26573_();
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"text.vampirism.i_am_busy_right_now"));
                }
                return InteractionResult.SUCCESS;
            }
            if (hunterLevel > 0) {
                FactionPlayerHandler.getOpt(player).ifPresent(fph -> {
                    if (fph.getMaxMinions() > 0) {
                        ItemStack heldItem = player.m_21120_(hand);
                        if (this.getEntityLevel() > 0) {
                            if (heldItem.m_41720_() == ModItems.HUNTER_MINION_EQUIPMENT.get()) {
                                player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.basic_hunter.minion.unavailable"), true);
                            }
                        } else {
                            boolean freeSlot = MinionWorldData.getData(player.m_9236_()).map(data -> data.getOrCreateController((FactionPlayerHandler)fph)).map(PlayerMinionController::hasFreeMinionSlot).orElse(false);
                            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.basic_hunter.minion.available"), false);
                            if (heldItem.m_41720_() == ModItems.HUNTER_MINION_EQUIPMENT.get()) {
                                if (!freeSlot) {
                                    player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.basic_hunter.minion.no_free_slot"), false);
                                } else {
                                    player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.basic_hunter.minion.start_serving"), false);
                                    this.convertToMinion(player);
                                    if (!player.m_150110_().f_35937_) {
                                        heldItem.m_41774_(1);
                                    }
                                }
                            } else if (freeSlot) {
                                player.m_5661_((Component)Component.m_237110_((String)"text.vampirism.basic_hunter.minion.require_equipment", (Object[])new Object[]{UtilLib.translate(((Item)ModItems.HUNTER_MINION_EQUIPMENT.get()).m_5524_(), new Object[0])}), false);
                            }
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.basic_hunter.cannot_train_you_any_further"), false);
                    }
                });
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_6136_(boolean p_213671_1_) {
        this.m_20088_().m_135381_(IS_CHARGING_CROSSBOW, (Object)p_213671_1_);
    }

    public void m_5811_(@NotNull LivingEntity p_230284_1_, @NotNull ItemStack p_230284_2_, @NotNull Projectile p_230284_3_, float p_230284_4_) {
        this.m_32322_((LivingEntity)this, p_230284_1_, p_230284_3_, p_230284_4_, 1.6f);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_6504_(@NotNull LivingEntity p_82196_1_, float p_82196_2_) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }

    @Override
    public boolean isHoldingCrossbow() {
        return this.m_21093_(stack -> stack.m_41720_() instanceof IVampirismCrossbow);
    }

    @Override
    public boolean isChargingCrossbow() {
        return (Boolean)this.m_20088_().m_135370_(IS_CHARGING_CROSSBOW);
    }

    @Nonnull
    public ItemStack m_6298_(ItemStack stack) {
        if (stack.m_41720_() instanceof IVampirismCrossbow) {
            return ((CrossbowArrowItem)ModItems.CROSSBOW_ARROW_NORMAL.get()).m_7968_();
        }
        return ItemStack.f_41583_;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(3, new ForceLookEntityGoal<BasicHunterEntity>(this));
        this.f_21345_.m_25352_(3, new AttackRangedCrossbowGoal<BasicHunterEntity>(this, 0.6, 60.0f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, (double)0.7f, false, 300, () -> false));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7, 50));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 13.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, VampireBaseEntity.class, 17.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AttackVillageGoal<BasicHunterEntity>(this));
        this.f_21346_.m_25352_(2, new DefendVillageGoal<BasicHunterEntity>(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<PathfinderMob>((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)){

            protected double m_7623_() {
                return super.m_7623_() / 2.0;
            }
        });
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true, true));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, PatrollingMonster.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, (TagKey<Structure>)StructureTags.f_215889_)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getEntityLevel(), 0);
        this.m_21051_(Attributes.f_22276_).m_22100_((double)BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION + BalanceMobProps.mobProps.VAMPIRE_HUNTER_MAX_HEALTH_PL * (double)l);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22281_);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.m_22100_(3.0 + BalanceMobProps.mobProps.VAMPIRE_HUNTER_ATTACK_DAMAGE_PL * (double)l);
        this.m_21051_(Attributes.f_22279_).m_22100_(BalanceMobProps.mobProps.VAMPIRE_HUNTER_SPEED);
    }

    private int getWatchedId() {
        return (Integer)this.m_20088_().m_135370_(WATCHED_ID);
    }

    private void updateWatchedId(int id) {
        this.m_20088_().m_135381_(WATCHED_ID, (Object)id);
    }

    public static class IMob
    extends BasicHunterEntity
    implements Enemy {
        public IMob(EntityType<? extends BasicHunterEntity> type, Level world) {
            super(type, world);
        }
    }
}

