/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IFactionSlayerItem;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.blocks.AltarInspirationBlock;
import de.teamlapen.vampirism.blocks.BloodContainerBlock;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.VampirismPotion;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.BatVampireAction;
import de.teamlapen.vampirism.items.GarlicBreadItem;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.TotemHelper;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ModPlayerEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(ModPlayerEventHandler.class);

    @SubscribeEvent
    public void blockDestroyed(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEvent.BreakEvent event) {
        BlockEntity totem;
        if (!(event.getLevel() instanceof Level)) {
            return;
        }
        if (event.getPlayer().m_7500_()) {
            return;
        }
        if (((Boolean)VampirismConfig.SERVER.allowVillageDestroyBlocks.get()).booleanValue()) {
            return;
        }
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        BlockPos totemPos = TotemHelper.getTotemPosition((ResourceKey<Level>)((Level)event.getLevel()).m_46472_(), event.getPos());
        Block block = event.getState().m_60734_();
        ImmutableList validStates = block.m_49965_().m_61056_();
        if (validStates.size() > 1) {
            if (RegUtil.values(ForgeRegistries.POI_TYPES).stream().flatMap(poiType -> poiType.f_27325_().stream()).anyMatch(arg_0 -> ((ImmutableList)validStates).contains(arg_0))) {
                for (int x = event.getPos().m_123341_() - 1; x <= event.getPos().m_123341_() + 1; ++x) {
                    for (int z = event.getPos().m_123343_() - 1; z <= event.getPos().m_123343_() + 1; ++z) {
                        for (double y = (double)(event.getPos().m_123342_() - 1); y <= (double)(event.getPos().m_123342_() + 1); y += 1.0) {
                            BlockPos pos1 = new BlockPos(x, (int)y, z);
                            if (!((Level)event.getLevel()).m_46749_(pos1) || event.getLevel().m_8055_(pos1).m_60734_() != block) continue;
                            BlockPos totemPos1 = TotemHelper.getTotemPosition((ResourceKey<Level>)((Level)event.getLevel()).m_46472_(), pos1);
                            if (totemPos1 != null && totemPos == null) {
                                totemPos = totemPos1;
                            }
                            positions.add(pos1);
                        }
                    }
                }
            }
        }
        if (totemPos != null && event.getLevel().m_46805_(totemPos) && (totem = event.getLevel().m_7702_(totemPos)) instanceof TotemBlockEntity && ((TotemBlockEntity)totem).getControllingFaction() != null && VampirismPlayerAttributes.get((Player)event.getPlayer()).faction != ((TotemBlockEntity)totem).getControllingFaction()) {
            Player player;
            event.setCanceled(true);
            event.getPlayer().m_5661_((Component)Component.m_237115_((String)"text.vampirism.village.totem_destroy.fail_totem_faction"), true);
            if (!positions.isEmpty() && (player = event.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                positions.forEach(pos -> {
                    Packet pkt;
                    player.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)event.getLevel(), pos));
                    BlockEntity tileentity = event.getLevel().m_7702_(pos);
                    if (tileentity != null && (pkt = tileentity.m_58483_()) != null) {
                        player.f_8906_.m_9829_(pkt);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void eyeHeight(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityEvent.Size event) {
        if (event.getEntity() instanceof Player && ((Player)event.getEntity()).m_150109_() != null && event.getEntity().m_6084_() && event.getEntity().m_20182_().m_82556_() != 0.0 && event.getEntity().m_20202_() == null) {
            if (VampirismPlayerAttributes.get((Player)((Player)event.getEntity())).getVampSpecial().bat) {
                event.setNewSize(BatVampireAction.BAT_SIZE);
                event.setNewEyeHeight(0.51000005f);
            } else if (VampirismPlayerAttributes.get((Player)((Player)event.getEntity())).getVampSpecial().isDBNO) {
                event.setNewSize(EntityDimensions.m_20398_((float)0.6f, (float)0.95f));
                event.setNewEyeHeight(0.725f);
            }
        }
    }

    @SubscribeEvent
    public void onTryMount(@NotNull EntityMountEvent event) {
        if (event.getEntity() instanceof Player && VampirismPlayerAttributes.get((Player)event.getEntity()).getVampSpecial().isCannotInteract()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAttachCapability(@NotNull AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            try {
                event.addCapability(REFERENCE.FACTION_PLAYER_HANDLER_KEY, FactionPlayerHandler.createNewCapability((Player)event.getObject()));
                event.addCapability(REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.createNewCapability((Player)event.getObject()));
                event.addCapability(REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.createNewCapability((Player)event.getObject()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to attach capabilities to player. Player: {}", event.getObject());
                Throwables.propagate((Throwable)e);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackEntity(@NotNull AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.m_6084_()) {
            if (VampirismPlayerAttributes.get((Player)player).getVampSpecial().bat) {
                event.setCanceled(true);
            }
            HunterPlayer.getOpt(player).ifPresent(HunterPlayer::breakDisguise);
            if (!this.checkItemUsePerm(player.m_21205_(), player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null) {
            HunterPlayer.getOpt(event.getPlayer()).ifPresent(HunterPlayer::breakDisguise);
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof Player) || !event.getEntity().m_6084_()) {
            return;
        }
        if (event.getPlacedBlock().m_60795_()) {
            return;
        }
        try {
            if (VampirismPlayerAttributes.get((Player)event.getEntity()).getVampSpecial().isCannotInteract()) {
                MinecraftServer server;
                BlockEntity t;
                event.setCanceled(true);
                if (event.getPlacedBlock().m_155947_() && (t = event.getLevel().m_7702_(event.getPos())) instanceof Container) {
                    ((Container)t).m_6211_();
                }
                if (event.getEntity() instanceof ServerPlayer && (server = event.getEntity().m_9236_().m_7654_()) != null) {
                    server.m_6846_().m_11292_((ServerPlayer)event.getEntity());
                }
            }
            HunterPlayer.getOpt((Player)event.getEntity()).ifPresent(HunterPlayer::breakDisguise);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.BreakSpeed event) {
        if (VampirismPlayerAttributes.get(event.getEntity()).getVampSpecial().isCannotInteract()) {
            event.setCanceled(true);
        } else if ((ModBlocks.GARLIC_DIFFUSER_NORMAL.get() == event.getState().m_60734_() || ModBlocks.GARLIC_DIFFUSER_WEAK.get() == event.getState().m_60734_() || ModBlocks.GARLIC_DIFFUSER_IMPROVED.get() == event.getState().m_60734_()) && VampirismPlayerAttributes.get((Player)event.getEntity()).vampireLevel > 0) {
            event.setNewSpeed(event.getOriginalSpeed() * 0.1f);
        }
    }

    @SubscribeEvent
    public void onItemPickupPre(@NotNull EntityItemPickupEvent event) {
        if (VampirismPlayerAttributes.get((Player)event.getEntity()).getVampSpecial().isDBNO) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemRightClick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerInteractEvent.RightClickItem event) {
        if (!this.checkItemUsePerm(event.getItemStack(), event.getEntity())) {
            event.setCanceled(true);
        }
        if ((event.getItemStack().m_41720_() instanceof ThrowablePotionItem || event.getItemStack().m_41720_() instanceof CrossbowItem) && VampirismPlayerAttributes.get(event.getEntity()).getVampSpecial().isCannotInteract()) {
            event.setCancellationResult(InteractionResult.m_19078_((boolean)event.getLevel().m_5776_()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (VampirismPlayerAttributes.get((Player)event.getEntity()).getVampSpecial().isCannotInteract()) {
                event.setCanceled(true);
            }
            if (!this.checkItemUsePerm(event.getItem(), player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockRightClicked(PlayerInteractEvent.RightClickBlock event) {
        if (Helper.isVampire(event.getEntity()) && VampirismPlayerAttributes.get(event.getEntity()).getVampSpecial().isCannotInteract()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEntityUseItemEvent.Finish event) {
        Potion p;
        ItemStack stack;
        if (Helper.isVampire((Entity)event.getEntity()) && event.getItem().m_41720_() instanceof GarlicBreadItem && !event.getEntity().m_20193_().f_46443_) {
            if (event.getEntity() instanceof IVampire) {
                DamageHandler.affectVampireGarlicDirect((IVampire)event.getEntity(), EnumStrength.MEDIUM);
            } else if (event.getEntity() instanceof Player) {
                VampirePlayer.getOpt((Player)event.getEntity()).ifPresent(vampire -> DamageHandler.affectVampireGarlicDirect(vampire, EnumStrength.MEDIUM));
            }
        }
        if (!Helper.isHunter((Entity)event.getEntity()) && (stack = event.getItem()).m_41720_() == Items.f_42589_ && (p = PotionUtils.m_43579_((ItemStack)stack)) instanceof VampirismPotion.HunterPotion && p.m_43488_().stream().map(MobEffectInstance::m_19544_).anyMatch(MobEffect::m_19486_)) {
            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ModEffects.POISON.get(), Integer.MAX_VALUE, 4));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingAttack(@NotNull LivingAttackEvent event) {
        if (event.getEntity() instanceof Player && event.getEntity().m_6084_() && !FactionPlayerHandler.getOpt((Player)event.getEntity()).map(h -> h.onEntityAttacked(event.getSource(), event.getAmount())).orElse(false).booleanValue()) {
            event.setCanceled(true);
        }
        if (event.getSource().m_7639_() instanceof Player) {
            HunterPlayer.getOpt((Player)event.getSource().m_7639_()).ifPresent(HunterPlayer::breakDisguise);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeathFirst(@NotNull LivingDeathEvent event) {
        if (event.getEntity() instanceof Player && VampirePlayer.getOpt((Player)event.getEntity()).map(v -> v.onDeadlyHit(event.getSource())).orElse(false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingFall(@NotNull LivingFallEvent event) {
        if (event.getEntity() instanceof Player) {
            event.setDistance(event.getDistance() - (float)VampirismPlayerAttributes.get((Player)event.getEntity()).getVampSpecial().getJumpBoost());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHurt(@NotNull LivingHurtEvent event) {
        DamageSource d = event.getSource();
        if (!d.m_269533_(DamageTypeTags.f_268731_) && !d.m_269533_(DamageTypeTags.f_268490_) && event.getEntity() instanceof Player && VampirismPlayerAttributes.get((Player)((Player)event.getEntity())).getVampSpecial().bat) {
            event.setAmount(event.getAmount() * 2.0f);
        }
    }

    @SubscribeEvent
    public void onLivingJump(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof Player) {
            event.getEntity().m_20256_(event.getEntity().m_20184_().m_82520_(0.0, (double)((float)VampirismPlayerAttributes.get((Player)event.getEntity()).getVampSpecial().getJumpBoost() * 0.1f), 0.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerClone(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.Clone event) {
        if (!event.getEntity().m_20193_().f_46443_) {
            event.getOriginal().reviveCaps();
            FactionPlayerHandler.get(event.getEntity()).copyFrom(event.getOriginal());
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldStack;
        if (event.getLevel().m_6857_().m_61937_(event.getPos()) && !(heldStack = event.getItemStack()).m_41619_() && heldStack.m_41613_() == 1) {
            boolean bloodBottle;
            boolean glassBottle = Items.f_42590_.equals(heldStack.m_41720_());
            boolean bl = bloodBottle = ModItems.BLOOD_BOTTLE.get() == heldStack.m_41720_();
            if (bloodBottle || glassBottle && ((Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get()).booleanValue()) {
                BlockEntity entity;
                Block block = event.getLevel().m_8055_(event.getPos()).m_60734_();
                BlockState state = event.getLevel().m_8055_(event.getPos());
                boolean convert = false;
                if (glassBottle && state.m_155947_() && (entity = event.getLevel().m_7702_(event.getPos())) != null) {
                    convert = entity.getCapability(ForgeCapabilities.FLUID_HANDLER, event.getFace()).map(fluidHandler -> {
                        boolean flag = false;
                        FluidStack drain = fluidHandler.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), 1000), IFluidHandler.FluidAction.SIMULATE);
                        if (drain.getAmount() >= 100) {
                            flag = true;
                        }
                        if (flag && block instanceof AltarInspirationBlock) {
                            flag = false;
                        }
                        if (flag && block instanceof BloodContainerBlock) {
                            flag = false;
                        }
                        return flag;
                    }).orElse(false);
                }
                if ((bloodBottle || convert) && block instanceof BloodContainerBlock) {
                    event.setUseBlock(Event.Result.ALLOW);
                }
                if (convert) {
                    InteractionHand hand = heldStack.equals(event.getEntity().m_21205_()) ? InteractionHand.MAIN_HAND : (heldStack.equals(event.getEntity().m_21206_()) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                    heldStack = new ItemStack((ItemLike)ModItems.BLOOD_BOTTLE.get());
                    event.getEntity().m_21008_(hand, heldStack);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClickedBlock(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerInteractEvent.LeftClickBlock event) {
        if (event.getFace() == null) {
            return;
        }
        BlockPos pos = event.getPos().m_121945_(event.getFace());
        Level world = event.getLevel();
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == ModBlocks.ALCHEMICAL_FIRE.get()) {
            world.m_5898_(null, 1009, pos, 0);
            world.m_7471_(pos, false);
            event.setCanceled(true);
        } else if ((ModBlocks.GARLIC_DIFFUSER_NORMAL.get() == state.m_60734_() || ModBlocks.GARLIC_DIFFUSER_WEAK.get() == state.m_60734_() || ModBlocks.GARLIC_DIFFUSER_IMPROVED.get() == state.m_60734_()) && Helper.isVampire(event.getEntity())) {
            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ModEffects.GARLIC.get()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerName(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.NameFormat event) {
        if (event.getEntity() != null && ((Boolean)VampirismConfig.SERVER.factionColorInChat.get()).booleanValue()) {
            FactionPlayerHandler.getOpt(event.getEntity()).ifPresent(fph -> fph.getCurrentFactionPlayer().ifPresent(fp -> {
                IFaction<?> f = fp.getDisguisedAs();
                if (f != null) {
                    MutableComponent displayName = fph.getLordLevel() > 0 && (Boolean)VampirismConfig.SERVER.lordPrefixInChat.get() != false ? Component.m_237113_((String)"[").m_7220_(fph.getLordTitle()).m_130946_("] ").m_7220_(event.getDisplayname()) : event.getDisplayname().m_6881_();
                    event.setDisplayname((Component)displayName.m_130938_(style -> style.m_131148_(f.getChatColor())));
                }
            }));
        }
    }

    @SubscribeEvent
    public void sleepTimeCheck(@NotNull SleepingTimeCheckEvent event) {
        if (Helper.isVampire(event.getEntity())) {
            event.getSleepingLocation().ifPresent(blockPos -> event.setResult(event.getEntity().m_9236_().m_8055_(blockPos).m_60734_() instanceof CoffinBlock ? (event.getEntity().m_9236_().m_46461_() ? Event.Result.ALLOW : Event.Result.DENY) : event.getResult()));
        }
        if (Helper.isHunter(event.getEntity())) {
            event.getSleepingLocation().ifPresent(blockPos -> event.setResult(event.getEntity().m_20193_().m_8055_(blockPos).m_60734_() instanceof TentBlock ? (!event.getEntity().m_20193_().m_46461_() ? Event.Result.ALLOW : Event.Result.DENY) : event.getResult()));
        }
    }

    @SubscribeEvent
    public void sleepTimeFinish(@NotNull SleepFinishedTimeEvent event) {
        boolean sleepingInCoffin;
        if (event.getLevel() instanceof ServerLevel && ((ServerLevel)event.getLevel()).m_46461_() && (sleepingInCoffin = event.getLevel().m_6907_().stream().anyMatch(player -> {
            Optional pos = player.m_21257_();
            return pos.isPresent() && event.getLevel().m_8055_((BlockPos)pos.get()).m_60734_() instanceof CoffinBlock;
        }))) {
            long dist = ((ServerLevel)event.getLevel()).m_46468_() % 24000L > 12000L ? 13000L : -11000L;
            event.setTimeAddition(event.getNewTime() + dist);
        }
    }

    private boolean checkItemUsePerm(@NotNull ItemStack stack, @NotNull Player player) {
        Item item;
        boolean message;
        boolean bl = message = !player.m_20193_().f_46443_;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IFactionLevelItem) {
            IFactionPlayer factionPlayer;
            IFactionLevelItem item2 = (IFactionLevelItem)item;
            if (!player.m_6084_()) {
                return false;
            }
            LazyOptional<FactionPlayerHandler> handler = FactionPlayerHandler.getOpt(player);
            IFaction<?> usingFaction = item2.getExclusiveFaction(stack);
            ISkill requiredSkill = item2.getRequiredSkill(stack);
            if (usingFaction != null && !handler.map(h -> h.isInFaction(usingFaction)).orElse(false).booleanValue()) {
                if (message) {
                    player.m_5661_((Component)Component.m_237110_((String)"text.vampirism.can_only_be_used_by", (Object[])new Object[]{usingFaction.getNamePlural()}), true);
                }
                return false;
            }
            if (handler.map(FactionPlayerHandler::getCurrentLevel).orElse(0) < item2.getMinLevel(stack)) {
                if (message) {
                    player.m_5661_((Component)Component.m_237110_((String)"text.vampirism.can_only_be_used_by_level", (Object[])new Object[]{usingFaction == null ? Component.m_237115_((String)"text.vampirism.all") : usingFaction.getNamePlural(), item2.getMinLevel(stack)}), true);
                }
                return false;
            }
            if (!(requiredSkill == null || (factionPlayer = (IFactionPlayer)handler.resolve().flatMap(FactionPlayerHandler::getCurrentFactionPlayer).orElse(null)) != null && factionPlayer.getSkillHandler().isSkillEnabled(requiredSkill))) {
                if (message) {
                    player.m_5661_((Component)Component.m_237110_((String)"text.vampirism.can_only_be_used_with_skill", (Object[])new Object[]{requiredSkill.getName()}), true);
                }
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onPlayerAttackCritical(@NotNull CriticalHitEvent event) {
        Item item;
        ItemStack stack = event.getEntity().m_21205_();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IFactionSlayerItem) {
            IFactionSlayerItem item2 = (IFactionSlayerItem)item;
            IFaction<?> faction = VampirismAPI.factionRegistry().getFaction(event.getTarget());
            if (faction != null && faction.equals(item2.getSlayedFaction())) {
                event.setResult(Event.Result.ALLOW);
                event.setDamageModifier(event.getDamageModifier() + event.getOldDamageModifier() * (item2.getDamageMultiplierForFaction(stack) - 1.0f));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerGameMode(PlayerEvent.PlayerChangeGameModeEvent event) {
        if (event.getNewGameMode() == GameType.SPECTATOR) {
            FactionPlayerHandler.getOpt(event.getEntity()).ifPresent(handler -> handler.getCurrentFactionPlayer().ifPresent(factionPlayer -> factionPlayer.getActionHandler().deactivateAllActions()));
        }
    }
}

