/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryContainerMenu;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.HunterTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.items.HunterIntelItem;
import de.teamlapen.vampirism.items.PureBloodItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;

public class HunterTableMenu
extends InventoryContainerMenu
implements ContainerListener {
    private static final InventoryContainerMenu.SelectorInfo[] SELECTOR_INFOS = new InventoryContainerMenu.SelectorInfo[]{new InventoryContainerMenu.SelectorInfo(Items.f_42517_, 15, 28), new InventoryContainerMenu.SelectorInfo((Item)ModItems.VAMPIRE_FANG.get(), 42, 28), new InventoryContainerMenu.SelectorInfo(ModTags.Items.PURE_BLOOD, 69, 28), new InventoryContainerMenu.SelectorInfo((Item)ModItems.VAMPIRE_BOOK.get(), 96, 28)};
    @NotNull
    private final SlotResult slotResult;
    private final int hunterLevel;
    private final HunterLevelingConf levelingConf = HunterLevelingConf.instance();
    private ItemStack missing = ItemStack.f_41583_;

    public HunterTableMenu(int id, @NotNull Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super((MenuType<? extends InventoryContainerMenu>)((MenuType)ModContainer.HUNTER_TABLE.get()), id, playerInventory, worldPosCallable, (Container)new SimpleContainer(SELECTOR_INFOS.length), SELECTOR_INFOS);
        ((SimpleContainer)this.inventory).m_19164_((ContainerListener)this);
        this.slotResult = new SlotResult(this, (Container)new ResultContainer(){

            public int m_6893_() {
                return 1;
            }
        }, 4, 146, 28);
        this.m_38897_(this.slotResult);
        this.hunterLevel = FactionPlayerHandler.get(playerInventory.f_35978_).getCurrentLevel(VReference.HUNTER_FACTION);
        this.addPlayerSlots(playerInventory);
    }

    public void m_5757_(@NotNull Container invBasic) {
        this.m_6199_(invBasic);
    }

    public ItemStack getMissingItems() {
        return this.missing;
    }

    public boolean isLevelValid(boolean considerTier) {
        return considerTier ? this.levelingConf.isLevelValidForTableTier(this.hunterLevel + 1, this.worldPos.m_6721_((world, blockPos) -> {
            BlockState state = world.m_8055_(blockPos);
            return state.m_61138_(HunterTableBlock.VARIANT) ? ((HunterTableBlock.TABLE_VARIANT)((Object)((Object)state.m_61143_(HunterTableBlock.VARIANT)))).tier : 0;
        }).orElse(0)) : this.levelingConf.isLevelValidForTable(this.hunterLevel + 1);
    }

    @Override
    public void m_6877_(@NotNull Player playerIn) {
        super.m_6877_(playerIn);
        if (!playerIn.m_20193_().f_46443_) {
            this.m_150411_(playerIn, this.inventory);
        }
    }

    public void m_6199_(@NotNull Container inventoryIn) {
        if (this.isLevelValid(true)) {
            int[] req = this.levelingConf.getItemRequirementsForTable(this.hunterLevel + 1);
            this.missing = this.checkItems(req[0], req[1], req[2], req[3]);
            if (this.missing.m_41619_()) {
                this.slotResult.f_40218_.m_6836_(0, new ItemStack((ItemLike)HunterIntelItem.getIntelForExactlyLevel(this.hunterLevel + 1)));
            } else {
                this.slotResult.f_40218_.m_6836_(0, ItemStack.f_41583_);
            }
        }
    }

    @Override
    public boolean m_6875_(@NotNull Player playerIn) {
        return HunterTableMenu.m_38889_((ContainerLevelAccess)this.worldPos, (Player)playerIn, (Block)((Block)ModBlocks.HUNTER_TABLE.get()));
    }

    protected void onPickupResult() {
        int[] req = this.levelingConf.getItemRequirementsForTable(this.hunterLevel + 1);
        InventoryHelper.removeItems(this.inventory, new int[]{1, req[0], req[1], req[3]});
    }

    private ItemStack checkItems(int fangs, int blood, int bloodLevel, int par3) {
        return InventoryHelper.checkItems(this.inventory, new Item[]{Items.f_42517_, (Item)ModItems.VAMPIRE_FANG.get(), PureBloodItem.getBloodItemForLevel(bloodLevel), (Item)ModItems.VAMPIRE_BOOK.get()}, new int[]{1, fangs, blood, par3});
    }

    private static class SlotResult
    extends Slot {
        private final HunterTableMenu hunterTableMenu;

        public SlotResult(HunterTableMenu container, @NotNull Container inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
            this.hunterTableMenu = container;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }

        public void m_142406_(@NotNull Player playerIn, @NotNull ItemStack stack) {
            this.hunterTableMenu.onPickupResult();
        }
    }

    public static class Factory
    implements IContainerFactory<HunterTableMenu> {
        @NotNull
        public HunterTableMenu create(int windowId, @NotNull Inventory inv, @NotNull FriendlyByteBuf data) {
            BlockPos pos = data.m_130135_();
            return new HunterTableMenu(windowId, inv, ContainerLevelAccess.m_39289_((Level)inv.f_35978_.m_9236_(), (BlockPos)pos));
        }
    }
}

