/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterArmorItem;
import de.teamlapen.vampirism.util.ArmorMaterial;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorOfSwiftnessItem
extends VampirismHunterArmorItem
implements IItemWithTier,
DyeableLeatherItem {
    public static final SwiftnessArmorMaterial NORMAL = new SwiftnessArmorMaterial("vampirism:armor_of_swiftness_normal", IItemWithTier.TIER.NORMAL, 15, ArmorMaterial.createReduction(1, 2, 3, 1), 12, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)Tags.Items.LEATHER), 0.035f);
    public static final SwiftnessArmorMaterial ENHANCED = new SwiftnessArmorMaterial("vampirism:armor_of_swiftness_enhanced", IItemWithTier.TIER.ENHANCED, 20, ArmorMaterial.createReduction(2, 5, 6, 2), 12, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)Tags.Items.LEATHER), 0.075f);
    public static final SwiftnessArmorMaterial ULTIMATE = new SwiftnessArmorMaterial("vampirism:armor_of_swiftness_ultimate", IItemWithTier.TIER.ULTIMATE, 25, ArmorMaterial.createReduction(3, 6, 8, 3), 12, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)Tags.Items.LEATHER), 0.1f);
    @NotNull
    private final IItemWithTier.TIER tier;

    @NotNull
    private static Map<Attribute, Tuple<Double, AttributeModifier.Operation>> getModifiers(@NotNull ArmorItem.Type type, @NotNull SwiftnessArmorMaterial tier) {
        HashMap<Attribute, Tuple<Double, AttributeModifier.Operation>> map = new HashMap<Attribute, Tuple<Double, AttributeModifier.Operation>>();
        map.put(Attributes.f_22279_, new Tuple((Object)tier.getSpeedReduction(), (Object)AttributeModifier.Operation.MULTIPLY_TOTAL));
        return map;
    }

    public ArmorOfSwiftnessItem(@NotNull ArmorItem.Type type, @NotNull SwiftnessArmorMaterial material) {
        super(material, type, new Item.Properties(), ArmorOfSwiftnessItem.getModifiers(type, material));
        this.tier = material.getTier();
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : -1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @Override
    public void onArmorTick(ItemStack itemStack, Level world, @NotNull Player player) {
        super.onArmorTick(itemStack, world, player);
        if (player.f_19797_ % 45 == 3 && this.m_266204_() == ArmorItem.Type.CHESTPLATE) {
            boolean flag = true;
            int boost = Integer.MAX_VALUE;
            for (ItemStack stack : player.m_150109_().f_35975_) {
                if (!stack.m_41619_() && stack.m_41720_() instanceof ArmorOfSwiftnessItem) {
                    int b = this.getJumpBoost(this.getVampirismTier());
                    if (b >= boost) continue;
                    boost = b;
                    continue;
                }
                flag = false;
                break;
            }
            if (flag && boost > -1) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 50, boost, false, false));
            }
        }
    }

    private int getJumpBoost(@NotNull IItemWithTier.TIER tier) {
        return switch (tier) {
            case IItemWithTier.TIER.ULTIMATE -> 1;
            case IItemWithTier.TIER.ENHANCED -> 0;
            default -> -1;
        };
    }

    private String getTextureLocationLeather(EquipmentSlot slot) {
        return String.format("minecraft:textures/models/armor/leather_layer_%d.png", slot == EquipmentSlot.LEGS ? 2 : 1);
    }

    public static class SwiftnessArmorMaterial
    extends ArmorMaterial.Tiered {
        private final double speedReduction;

        public SwiftnessArmorMaterial(String name, @NotNull IItemWithTier.TIER tier, int maxDamageFactor, EnumMap<ArmorItem.Type, Integer> damageReduction, int enchantability, SoundEvent soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterial, double speedReduction) {
            super(name, tier, maxDamageFactor, damageReduction, enchantability, soundEvent, toughness, knockbackResistance, repairMaterial);
            this.speedReduction = speedReduction;
        }

        public double getSpeedReduction() {
            return this.speedReduction;
        }
    }
}

