/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.ModDisplayItemGenerator;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.BloodBottleFluidHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodBottleItem
extends Item
implements IFactionExclusiveItem,
ModDisplayItemGenerator.CreativeTabItemProvider {
    public static final int AMOUNT = 9;
    private static final int MULTIPLIER = 100;
    private static final int capacity = 900;

    @NotNull
    public static ItemStack getStackWithDamage(int damage) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.BLOOD_BOTTLE.get());
        stack.m_41721_(damage);
        return stack;
    }

    public BloodBottleItem() {
        super(new Item.Properties().m_41499_(9).setNoRepair());
    }

    public boolean doesSneakBypassUse(ItemStack stack, @NotNull LevelReader world, @NotNull BlockPos pos, Player player) {
        BlockEntity t = world.m_7702_(pos);
        return t != null && t.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent();
    }

    @Override
    public void generateCreativeTab(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.m_7968_();
            stack.m_41721_(i);
            output.m_246267_(stack, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        }
        ItemStack stack0 = this.m_7968_();
        stack0.m_41721_(0);
        output.m_246267_(stack0, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
        ItemStack stack9 = this.m_7968_();
        stack9.m_41721_(9);
        output.m_246267_(stack9, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return VReference.VAMPIRE_FACTION;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving) {
        if (entityLiving instanceof IVampire) {
            int blood = BloodHelper.getBlood(stack);
            int drink = Math.min(blood, 100);
            ItemStack[] result = new ItemStack[1];
            int amt = BloodHelper.drain(stack, drink, IFluidHandler.FluidAction.EXECUTE, true, containerStack -> {
                result[0] = containerStack;
            });
            ((IVampire)entityLiving).drinkBlood(amt / 100, 0.0f, false);
            return result[0];
        }
        return FluidUtil.getFluidHandler((ItemStack)stack).map(IFluidHandlerItem::getContainer).orElseGet(() -> super.m_5922_(stack, worldIn, entityLiving));
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 15;
    }

    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, CompoundTag nbt) {
        return new BloodBottleFluidHandler(stack, 900);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack stack, int count) {
        if (pLivingEntity instanceof IVampire) {
            return;
        }
        if (!(pLivingEntity instanceof Player) || !pLivingEntity.m_6084_()) {
            pLivingEntity.m_21253_();
            return;
        }
        int blood = BloodHelper.getBlood(stack);
        VampirePlayer vampire = VampirePlayer.getOpt((Player)pLivingEntity).resolve().orElse(null);
        if (vampire == null || vampire.getLevel() == 0 || blood == 0 || !vampire.getBloodStats().needsBlood()) {
            pLivingEntity.m_21253_();
            return;
        }
        if (blood > 0 && count == 1) {
            InteractionHand activeHand = pLivingEntity.m_7655_();
            int drink = Math.min(blood, 300);
            if (BloodHelper.drain(stack, drink, IFluidHandler.FluidAction.EXECUTE, true, containerStack -> pLivingEntity.m_21008_(activeHand, containerStack)) > 0) {
                vampire.drinkBlood(Math.round((float)drink / 100.0f), 0.3f, false);
            }
            if ((blood = BloodHelper.getBlood(stack)) > 0) {
                pLivingEntity.m_6672_(pLivingEntity.m_7655_());
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return VampirePlayer.getOpt(playerIn).map(vampire -> {
            if (vampire.getLevel() == 0) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            if (vampire.getBloodStats().needsBlood() && stack.m_41613_() == 1) {
                playerIn.m_6672_(handIn);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }).orElse(new InteractionResultHolder(InteractionResult.PASS, (Object)stack));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return false;
    }
}

