/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.client.model.armor.HunterHatModel;
import de.teamlapen.vampirism.items.VampirismHunterArmorItem;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class HunterHatItem
extends VampirismHunterArmorItem {
    private final int type;
    private String descriptionId;

    public HunterHatItem(int type) {
        super((ArmorMaterial)ArmorMaterials.IRON, ArmorItem.Type.HELMET, new Item.Properties());
        this.type = type;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "vampirism:textures/entity/hunter_extra.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return HunterHatItem.this.type == 0 ? HunterHatModel.getAdjustedInstance0(original) : HunterHatModel.getAdjustedInstance1(original);
            }
        });
    }

    @Override
    @NotNull
    protected String m_41467_() {
        if (this.descriptionId == null) {
            this.descriptionId = super.m_41467_().replaceAll("_0|_1", "");
        }
        return this.descriptionId;
    }

    @Override
    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (stack.m_41788_() && "10000000".equals(stack.m_41786_().getString())) {
            UtilLib.spawnParticlesAroundEntity((LivingEntity)player, (ParticleOptions)ParticleTypes.f_175830_, 0.5, 4);
            if (player.f_19797_ % 16 == 4) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 30, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100, 2));
            }
        }
    }
}

