/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.ModDisplayItemGenerator;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.refinements.RefinementSet;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefinementItem
extends Item
implements IRefinementItem,
ModDisplayItemGenerator.CreativeTabItemProvider {
    public static final int MAX_DAMAGE = 500;
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final IRefinementItem.AccessorySlotType type;

    @NotNull
    public static ItemStack getRandomRefinementItem(@NotNull IPlayableFaction<?> faction) {
        ItemStack stack;
        List sets = RegUtil.values(ModRegistries.REFINEMENT_SETS).stream().filter(set -> set.getFaction() == faction).map(a -> ((RefinementSet)a).getWeightedRandom()).collect(Collectors.toList());
        if (sets.isEmpty()) {
            return ItemStack.f_41583_;
        }
        IRefinementSet s = WeightedRandom.m_216822_((RandomSource)RANDOM, sets).map(WeightedEntry.Wrapper::m_146310_).orElseGet(() -> (IRefinementSet)((WeightedEntry.Wrapper)sets.get(0)).m_146310_());
        IRefinementItem.AccessorySlotType t = s.getSlotType().orElseGet(() -> switch (RANDOM.m_188503_(3)) {
            case 0 -> IRefinementItem.AccessorySlotType.OBI_BELT;
            case 1 -> IRefinementItem.AccessorySlotType.RING;
            default -> IRefinementItem.AccessorySlotType.AMULET;
        });
        IRefinementItem i = (IRefinementItem)faction.getRefinementItem(t);
        if (i.applyRefinementSet(stack = new ItemStack((ItemLike)i), s)) {
            return stack;
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public static IRefinementSet getRandomRefinementForItem(@Nullable IFaction<?> faction, @NotNull IRefinementItem stack) {
        List sets = RegUtil.values(ModRegistries.REFINEMENT_SETS).stream().filter(set -> faction == null || set.getFaction() == faction).filter(set -> set.getSlotType().map(s -> s == stack.getSlotType()).orElse(true)).map(a -> ((RefinementSet)a).getWeightedRandom()).collect(Collectors.toList());
        if (sets.isEmpty()) {
            return null;
        }
        return WeightedRandom.m_216822_((RandomSource)RANDOM, sets).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
    }

    public RefinementItem(@NotNull Item.Properties properties, IRefinementItem.AccessorySlotType type) {
        super(properties.m_41499_(500).setNoRepair());
        this.type = type;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        IRefinementSet set = this.getRefinementSet(stack);
        if (set != null) {
            set.getRefinements().stream().map(RegistryObject::get).forEach(refinement -> tooltip.add((Component)Component.m_237113_((String)" - ").m_7220_(refinement.getDescription()).m_130940_(ChatFormatting.GRAY)));
        }
    }

    @Override
    public boolean applyRefinementSet(@NotNull ItemStack stack, @NotNull IRefinementSet set) {
        if (set.getSlotType().map(t -> t == this.type).orElse(true).booleanValue()) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128359_("refinement_set", RegUtil.id(set).toString());
            return true;
        }
        return false;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        IRefinementSet set = this.getRefinementSet(stack);
        if (set == null) {
            return super.m_7626_(stack);
        }
        return Component.m_237115_((String)this.m_5524_()).m_130946_(" ").m_7220_(set.getName()).m_130940_(set.getRarity().color);
    }

    @Override
    @Nullable
    public IRefinementSet getRefinementSet(@NotNull ItemStack stack) {
        if (stack.m_41782_()) {
            String refinementsNBT = stack.m_41783_().m_128461_("refinement_set");
            return RegUtil.getRefinementSet(new ResourceLocation(refinementsNBT));
        }
        return null;
    }

    @Override
    public IRefinementItem.AccessorySlotType getSlotType() {
        return this.type;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        if (!worldIn.m_5776_()) {
            ItemStack stack = playerIn.m_21120_(handIn);
            if (FactionPlayerHandler.getOpt(playerIn).map(v -> v).flatMap(FactionPlayerHandler::getCurrentFactionPlayer).map(IFactionPlayer::getSkillHandler).map(sh -> sh.equipRefinementItem(stack)).orElse(false).booleanValue()) {
                return InteractionResultHolder.m_19096_((Object)ItemStack.f_41583_);
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    @Override
    public void generateCreativeTab(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        ItemStack stack = this.m_7968_();
        StreamSupport.stream(VampirismRegistries.REFINEMENT_SETS.get().spliterator(), false).filter(set -> this.getExclusiveFaction(stack) == null || set.getFaction() == this.getExclusiveFaction(stack)).filter(set -> set.getSlotType().map(s -> s == this.getSlotType()).orElse(true)).map(set -> {
            ItemStack s = stack.m_41777_();
            this.applyRefinementSet(s, (IRefinementSet)set);
            return s;
        }).forEach(item -> output.m_246267_(item, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY));
        output.m_246267_(stack, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
    }
}

