/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items.crossbow;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.items.IArrowContainer;
import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.mixin.CrossbowItemMixin;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class VampirismCrossbowItem
extends CrossbowItem
implements IFactionLevelItem<IHunterPlayer>,
IVampirismCrossbow {
    protected final Tier itemTier;
    protected final float arrowVelocity;
    protected final int chargeTime;

    public VampirismCrossbowItem(Item.Properties properties, float arrowVelocity, int chargeTime, Tier itemTier) {
        super(properties);
        this.arrowVelocity = arrowVelocity;
        this.chargeTime = chargeTime;
        this.itemTier = itemTier;
    }

    public void m_7373_(@Nonnull ItemStack stack, @javax.annotation.Nullable Level level, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltips, flag);
        this.addFactionToolTips(stack, level, tooltips, flag, VampirismMod.proxy.getClientPlayer());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && enchantment != Enchantments.f_44959_ || this.getCompatibleEnchantments().contains(enchantment);
    }

    protected Collection<Enchantment> getCompatibleEnchantments() {
        return Arrays.asList(Enchantments.f_44952_, Enchantments.f_44989_, Enchantments.f_44988_);
    }

    public boolean m_6832_(@Nonnull ItemStack crossbow, ItemStack repairItem) {
        return repairItem.m_204117_(Tags.Items.STRING) || super.m_6832_(crossbow, repairItem);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.itemTier.m_6601_();
    }

    @Override
    public int getMinLevel(@Nonnull ItemStack stack) {
        return 0;
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    @Nonnull
    public Predicate<ItemStack> m_6442_() {
        return stack -> false;
    }

    public int m_8105_(@Nonnull ItemStack crossbow) {
        return this.getChargeDurationMod(crossbow) + 3;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level p_77659_1_, Player p_77659_2_, @Nonnull InteractionHand p_77659_3_) {
        ItemStack itemstack = p_77659_2_.m_21120_(p_77659_3_);
        if (VampirismCrossbowItem.m_40932_((ItemStack)itemstack)) {
            this.performShootingMod(p_77659_1_, (LivingEntity)p_77659_2_, p_77659_3_, itemstack, this.getShootingPowerMod(itemstack), 1.0f);
            this.setUncharged(p_77659_2_, itemstack);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!p_77659_2_.m_6298_(itemstack).m_41619_()) {
            if (!VampirismCrossbowItem.m_40932_((ItemStack)itemstack)) {
                ((CrossbowItemMixin)((Object)this)).setStartSoundPlayed(false);
                ((CrossbowItemMixin)((Object)this)).setMidLoadSoundPlayer(false);
                p_77659_2_.m_6672_(p_77659_3_);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean performShootingMod(Level level, LivingEntity shooter, InteractionHand hand, ItemStack stack, float speed, float angle) {
        list = CrossbowItemMixin.getChargedProjectiles(stack);
        afloat = CrossbowItemMixin.getShotPitches(shooter.m_217043_());
        for (i = 0; i < list.size(); ++i) {
            itemstack = list.get(i);
            if (!(shooter instanceof Player)) ** GOTO lbl-1000
            player = (Player)shooter;
            if (player.m_150110_().f_35937_) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = flag = false;
            }
            if (itemstack.m_41619_()) continue;
            this.shootProjectileMod(level, shooter, hand, stack, itemstack, afloat[i], flag, speed, angle);
            break;
        }
        CrossbowItemMixin.onCrossbowShot(level, shooter, stack);
        return list.isEmpty();
    }

    protected void shootProjectileMod(Level p_220016_0_, LivingEntity p_220016_1_, InteractionHand p_220016_2_, ItemStack p_220016_3_, ItemStack p_220016_4_, float p_220016_5_, boolean p_220016_6_, float p_220016_7_, float p_220016_8_) {
        if (!p_220016_0_.f_46443_) {
            AbstractArrow projectileentity = this.modifyArrow(p_220016_3_, CrossbowItemMixin.getArrow(p_220016_0_, p_220016_1_, p_220016_3_, p_220016_4_));
            if (p_220016_6_) {
                projectileentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            if (p_220016_1_ instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowUser = (CrossbowAttackMob)p_220016_1_;
                crossbowUser.m_5811_(crossbowUser.m_5448_(), p_220016_3_, (Projectile)projectileentity, 0.0f);
            } else {
                Vec3 vec31 = p_220016_1_.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                Vec3 vec3 = p_220016_1_.m_20252_(1.0f);
                Vector3f vector3f = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
                projectileentity.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), p_220016_7_, p_220016_8_);
            }
            p_220016_3_.m_41622_(1, p_220016_1_, p_220017_1_ -> p_220017_1_.m_21190_(p_220016_2_));
            if (this.isInfinit(p_220016_3_)) {
                projectileentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            p_220016_0_.m_7967_((Entity)projectileentity);
            p_220016_0_.m_6263_((Player)null, p_220016_1_.m_20185_(), p_220016_1_.m_20186_(), p_220016_1_.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, p_220016_5_);
        }
    }

    protected AbstractArrow modifyArrow(ItemStack stack, AbstractArrow arrowEntity) {
        int k;
        int j;
        if (this.ignoreHurtTimer(stack) && arrowEntity instanceof IEntityCrossbowArrow) {
            ((IEntityCrossbowArrow)arrowEntity).setIgnoreHurtTimer();
        }
        if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
            arrowEntity.m_36781_(arrowEntity.m_36789_() + (double)j * 0.2 + 0.2);
        }
        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
            arrowEntity.m_36735_(k);
        }
        return arrowEntity;
    }

    protected boolean ignoreHurtTimer(ItemStack crossbow) {
        return false;
    }

    public float getShootingPowerMod(ItemStack crossbow) {
        return 3.15f * this.arrowVelocity;
    }

    public void m_5551_(@Nonnull ItemStack p_77615_1_, @Nonnull Level p_77615_2_, @Nonnull LivingEntity p_77615_3_, int p_77615_4_) {
        int i = this.m_8105_(p_77615_1_) - p_77615_4_;
        float f = this.getPowerForTimeMod(i, p_77615_1_);
        if (f >= 1.0f && !VampirismCrossbowItem.m_40932_((ItemStack)p_77615_1_) && this.tryLoadProjectilesMod(p_77615_3_, p_77615_1_)) {
            VampirismCrossbowItem.m_40884_((ItemStack)p_77615_1_, (boolean)true);
            SoundSource soundcategory = p_77615_3_ instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            p_77615_2_.m_6263_(null, p_77615_3_.m_20185_(), p_77615_3_.m_20186_(), p_77615_3_.m_20189_(), SoundEvents.f_11841_, soundcategory, 1.0f, 1.0f / (p_77615_2_.f_46441_.m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public float getPowerForTimeMod(int p_220031_0_, ItemStack p_220031_1_) {
        float f = (float)p_220031_0_ / (float)this.getChargeDurationMod(p_220031_1_);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public int getChargeDurationMod(ItemStack crossbow) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)crossbow);
        return i == 0 ? this.chargeTime : this.chargeTime - 2 * i;
    }

    protected void setUncharged(Player player, ItemStack stack) {
        int frugal = this.isFrugal(stack);
        if (frugal > 0 && player.m_217043_().m_188503_(Math.max(2, 4 - frugal)) == 0) {
            return;
        }
        VampirismCrossbowItem.m_40884_((ItemStack)stack, (boolean)false);
    }

    protected int isFrugal(ItemStack crossbow) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.CROSSBOWFRUGALITY.get()), (ItemStack)crossbow);
    }

    protected boolean isInfinit(ItemStack crossbow) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)crossbow) > 0;
    }

    protected boolean canBeInfinit(ItemStack crossbow) {
        return true;
    }

    protected boolean tryLoadProjectilesMod(LivingEntity entity, ItemStack crossbow) {
        boolean flag = entity instanceof Player && ((Player)entity).m_150110_().f_35937_;
        ItemStack projectile = entity.m_6298_(crossbow);
        if (projectile.m_41619_() && flag) {
            projectile = new ItemStack((ItemLike)ModItems.CROSSBOW_ARROW_NORMAL.get());
        }
        if (this.canBeInfinit(crossbow) && this.isInfinit(crossbow) && projectile.m_41720_() instanceof IVampirismCrossbowArrow && ((IVampirismCrossbowArrow)projectile.m_41720_()).isCanBeInfinite()) {
            projectile = projectile.m_41777_();
        }
        return this.loadProjectileMod(entity, crossbow, projectile, false, flag);
    }

    protected boolean loadProjectileMod(LivingEntity p_220023_0_, ItemStack p_220023_1_, ItemStack p_220023_2_, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (p_220023_2_.m_41619_()) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && p_220023_2_.m_41720_() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            itemstack = p_220023_2_.m_41620_(1);
            if (p_220023_2_.m_41619_() && p_220023_0_ instanceof Player) {
                ((Player)p_220023_0_).m_150109_().m_36057_(p_220023_2_);
            }
        } else {
            itemstack = p_220023_2_.m_41777_();
        }
        if (itemstack.m_41720_() instanceof IArrowContainer) {
            for (ItemStack arrow : ((IArrowContainer)itemstack.m_41720_()).getArrows(itemstack)) {
                CrossbowItemMixin.addChargedProjectile(p_220023_1_, arrow);
            }
        } else {
            CrossbowItemMixin.addChargedProjectile(p_220023_1_, itemstack);
        }
        return true;
    }
}

