/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.mojang.datafixers.util.Either;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ServerboundToggleActionPacket(ResourceLocation actionId, @Nullable Either<Integer, BlockPos> target) implements IMessage.IServerBoundMessage
{
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundToggleActionPacket(ResourceLocation actionId, @Nullable Integer target) {
        this(actionId, (Either<Integer, BlockPos>)Either.left((Object)target));
    }

    public ServerboundToggleActionPacket(ResourceLocation actionId, @Nullable BlockPos target) {
        this(actionId, (Either<Integer, BlockPos>)Either.right((Object)target));
    }

    public ServerboundToggleActionPacket(ResourceLocation actionId) {
        this(actionId, (Either<Integer, BlockPos>)((Either)null));
    }

    @NotNull
    public static ServerboundToggleActionPacket createFromRaytrace(ResourceLocation action, @Nullable HitResult traceResult) {
        if (traceResult != null) {
            if (traceResult.m_6662_() == HitResult.Type.ENTITY) {
                return new ServerboundToggleActionPacket(action, ((EntityHitResult)traceResult).m_82443_().m_19879_());
            }
            if (traceResult.m_6662_() == HitResult.Type.BLOCK) {
                return new ServerboundToggleActionPacket(action, ((BlockHitResult)traceResult).m_82425_());
            }
        }
        return new ServerboundToggleActionPacket(action);
    }

    static void encode(@NotNull ServerboundToggleActionPacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130085_(msg.actionId);
        if (msg.target != null) {
            buf.writeBoolean(true);
            msg.target.ifLeft(i -> {
                buf.writeBoolean(true);
                buf.m_130130_(i.intValue());
            });
            msg.target.ifRight(p -> {
                buf.writeBoolean(false);
                buf.m_130064_(p);
            });
        } else {
            buf.writeBoolean(false);
        }
    }

    @NotNull
    static ServerboundToggleActionPacket decode(@NotNull FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        Either target = null;
        if (buf.readBoolean()) {
            target = buf.readBoolean() ? Either.left((Object)buf.m_130242_()) : Either.right((Object)buf.m_130135_());
        }
        return new ServerboundToggleActionPacket(id, target);
    }

    static void handle(@NotNull ServerboundToggleActionPacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayer player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            Optional factionPlayerOpt = FactionPlayerHandler.getOpt((Player)player).map(FactionPlayerHandler::getCurrentFactionPlayer).orElseGet(Optional::empty);
            factionPlayerOpt.ifPresent(factionPlayer -> {
                ActionHandler.ActivationContext context = msg.target != null ? (IAction.ActivationContext)msg.target.map(entityId -> {
                    Entity e = player.m_20193_().m_6815_(entityId.intValue());
                    if (e == null) {
                        LOGGER.warn("Could not find entity {} the player was looking at when toggling action", entityId);
                    }
                    return new ActionHandler.ActivationContext(e);
                }, ActionHandler.ActivationContext::new) : new ActionHandler.ActivationContext();
                IActionHandler<?> actionHandler = factionPlayer.getActionHandler();
                IAction<?> action = RegUtil.getAction(msg.actionId);
                if (action != null) {
                    IAction.PERM r = actionHandler.toggleAction(action, context);
                    switch (r) {
                        case NOT_UNLOCKED: {
                            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.action.not_unlocked"), true);
                            break;
                        }
                        case DISABLED: {
                            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.action.deactivated_by_serveradmin"), false);
                            break;
                        }
                        case COOLDOWN: {
                            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.action.cooldown_not_over"), true);
                            break;
                        }
                        case DISALLOWED: {
                            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.action.disallowed"), true);
                            break;
                        }
                        case PERMISSION_DISALLOWED: {
                            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.action.permission_disallowed"), false);
                            break;
                        }
                    }
                } else {
                    LOGGER.error("Failed to find action with id {}", (Object)msg.actionId);
                }
            });
        });
        ctx.setPacketHandled(true);
    }
}

