/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.recipes.AbstractBrewingRecipe;
import de.teamlapen.vampirism.recipes.VampirismRecipeHelper;
import de.teamlapen.vampirism.util.RegUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyTableRecipe
extends AbstractBrewingRecipe {
    private final ISkill<?>[] requiredSkills;

    public AlchemyTableRecipe(ResourceLocation id, String group, Ingredient ingredient, Ingredient input, ItemStack result, ISkill<?>[] skills) {
        super((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get(), id, group, ingredient, input, result);
        this.requiredSkills = skills;
    }

    public boolean isInput(@NotNull ItemStack input) {
        return UtilLib.matchesItem(this.input, input);
    }

    public boolean isIngredient(@NotNull ItemStack ingredient) {
        return this.ingredient.test(ingredient);
    }

    @NotNull
    public ItemStack getResult(@NotNull ItemStack input, @NotNull ItemStack ingredient) {
        return this.isInput(input) && this.isIngredient(ingredient) ? this.result.m_41777_() : ItemStack.f_41583_;
    }

    public ISkill<?>[] getRequiredSkills() {
        return this.requiredSkills;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ALCHEMICAL_TABLE.get();
    }

    public static class Serializer
    implements RecipeSerializer<AlchemyTableRecipe> {
        @NotNull
        public AlchemyTableRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            ISkill<?>[] skills = VampirismRecipeHelper.deserializeSkills(GsonHelper.m_13832_((JsonObject)json, (String)"skill", null));
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new AlchemyTableRecipe(recipeId, group, ingredient, input, result, skills);
        }

        @Nullable
        public AlchemyTableRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            ItemStack result = buffer.m_130267_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ISkill[] skills = new ISkill[buffer.m_130242_()];
            if (skills.length != 0) {
                for (int i = 0; i < skills.length; ++i) {
                    skills[i] = RegUtil.getSkill(new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE)));
                }
            }
            return new AlchemyTableRecipe(recipeId, group, ingredient, input, result, skills);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull AlchemyTableRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130055_(recipe.result);
            recipe.ingredient.m_43923_(buffer);
            recipe.input.m_43923_(buffer);
            buffer.m_130130_(recipe.requiredSkills.length);
            for (ISkill<?> skill : recipe.requiredSkills) {
                buffer.m_130085_(RegUtil.id(skill));
            }
        }
    }
}

