/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.items.enchantment.EnchantmentVampireSlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import org.jetbrains.annotations.NotNull;

public class MixinHooks {
    private static final List<String> onlyOneStructure = Lists.newArrayList();
    public static boolean enforcingGlowing_bloodVision = false;

    public static void addSingleInstanceStructure(@NotNull List<ResourceLocation> structures) {
        onlyOneStructure.addAll(structures.stream().map(MixinHooks::singleJigsawString).toList());
    }

    public static boolean checkStructures(@NotNull List<? super PoolElementStructurePiece> pieces, @NotNull StructurePoolElement jigsawPiece) {
        if (!onlyOneStructure.contains(jigsawPiece.toString())) {
            return false;
        }
        return pieces.stream().anyMatch(structurePiece -> onlyOneStructure.stream().anyMatch(string -> ((PoolElementStructurePiece)structurePiece).m_209918_().toString().equals(string)));
    }

    public static float calculateVampireSlayerEnchantments(Entity entity, @NotNull ItemStack item) {
        if (!(entity instanceof Player)) {
            return 0.0f;
        }
        if (!Helper.isVampire(entity)) {
            return 0.0f;
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)item);
        if (!enchantments.containsKey(ModEnchantments.VAMPIRESLAYER.get())) {
            return 0.0f;
        }
        return ((EnchantmentVampireSlayer)((Object)ModEnchantments.VAMPIRESLAYER.get())).m_7335_((Integer)enchantments.get(ModEnchantments.VAMPIRESLAYER.get()), VReference.VAMPIRE_CREATURE_ATTRIBUTE);
    }

    @NotNull
    private static String singleJigsawString(@NotNull ResourceLocation resourceLocation) {
        return "Single[Left[" + resourceLocation + "]]";
    }
}

