/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api;

import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.ISundamageRegistry;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionManager;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.player.actions.IActionManager;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillManager;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVisionRegistry;
import de.teamlapen.vampirism.api.items.IExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.api.world.IVampirismWorld;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class VampirismAPI {
    private static boolean INIT;
    private static final Capability<IExtendedCreatureVampirism> CAP_CREATURE;
    private static final Capability<IFactionPlayerHandler> CAP_FACTION_HANDLER_PLAYER;
    private static final Capability<IVampirismWorld> CAP_WORLD;
    private static final Capability<IVampirePlayer> CAP_VAMPIRE;
    private static final Capability<IHunterPlayer> CAP_HUNTER;
    private static IFactionRegistry factionRegistry;
    private static ISundamageRegistry sundamageRegistry;
    private static IVampirismEntityRegistry entityRegistry;
    private static IVampireVisionRegistry vampireVisionRegistry;
    private static ISkillManager skillManager;
    private static IActionManager actionManager;
    private static IEntityActionManager entityActionManager;
    private static IExtendedBrewingRecipeRegistry extendedBrewingRecipeRegistry;

    public static ISkillManager skillManager() {
        return skillManager;
    }

    public static IActionManager actionManager() {
        return actionManager;
    }

    public static IEntityActionManager entityActionManager() {
        return entityActionManager;
    }

    public static IVampireVisionRegistry vampireVisionRegistry() {
        return vampireVisionRegistry;
    }

    public static IFactionRegistry factionRegistry() {
        return factionRegistry;
    }

    public static ISundamageRegistry sundamageRegistry() {
        return sundamageRegistry;
    }

    public static IVampirismEntityRegistry entityRegistry() {
        return entityRegistry;
    }

    public static IExtendedBrewingRecipeRegistry extendedBrewingRecipeRegistry() {
        return extendedBrewingRecipeRegistry;
    }

    @ApiStatus.Internal
    public static void setUpRegistries(IFactionRegistry factionRegistryIn, ISundamageRegistry sundamageRegistryIn, IVampirismEntityRegistry entityRegistryIn, IActionManager actionManagerIn, ISkillManager skillManagerIn, IVampireVisionRegistry vampireVisionRegistryIn, IEntityActionManager entityActionManagerIn, IExtendedBrewingRecipeRegistry extendedBrewingRecipeRegistryIn) {
        if (INIT) {
            throw new IllegalStateException("Vampirism API can only be setup once");
        }
        factionRegistry = factionRegistryIn;
        sundamageRegistry = sundamageRegistryIn;
        entityRegistry = entityRegistryIn;
        actionManager = actionManagerIn;
        skillManager = skillManagerIn;
        vampireVisionRegistry = vampireVisionRegistryIn;
        entityActionManager = entityActionManagerIn;
        extendedBrewingRecipeRegistry = extendedBrewingRecipeRegistryIn;
        INIT = true;
    }

    @ApiStatus.Internal
    public static void onSetupComplete() {
    }

    @NotNull
    public static LazyOptional<IFactionPlayerHandler> getFactionPlayerHandler(@NotNull Player player) {
        return player.getCapability(CAP_FACTION_HANDLER_PLAYER, null);
    }

    @NotNull
    public static LazyOptional<IVampirePlayer> getVampirePlayer(@NotNull Player player) {
        return player.getCapability(CAP_VAMPIRE, null);
    }

    @NotNull
    public static LazyOptional<IHunterPlayer> getHunterPlayer(@NotNull Player player) {
        return player.getCapability(CAP_HUNTER, null);
    }

    @NotNull
    public static LazyOptional<IExtendedCreatureVampirism> getExtendedCreatureVampirism(@NotNull PathfinderMob creature) {
        return creature.getCapability(CAP_CREATURE, null);
    }

    @NotNull
    public static LazyOptional<IVampirismWorld> getVampirismWorld(@NotNull Level w) {
        return w.getCapability(CAP_WORLD);
    }

    static {
        CAP_CREATURE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IExtendedCreatureVampirism>(){});
        CAP_FACTION_HANDLER_PLAYER = CapabilityManager.get((CapabilityToken)new CapabilityToken<IFactionPlayerHandler>(){});
        CAP_WORLD = CapabilityManager.get((CapabilityToken)new CapabilityToken<IVampirismWorld>(){});
        CAP_VAMPIRE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IVampirePlayer>(){});
        CAP_HUNTER = CapabilityManager.get((CapabilityToken)new CapabilityToken<IHunterPlayer>(){});
    }
}

